/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.CalibratedReflectanceTargetList;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public abstract class RemoteCameraTypeSettings<T extends RemoteCameraTypeSettings<T>>
implements CameraType.CameraTypeSettings {
    private CameraType.CameraTypeList cameraTypeList;
    protected final RemoteCamera<T> camera;
    private String formattedCameraType;
    private FrameCount frameCount;
    private CalibratedReflectanceTargetList wriList = null;

    public RemoteCameraTypeSettings(RemoteCamera<T> remoteCamera) {
        this.camera = remoteCamera;
    }

    protected boolean isConnected() {
        return this.camera.isConnected();
    }

    @Override
    public final void changeCameraType(CameraType cameraType) {
        BreezeProperties.getInstance().setCameraProperty(this.camera, "type", cameraType.getName());
    }

    @Override
    public CameraType getCameraType() {
        return CameraType.fromXml(BreezeProperties.getInstance().getCameraProperty(this.camera, "type", "FileReader"));
    }

    @Override
    public final CameraType.CameraTypeList listCameraNames() {
        if (this.cameraTypeList == null) {
            this.cameraTypeList = TcpManager.getInstance().getCameraTypes(this.camera, this.getListCameraNamesArguments());
            if (this.cameraTypeList.isEmpty()) {
                ToastHandler.getInstance().showToast("No sensors for " + String.valueOf(this.camera) + " detected", Toast.IconType.Warning, new Time.Seconds(10.0));
            }
        }
        return this.cameraTypeList;
    }

    protected List<Command.Argument> getListCameraNamesArguments() {
        return null;
    }

    @Override
    public final void clearCameraList() {
        this.cameraTypeList = null;
    }

    public void clear() {
        this.wriList = null;
        this.frameCount = null;
        this.formattedCameraType = null;
        if (this.camera != null && this.camera.remoteSettings != null) {
            this.camera.remoteSettings.clear();
        }
    }

    protected File getWavelengthFile() {
        String string = BreezeProperties.getInstance().getCameraProperty(this.camera, "wavelengthFile", "wlcalswir.wls");
        WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
        if (workspace != null) {
            File file = workspace.getPath().toFile();
            File file2 = new File(file, string);
            if (file2.exists()) {
                return file2;
            }
            file2 = new File(workspace.getDataPath(), string);
            if (file2.exists()) {
                return file2;
            }
        }
        return null;
    }

    public final float getOffset() {
        return BreezeProperties.getInstance().getCameraTypePropertyFloat(this.camera, this.getCameraType(), "offset", 0.0f);
    }

    public final void setOffset(float f) {
        BreezeProperties.getInstance().setCameraTypePropertyFloat(this.camera, this.getCameraType(), "offset", f);
    }

    public final int getBinningSpatial() {
        return BreezeProperties.getInstance().getCameraTypePropertyInt(this.camera, this.getCameraType(), "binningSpatial", 1);
    }

    public final void setBinningSpatial(int n) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "binningSpatial", String.valueOf(n));
    }

    public final int getBinningSpectral() {
        return BreezeProperties.getInstance().getCameraTypePropertyInt(this.camera, this.getCameraType(), "binningSpectral", 1);
    }

    public final void setBinningSpectral(int n) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "binningSpectral", String.valueOf(n));
    }

    public final String getRgbBands() {
        return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "rgbBands", "");
    }

    public final void setRgbBands(String string) {
        BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "rgbBands", string);
    }

    public final FrameCount getHeight() {
        if (this.frameCount == null) {
            this.frameCount = new FrameCount(RtDataFormat.toNumberInt(TcpManager.getInstance().getCameraProperty(this.camera, "ImageLines")));
        }
        return this.frameCount;
    }

    public final void setFlipPixels(boolean bl) {
        BreezeProperties.getInstance().setCameraProperty(this.camera, "flipPixels", Boolean.toString(bl));
    }

    public final boolean isFlipPixels() {
        return BreezeProperties.getInstance().getCameraPropertyBool(this.camera, "flipPixels", false);
    }

    public final String getSerialNo() {
        return TcpManager.getInstance().getCameraProperty(this.camera, "SerialNo");
    }

    public final String getFormattedCameraType(String string) {
        if (this.formattedCameraType == null && this.camera.isConnected()) {
            this.formattedCameraType = TcpManager.getInstance().getCameraProperty(this.camera, "FormattedCameraType");
        }
        if (this.formattedCameraType != null) {
            return this.formattedCameraType;
        }
        return string;
    }

    public final void setWhiteReferenceTargetFile(File file) {
        BreezeProperties.getInstance().setCameraFile(this.camera, "referenceTargetFile", file);
        if (this.camera.isConnected()) {
            TcpManager.getInstance().setCameraProperty(this.camera, "ReferenceTargetFile", FileHelper.getAbsolutePathOrEmpty(file));
        }
        this.clear();
    }

    public File getWhiteReferenceTargetFile() {
        return BreezeProperties.getInstance().getCameraFile(this.camera, "referenceTargetFile", null);
    }

    private CalibratedReflectanceTargetList getWhiteReferenceIntensityList() {
        if (this.wriList == null) {
            this.wriList = CalibratedReflectanceTargetList.fromTargetFile(this.getWhiteReferenceTargetFile());
        }
        return this.wriList;
    }

    public final RtReferenceTarget getReferenceTarget() {
        CalibratedReflectanceTargetList calibratedReflectanceTargetList = this.getWhiteReferenceIntensityList();
        if (calibratedReflectanceTargetList != null) {
            return calibratedReflectanceTargetList.getReferenceTarget(this.camera.getBandNames());
        }
        return null;
    }

    public List<Command.Argument> getArguments() {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("BinningSpatial", (Object)this.getBinningSpatial()));
        arrayList.add(new Command.Argument("BinningSpectral", (Object)this.getBinningSpectral()));
        arrayList.add(new Command.Argument("RgbBands", (Object)this.getRgbBands()));
        if (this.camera.canChangeView()) {
            arrayList.add(new Command.Argument("FieldOfView", (Object)Float.valueOf(this.camera.getFieldOfView().value)));
        }
        arrayList.add(new Command.Argument("FlipPixels", (Object)this.isFlipPixels()));
        arrayList.add(new Command.Argument("Offset", (Object)Float.valueOf(this.getOffset())));
        File file = this.getWavelengthFile();
        if (file != null) {
            arrayList.add(new Command.Argument("WavelengthFile", file));
        }
        return arrayList;
    }
}

