/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.camera.component.IScanMode;
import se.prediktera.breeze.hardware.tcp.Command;

public class SonyCamera
extends RemoteCamera<SonyCameraSettings>
implements StateCamera,
Camera.SnapshotCamera {
    @Override
    public FrameCount getHeight() {
        return new FrameCount(6336);
    }

    @Override
    public boolean hasShutter() {
        return true;
    }

    @Override
    public boolean hasWhiteReference() {
        return false;
    }

    @Override
    public Camera.CameraCaptureType getType() {
        return Camera.CameraCaptureType.Snapshot;
    }

    @Override
    public boolean isIntegrationTimeFixed() {
        return true;
    }

    @Override
    public boolean isFrameRateFixed() {
        return true;
    }

    @Override
    public boolean isFieldOfViewFixed() {
        return true;
    }

    @Override
    protected SonyCameraSettings createSettings() {
        return new SonyCameraSettings(this);
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(settingsPanelCallback);
    }

    @Override
    public String getDeviceName() {
        return "SonyCamera";
    }

    public String toString() {
        return "Sony Camera";
    }

    @Override
    public String getDisplayName() {
        return "Sony ICLE-7RM5";
    }

    @Override
    public String getXmlNodeName() {
        return "Sony";
    }

    @Override
    public boolean canChangeLength() {
        return false;
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Mode", this.getType().toString());
        informationList.add("Serial no", ((SonyCameraSettings)this.settings).getSerialNo());
        informationList.add("CameraHeight", this.getHeight().value);
        if (((SonyCameraSettings)this.settings).useServerCameraForTest()) {
            informationList.add("Using server test camera", "true");
        }
    }

    @Override
    public MeasurementLength getMeasurementLength() {
        return new MeasurementLength(6336.0f, MeasurementLength.LengthUnit.frames);
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return false;
    }

    public class SonyCameraSettings
    extends RemoteCameraTypeSettingsWithRoi<SonyCameraSettings>
    implements IScanMode {
        public SonyCameraSettings(RemoteCamera<SonyCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public boolean fixedLength() {
            return true;
        }

        public boolean useServerCameraForTest() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(SonyCamera.this, this.getCameraType(), "useServerCameraForTest", false);
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
            if (this.useServerCameraForTest()) {
                arrayList.add(new Command.Argument("UseServerCameraForTest", (Object)"true"));
            }
            return arrayList;
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            if (this.useServerCameraForTest()) {
                list.add(new Command.Argument("UseServerCameraForTest", (Object)"true"));
            }
            return list;
        }

        @Override
        public void setFixedLength(boolean bl) {
        }
    }

    private class SettingsPanel
    extends JPanel {
        public SettingsPanel(Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            if (!SonyCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, SonyCamera.this.settings));
            }
        }
    }
}

