/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.component.RgbBandsInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.util.FileFromAbsolutePath;
import se.prediktera.breeze.util.type.Binning;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class SpecimCamera
extends RemoteCamera<SpecSensorSettings> {
    @Override
    protected SpecSensorSettings createSettings() {
        return new SpecSensorSettings(this);
    }

    @Override
    public boolean hasShutter() {
        return ((SpecSensorSettings)this.settings).hasShutter();
    }

    @Override
    public MaxSignal getMaxsignal() {
        if (this.isOldSwirCamera()) {
            return new MaxSignal(16384.0f);
        }
        return super.getMaxsignal();
    }

    private boolean isOldSwirCamera() {
        return ((SpecSensorSettings)this.settings).getCameraType().getName().equals("SWIR with NI");
    }

    @Override
    public SettingsPanel getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    public String toString() {
        return "Specim LUMO SDK";
    }

    @Override
    public String getXmlNodeName() {
        return "SpecSensor";
    }

    @Override
    public String getDeviceName() {
        return "SpecimCamera";
    }

    @Override
    public RgbBands getRgbBands() {
        RgbBands rgbBands = RgbBands.fromCommaSeparatedString(((SpecSensorSettings)this.settings).getRgbBands());
        if (rgbBands.size() > 0) {
            return rgbBands;
        }
        return super.getRgbBands();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        String string = ((SpecSensorSettings)this.settings).getFilePath();
        File file = ((SpecSensorSettings)this.settings).getBadPixelsFile();
        informationList.add("Calibration file", string != null && !string.isEmpty() ? string : "N/A");
        informationList.add("Bad pixel file", file != null ? file.getAbsolutePath() : "N/A");
        if (BreezeFrame.development) {
            informationList.add("Binning", ((SpecSensorSettings)this.settings).binning().toString());
        }
        if (((SpecSensorSettings)this.settings).isTemperature()) {
            informationList.add("Temperature", this.getTemperature().toString());
        }
    }

    protected class SpecSensorSettings
    extends RemoteCameraTypeSettings<SpecSensorSettings> {
        private Binning binning;

        public SpecSensorSettings(RemoteCamera<SpecSensorSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public void clear() {
            super.clear();
            this.binning = null;
        }

        public Binning binning() {
            String string;
            if (this.binning == null && (string = SpecimCamera.this.remoteSettings.getCameraProperty("Binnings")) != null && !string.isEmpty()) {
                this.binning = new Binning(string);
            }
            return this.binning;
        }

        public boolean hasShutter() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(SpecimCamera.this, this.getCameraType(), "shutter", true);
        }

        public void setShutter(boolean bl) {
            BreezeProperties.getInstance().setCameraTypeProperty(SpecimCamera.this, this.getCameraType(), "shutter", Boolean.toString(bl));
        }

        public String getFilePath() {
            File file = this.getFile();
            if (file != null) {
                if (!file.exists()) {
                    throw new FileNotFoundException("Calibration file path is invalid: " + file.getAbsolutePath());
                }
                return file.getAbsolutePath();
            }
            return "";
        }

        public File getFile() {
            return BreezeProperties.getInstance().getCameraTypeFile(SpecimCamera.this, this.getCameraType(), "scpFile");
        }

        public void setFile(File file) {
            BreezeProperties.getInstance().setCameraTypeFile(SpecimCamera.this, this.getCameraType(), "scpFile", file);
            this.camera.remoteSettings.clear();
        }

        public File getBadPixelsFile() {
            return BreezeProperties.getInstance().getCameraTypeFile(SpecimCamera.this, this.getCameraType(), "badPixelsFile");
        }

        public void setBadPixelsFile(File file) {
            BreezeProperties.getInstance().setCameraTypeFile(SpecimCamera.this, this.getCameraType(), "badPixelsFile", file);
            this.camera.remoteSettings.clear();
        }

        public int getMaxLag() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(SpecimCamera.this, this.getCameraType(), "maxLag", 0);
        }

        public void setMaxLag(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(SpecimCamera.this, this.getCameraType(), "maxLag", String.valueOf(n));
        }

        public File getPlaybackFile() {
            return null;
        }

        public boolean isDataCallback() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(SpecimCamera.this, this.getCameraType(), "dataCallback", false);
        }

        public void setDataCallback(boolean bl) {
            BreezeProperties.getInstance().setCameraTypeProperty(SpecimCamera.this, this.getCameraType(), "dataCallback", String.valueOf(bl));
        }

        public boolean isTemperature() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(SpecimCamera.this, this.getCameraType(), "temperature", false);
        }

        public void setTemperature(boolean bl) {
            BreezeProperties.getInstance().setCameraTypeProperty(SpecimCamera.this, this.getCameraType(), "temperature", String.valueOf(bl));
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("ScpFilePath", (Object)this.getFilePath()));
            list.add(new Command.Argument("BpFilePath", this.getBadPixelsFile() != null ? this.getBadPixelsFile().getAbsolutePath() : null));
            list.add(new Command.Argument("DataCallback", (Object)this.isDataCallback()));
            list.add(new Command.Argument("Delayed", (Object)false));
            list.add(new Command.Argument("Temperature", (Object)this.isTemperature()));
            File file = this.getPlaybackFile();
            if (file != null) {
                list.add(new Command.Argument("PlaybackFile", file));
            }
            return list;
        }
    }

    public class SettingsPanel
    extends JPanel {
        private final AdvancedPanel advancedPanel;

        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            this.advancedPanel = new AdvancedPanel(breezeFrame, settingsPanelCallback);
            if (!SpecimCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, SpecimCamera.this.settings, cameraType -> this.advancedPanel.typeChanged()));
            }
            if (SpecimCamera.this.isConnected()) {
                InputFieldHelper.addWarningsPanel(this, SpecimCamera.this.remoteSettings);
            }
            InputFieldHelper.addPanel(this, this.advancedPanel);
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            private BreezeCheckBoxInputField shutterCheckBox;
            private CalibrationFileInputFile calibrationFileInputFile;
            private BadPixelsFileInputFile badPixelsFileInputFile;

            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced");
                if (!SpecimCamera.this.isConnected()) {
                    this.addPanel(new Camera.MirrorLineInputField(SpecimCamera.this.settings));
                    this.shutterCheckBox = new BreezeCheckBoxInputField("Shutter available for camera type", ((SpecSensorSettings)SpecimCamera.this.settings).hasShutter(), ((SpecSensorSettings)SpecimCamera.this.settings)::setShutter);
                    this.addPanel(this.shutterCheckBox);
                    this.addPanel(new BreezeCheckBoxInputField("Use data callback", ((SpecSensorSettings)SpecimCamera.this.settings).isDataCallback(), ((SpecSensorSettings)SpecimCamera.this.settings)::setDataCallback));
                    this.addPanel(new BreezeCheckBoxInputField("Use temperature sensor", ((SpecSensorSettings)SpecimCamera.this.settings).isTemperature(), ((SpecSensorSettings)SpecimCamera.this.settings)::setTemperature));
                    this.calibrationFileInputFile = new CalibrationFileInputFile((Component)breezeFrame, ((SpecSensorSettings)SpecimCamera.this.settings).getFile(), textActionEvent -> ((SpecSensorSettings)settingsPanel.SpecimCamera.this.settings).setFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull()));
                    this.addPanel(this.calibrationFileInputFile);
                    this.badPixelsFileInputFile = new BadPixelsFileInputFile((Component)breezeFrame, ((SpecSensorSettings)SpecimCamera.this.settings).getBadPixelsFile(), textActionEvent -> ((SpecSensorSettings)settingsPanel.SpecimCamera.this.settings).setBadPixelsFile(new FileFromAbsolutePath(textActionEvent.getText()).fileOrNull()));
                    this.addPanel(this.badPixelsFileInputFile);
                    this.addPanel(new BreezeInputField.Number("Max lag", ((SpecSensorSettings)SpecimCamera.this.settings).getMaxLag(), ""), (TextActionEvent textActionEvent) -> ((SpecSensorSettings)settingsPanel.SpecimCamera.this.settings).setMaxLag(textActionEvent.getValueInt()));
                    this.addPanel(new RgbBandsInputField(breezeFrame, ((SpecSensorSettings)SpecimCamera.this.settings).getRgbBands(), textActionEvent -> ((SpecSensorSettings)settingsPanel.SpecimCamera.this.settings).setRgbBands(textActionEvent.getText())));
                }
                this.addPanel(new Camera.OffsetInputField(breezeFrame, SpecimCamera.this, settingsPanelCallback));
            }

            public void typeChanged() {
                if (this.calibrationFileInputFile != null) {
                    this.calibrationFileInputFile.setFile(((SpecSensorSettings)SpecimCamera.this.settings).getFile());
                }
                if (this.badPixelsFileInputFile != null) {
                    this.badPixelsFileInputFile.setFile(((SpecSensorSettings)SpecimCamera.this.settings).getBadPixelsFile());
                }
                if (this.shutterCheckBox != null) {
                    this.shutterCheckBox.setSelected(((SpecSensorSettings)SpecimCamera.this.settings).hasShutter());
                }
            }

            private static class CalibrationFileInputFile
            extends FileInputField {
                public CalibrationFileInputFile(Component component, File file, TextActionEvent.TextActionListener textActionListener) {
                    super(component, "Calibration file", file, textActionListener, true);
                }

                @Override
                protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
                    jopensaveDialog2.addExtension("scp", "Specim calibration pack file (*.scp)");
                }
            }
        }

        public static class BadPixelsFileInputFile
        extends FileInputField {
            public BadPixelsFileInputFile(Component component, File file, TextActionEvent.TextActionListener textActionListener) {
                super(component, "Bad pixels file", file, textActionListener, true);
            }

            @Override
            protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
                jopensaveDialog2.addExtension("bpr", "Specim bad pixels raw file (*.bpr)");
            }
        }
    }
}

