/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.validator.RegexValidator;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.camera.component.BinningInputField;
import se.prediktera.breeze.hardware.camera.component.NetworkAdapterIPComboBoxInputField;
import se.prediktera.breeze.hardware.camera.component.RgbBandsInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class SpecimJsonRpcCamera
extends RemoteCamera<SpecimJsonRpcCameraSettings>
implements StateCamera {
    @Override
    protected SpecimJsonRpcCameraSettings createSettings() {
        return new SpecimJsonRpcCameraSettings(this);
    }

    @Override
    public boolean hasShutter() {
        return ((SpecimJsonRpcCameraSettings)this.settings).hasShutter();
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    public String toString() {
        return "Generic Camera";
    }

    @Override
    public String getDisplayName() {
        return "Specim FX50";
    }

    @Override
    public String getXmlNodeName() {
        return "Generic";
    }

    @Override
    public String getDeviceName() {
        return "SpecimJsonRpcCamera";
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return ((SpecimJsonRpcCameraSettings)this.settings).hasReference();
    }

    @Override
    public boolean autoChangeState() {
        return ((SpecimJsonRpcCameraSettings)this.settings).useServerCameraForTest();
    }

    @Override
    public boolean hasWhiteReference() {
        return ((SpecimJsonRpcCameraSettings)this.settings).useServerCameraForTest();
    }

    @Override
    public RgbBands getRgbBands() {
        RgbBands rgbBands = RgbBands.fromCommaSeparatedString(((SpecimJsonRpcCameraSettings)this.settings).getRgbBands());
        if (rgbBands.size() > 0) {
            return rgbBands;
        }
        return super.getRgbBands();
    }

    protected List<Command.Argument> getCameraNamesArguments() {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("HostIp", (Object)((SpecimJsonRpcCameraSettings)this.settings).getHostIp()));
        if (((SpecimJsonRpcCameraSettings)this.settings).useServerCameraForTest()) {
            ToastHandler.getInstance().showToast("USING TEST SERVER", Toast.IconType.Warning);
            arrayList.add(new Command.Argument("UseServerCameraForTest", (Object)"true"));
        }
        return arrayList;
    }

    public class SpecimJsonRpcCameraSettings
    extends RemoteCameraTypeSettings<SpecimJsonRpcCameraSettings>
    implements NetworkAdapterIPComboBoxInputField.NetworkAdapterIPSettings {
        private Boolean hasReference;

        public SpecimJsonRpcCameraSettings(RemoteCamera<SpecimJsonRpcCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public void clear() {
            super.clear();
            this.hasReference = null;
        }

        public boolean hasShutter() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(SpecimJsonRpcCamera.this, this.getCameraType(), "shutter", true);
        }

        public void setShutter(boolean bl) {
            BreezeProperties.getInstance().setCameraTypeProperty(SpecimJsonRpcCamera.this, this.getCameraType(), "shutter", Boolean.toString(bl));
        }

        @Override
        public String getHostIp() {
            return BreezeProperties.getInstance().getCameraTypeProperty(SpecimJsonRpcCamera.this, this.getCameraType(), "hostIp", "127.0.0.1");
        }

        @Override
        public void setHostIp(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(SpecimJsonRpcCamera.this, this.getCameraType(), "hostIp", string);
        }

        public boolean hasReference() {
            if (this.hasReference == null) {
                this.hasReference = Boolean.parseBoolean(TcpManager.getInstance().getCameraProperty(this.camera, "HasReference"));
            }
            return this.hasReference;
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            if (this.useServerCameraForTest()) {
                list.add(new Command.Argument("UseServerCameraForTest", (Object)"true"));
            }
            list.add(new Command.Argument("HostIp", (Object)this.getHostIp()));
            list.add(new Command.Argument("BufferSize", (Object)this.getBufferSize()));
            return list;
        }

        public int getBufferSize() {
            return BreezeProperties.getInstance().getCameraTypePropertyInt(SpecimJsonRpcCamera.this, this.getCameraType(), "bufferSize", 100);
        }

        public void setBufferSize(int n) {
            BreezeProperties.getInstance().setCameraTypeProperty(SpecimJsonRpcCamera.this, this.getCameraType(), "bufferSize", String.valueOf(n));
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            return SpecimJsonRpcCamera.this.getCameraNamesArguments();
        }

        public String getWindowing(String string) {
            return TcpManager.getInstance().getCameraProperty(SpecimJsonRpcCamera.this, string);
        }

        public void setWindowing(String string, String string2) {
            SpecimJsonRpcCamera.this.remoteSettings.clear();
            this.clear();
            TcpManager.getInstance().setCameraProperty((Camera)SpecimJsonRpcCamera.this, string, string2);
        }

        public boolean useServerCameraForTest() {
            return BreezeProperties.getInstance().getCameraTypePropertyBool(SpecimJsonRpcCamera.this, this.getCameraType(), "useServerCameraForTest", false);
        }
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!SpecimJsonRpcCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, SpecimJsonRpcCamera.this.settings));
                InputFieldHelper.addPanel(this, new NetworkAdapterIPComboBoxInputField((NetworkAdapterIPComboBoxInputField.NetworkAdapterIPSettings)((Object)SpecimJsonRpcCamera.this.settings)));
            }
            InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            private WindowingInputField spectralWindowingField;
            private WindowingInputField spatialWindowingField;

            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced");
                if (!SpecimJsonRpcCamera.this.isConnected()) {
                    this.addPanel(new BreezeInputField.Number("Buffer size", ((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).getBufferSize(), ""), (TextActionEvent textActionEvent) -> ((SpecimJsonRpcCameraSettings)settingsPanel.SpecimJsonRpcCamera.this.settings).setBufferSize(textActionEvent.getValueInt()));
                    this.addPanel(new RgbBandsInputField(breezeFrame, ((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).getRgbBands(), textActionEvent -> ((SpecimJsonRpcCameraSettings)settingsPanel.SpecimJsonRpcCamera.this.settings).setRgbBands(textActionEvent.getText())));
                } else {
                    this.spectralWindowingField = new WindowingInputField("Spectral Windowing", "Spectral windowing with 0-based top offset and absolute height (example: 25;100)", ((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).getWindowing("SpectralWindowing"), textActionEvent -> this.setSpectralWindowing(textActionEvent, "SpectralWindowing", this.spectralWindowingField, settingsPanelCallback, breezeFrame));
                    this.addPanel(this.spectralWindowingField);
                    this.spatialWindowingField = new WindowingInputField("Spatial Windowing", "Spatial windowing with absolute 0-based left offset and absolute 0-based width (example: 250;500)", ((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).getWindowing("SpatialWindowing"), textActionEvent -> this.setSpectralWindowing(textActionEvent, "SpatialWindowing", this.spatialWindowingField, settingsPanelCallback, breezeFrame));
                    this.addPanel(this.spatialWindowingField);
                }
                this.addPanel(new Camera.OffsetInputField(breezeFrame, SpecimJsonRpcCamera.this, settingsPanelCallback));
                this.addPanel(new BinningInputField.BinningSpatialInputField(SpecimJsonRpcCamera.this, settingsPanelCallback));
                this.addPanel(new BinningInputField.BinningSpectralInputField(SpecimJsonRpcCamera.this, settingsPanelCallback));
            }

            private void setSpectralWindowing(TextActionEvent textActionEvent, String string, WindowingInputField windowingInputField, Hardware.SettingsPanelCallback settingsPanelCallback, BreezeFrame breezeFrame) {
                if (textActionEvent.getText().isEmpty()) {
                    this.resetWindowing();
                } else {
                    ((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).setWindowing(string, textActionEvent.getText());
                    windowingInputField.setText(((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).getWindowing(string));
                }
                settingsPanelCallback.reloadInformation();
                ToastHandler.getInstance().showToast(breezeFrame, "Windowing saved!");
            }

            private void resetWindowing() {
                ((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).setWindowing("SpatialWindowing", "");
                this.spatialWindowingField.setText(((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).getWindowing("SpatialWindowing"));
                this.spectralWindowingField.setText(((SpecimJsonRpcCameraSettings)SpecimJsonRpcCamera.this.settings).getWindowing("SpectralWindowing"));
            }
        }
    }

    public static class WindowingInputField
    extends BreezeInputField {
        public WindowingInputField(String string, String string2, String string3, TextActionEvent.TextActionListener textActionListener) {
            super(string, string3, " ");
            this.setUsage(string2);
            this.addChangeListener(textActionListener);
            this.addValidator(new RegexValidator("\\d+;\\d+", "Positive_Number;Positive_Number"));
        }
    }
}

