/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.IDSCamera;
import se.prediktera.breeze.hardware.camera.UnispectralCamera;
import se.prediktera.breeze.hardware.camera.rgb.RgbUsbCamera;

public interface StateCamera
extends Camera {
    public boolean autoChangeState();

    public void changeStateToWhiteReference();

    public void changeStateToNormal();

    public boolean hasWhiteReference();

    public static boolean showTakeReferenceInWizard(Camera camera, boolean bl) {
        return !bl || !(camera instanceof IDSCamera) && !(camera instanceof RgbUsbCamera) && !(camera instanceof UnispectralCamera);
    }

    public static enum RawType {
        Normal,
        Focus(Normal),
        WhiteReference,
        DarkReference,
        Sensor(DarkReference);

        private RawType data = this;

        private RawType() {
        }

        private RawType(RawType rawType) {
            this.data = rawType;
        }

        public RawType getData() {
            return this.data;
        }

        public RawFile getFileByState(Measurement measurement) {
            switch (this.ordinal()) {
                case 3: 
                case 4: {
                    return measurement.darkReference();
                }
                case 0: 
                case 1: {
                    return measurement.rawFile();
                }
                case 2: {
                    return measurement.whiteReference();
                }
            }
            return null;
        }

        public String toString() {
            return StringHelper.formatLabel(this.data.name());
        }
    }
}

