/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera;

import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeSlider;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.camera.component.SpectralRoiInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.map.common.NiceDataFormat;

public class UnispectralCamera
extends RemoteCamera<UnispectralCameraSettings>
implements StateCamera,
Camera.SnapshotCamera {
    @Override
    public boolean isFrameRateAndIntegrationTimeConnected() {
        return true;
    }

    @Override
    protected UnispectralCameraSettings createSettings() {
        return new UnispectralCameraSettings(this);
    }

    @Override
    public FieldOfView getFieldOfView() {
        if (this.isConnected()) {
            return new FieldOfView(this.getWidth().value);
        }
        return BreezeProperties.getInstance().getCameraFieldOfView(this);
    }

    @Override
    public boolean canChangeView() {
        return false;
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    public MeasurementLength getMeasurementLength() {
        if (this.isConnected()) {
            return new MeasurementLength(this.getHeight().value);
        }
        return new MeasurementLength(0.0f);
    }

    @Override
    public boolean canChangeLength() {
        return false;
    }

    @Override
    public String getDeviceName() {
        return "UnispectralCamera";
    }

    @Override
    public boolean autoChangeState() {
        return true;
    }

    @Override
    public Camera.CameraCaptureType getType() {
        return ((UnispectralCameraSettings)this.settings).getType();
    }

    public String toString() {
        return "Unispectral Camera";
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Mode", this.getType().toString());
        if (this.getType() == Camera.CameraCaptureType.Snapshot) {
            informationList.add("CameraHeight", this.getHeight().value);
        }
        informationList.add("Gain", ((UnispectralCameraSettings)this.getSettings()).getGain());
    }

    @Override
    public boolean hasShutter() {
        return ((UnispectralCameraSettings)this.settings).getDarkReferenceValue() > 0;
    }

    @Override
    public FrameCount getHeight() {
        return ((UnispectralCameraSettings)this.settings).getHeight();
    }

    @Override
    public boolean hasWhiteReference() {
        return true;
    }

    public static class UnispectralCameraSettings
    extends RemoteCameraTypeSettingsWithRoi<UnispectralCameraSettings> {
        private FrameRate frameRate;

        public UnispectralCameraSettings(RemoteCamera<UnispectralCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("Type", this.getType()));
            list.add(new Command.Argument("Gain", (Object)Float.valueOf(this.getGain())));
            list.add(new Command.Argument("DarkReferenceValue", (Object)this.getDarkReferenceValue()));
            list.add(new Command.Argument("SpectralRoi", (Object)this.getSpectralRoi()));
            return list;
        }

        public FrameRate frameRate() {
            if (this.frameRate == null) {
                this.frameRate = new FrameRate(BreezeProperties.getInstance().getCameraPropertyInt(this.camera, "frameRate", 480));
            }
            return this.frameRate;
        }

        public void setFrameRate(FrameRate frameRate) {
            this.frameRate = frameRate;
            BreezeProperties.getInstance().setCameraProperty(this.camera, "frameRate", NiceDataFormat.toString((double)frameRate.value));
        }

        public Camera.CameraCaptureType getType() {
            return Camera.CameraCaptureType.Snapshot;
        }

        public void setSpectralRoi(String string) {
            BreezeProperties.getInstance().setCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", string);
            this.camera.setSpectralROI(string);
        }

        public String getSpectralRoi() {
            return BreezeProperties.getInstance().getCameraTypeProperty(this.camera, this.getCameraType(), "spectralRoi", "1;1;1;1;1;1;1;1;1;1");
        }

        public void setDarkReferenceValue(int n) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "darkReferenceValue", String.valueOf(n));
        }

        public int getDarkReferenceValue() {
            return RtDataFormat.toNumberInt(BreezeProperties.getInstance().getCameraProperty(this.camera, "darkReferenceValue", "64"));
        }

        public void setGain(float f) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "gain", RtDataFormat.toString(f));
        }

        public float getGain() {
            return RtDataFormat.toNumberFloat(BreezeProperties.getInstance().getCameraProperty(this.camera, "gain", "1.1"));
        }
    }

    private class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!UnispectralCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, UnispectralCamera.this.settings, cameraType -> {}));
            }
            InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced");
                if (UnispectralCamera.this.isConnected()) {
                    this.addPanel(new SpectralRoiInputField(breezeFrame, UnispectralCamera.this, string -> {
                        String string2 = string;
                        if (string2.isEmpty()) {
                            string2 = ((UnispectralCameraSettings)settingsPanel.UnispectralCamera.this.settings).getSpectralRoi();
                        }
                        ((UnispectralCameraSettings)settingsPanel.UnispectralCamera.this.settings).setSpectralRoi(string2);
                        settingsPanelCallback.reloadInformation();
                    }));
                } else {
                    this.addPanel(new Camera.MirrorLineInputField(UnispectralCamera.this.settings));
                    this.addPanel(new Camera.OffsetInputField(breezeFrame, UnispectralCamera.this, settingsPanelCallback));
                }
                this.addPanel(new BreezeInputField.Number("Default dark reference value", (double)((UnispectralCameraSettings)UnispectralCamera.this.settings).getDarkReferenceValue(), "", textActionEvent -> ((UnispectralCameraSettings)settingsPanel.UnispectralCamera.this.settings).setDarkReferenceValue(textActionEvent.getValueInt())));
                BreezeSlider.BreezeSliderInputField breezeSliderInputField = new BreezeSlider.BreezeSliderInputField("Gain", 1.0f, 10.0f, ((UnispectralCameraSettings)UnispectralCamera.this.settings).getGain(), ((UnispectralCameraSettings)UnispectralCamera.this.settings)::setGain, 10.0f);
                this.addPanel(breezeSliderInputField);
            }
        }
    }
}

