/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.commons.io.IOUtils;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.hardware.camera.capture.MemoryMappedFile;
import se.prediktera.breeze.hardware.camera.capture.TcpStream;
import se.prediktera.breeze.hardware.camera.frame.RingBuffer;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;

public class BufferedTcpStream
implements TcpStream {
    public static boolean PrintDebug = false;
    private static final int streamTypeFieldSize = 1;
    private static final int frameNumberFieldSize = 8;
    private static final int inTimeFieldSize = 8;
    private static final int metaDataFieldSize = 4;
    private static final int dataBodyFieldSize = 4;
    public static int HEADERSIZE = 25;
    private static final int BUFFERSIZE = 10000;
    private Thread socketListener;
    private final ByteBuffer byteBuffer;
    private final HandleFrame frameHandle;
    private final RingBuffer<FrameStack> frameQueue = new RingBuffer<FrameStack>(FrameStack.class, 10000);
    private Socket clientSocket;
    private final String host;
    private final int port;
    private final StreamCallback callback;
    private InputStream inputStream;
    private BufferedOutputStream outputStream;
    private final File memoryMappedFile;
    private MemoryMappedFile.MmfClient mmfClient;
    private boolean endOfStream = true;
    private boolean stopped = false;

    public BufferedTcpStream(HandleFrame handleFrame, String string, int n) {
        this(handleFrame, string, n, new StreamCallback(){

            @Override
            public void onStop() {
            }

            @Override
            public void onStart() {
            }
        }, null);
    }

    public BufferedTcpStream(HandleFrame handleFrame, String string, int n, StreamCallback streamCallback, File file) {
        this.frameHandle = handleFrame;
        this.host = string;
        this.port = n;
        this.callback = streamCallback;
        this.memoryMappedFile = file;
        this.byteBuffer = ByteBuffer.allocate(HEADERSIZE);
    }

    @Override
    public void connect() {
        try {
            this.clientSocket = new Socket(this.host, this.port);
            this.clientSocket.setTcpNoDelay(true);
            if (this.memoryMappedFile != null) {
                this.sendAndAwaitResponse(new Command("MmfStart", new Command.Argument("Path", this.memoryMappedFile)));
            }
            this.inputStream = this.clientSocket.getInputStream();
            this.outputStream = new BufferedOutputStream(this.clientSocket.getOutputStream());
            this.socketListener = new SocketStreamListener();
            this.socketListener.start();
        }
        catch (IOException iOException) {
            throw new RuntimeException(String.format("Failed to connect to Breeze Runtime on host:%s, port:%d", this.host, this.port), iOException);
        }
    }

    private void sendAndAwaitResponse(Command command) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream, StandardCharsets.UTF_8));
        this.outputStream.write((command.toJsonString() + "\r\n").getBytes());
        this.outputStream.flush();
        ThreadUtil.awaitOrThrow(() -> {
            try {
                return bufferedReader.readLine().length() > 0;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }, new Time.Seconds(5.0), "Timeout waiting for response, for command: " + command.toJsonString());
    }

    @Override
    public void disconnect() {
        try {
            this.stopped = true;
            if (this.mmfClient != null) {
                this.mmfClient.stop();
                this.sendAndAwaitResponse(new Command("MmfStop", new Command.Argument[0]));
            }
            IOUtils.closeQuietly((InputStream)this.inputStream);
            IOUtils.closeQuietly((OutputStream)this.outputStream);
            IOUtils.closeQuietly((Socket)this.clientSocket);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public final void clearQueue() {
        this.frameQueue.clear();
    }

    @Override
    public FrameStack getFrame() {
        return this.frameQueue.poll();
    }

    @Override
    public final int getQueueSize() {
        return this.frameQueue.getFilled();
    }

    @Override
    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    public static interface HandleFrame {
        public void read(RingBuffer<FrameStack> var1, SocketStreamListener var2, TcpHeader var3) throws IOException;

        public int getDataSize();
    }

    public static interface StreamCallback {
        public void onStart();

        public void onStop();
    }

    public class SocketStreamListener
    extends Thread {
        public SocketStreamListener() {
            super("TcpStreamManager.SocketStreamListener");
        }

        @Override
        public void run() {
            block17: {
                try {
                    byte[] byArray = BufferedTcpStream.this.byteBuffer.array();
                    byte[] byArray2 = null;
                    long l = 0L;
                    long l2 = new Time.Seconds((double)1.0).ms;
                    if (BufferedTcpStream.this.memoryMappedFile != null) {
                        BufferedTcpStream.this.mmfClient = new MemoryMappedFile.MmfClient(BufferedTcpStream.this.memoryMappedFile, 41, BufferedTcpStream.this.frameHandle.getDataSize(), 10);
                    }
                    while (!BufferedTcpStream.this.stopped) {
                        if (BufferedTcpStream.this.mmfClient != null) {
                            BufferedTcpStream.this.mmfClient.receiveNewLine();
                        }
                        this.readData(byArray);
                        TcpHeader tcpHeader = new TcpHeader(byArray);
                        if (byArray2 == null) {
                            byArray2 = new byte[tcpHeader.getMetaDataSize()];
                        }
                        this.readData(byArray2);
                        HeaderType headerType = tcpHeader.getType();
                        if (headerType.equals((Object)HeaderType.Event)) {
                            String string = this.readMessage(tcpHeader);
                            if (string.contains("StreamStarted")) {
                                BufferedTcpStream.this.endOfStream = false;
                                BufferedTcpStream.this.callback.onStart();
                            } else if (string.contains("EndOfStream")) {
                                BufferedTcpStream.this.callback.onStop();
                                BufferedTcpStream.this.endOfStream = true;
                            }
                        } else if (headerType.equals((Object)HeaderType.Error)) {
                            long l3 = System.currentTimeMillis();
                            if (l3 - l > l2) {
                                l = l3;
                                Logg.error((String)("StreamError. Further errors will be suppressed for " + (l2 *= 2L) / 1000L + " seconds."), (Object[])new Object[]{this.readMessage(tcpHeader)});
                            }
                        } else {
                            BufferedTcpStream.this.frameHandle.read(BufferedTcpStream.this.frameQueue, this, tcpHeader);
                        }
                        if (BufferedTcpStream.this.mmfClient == null) continue;
                        BufferedTcpStream.this.mmfClient.receivedLine();
                    }
                }
                catch (HeaderException headerException) {
                    throw new HeaderException(headerException.getMessage() + "\nExpected data size: " + BufferedTcpStream.this.frameHandle.getDataSize());
                }
                catch (SocketException socketException) {
                }
                catch (IOException iOException) {
                    if ("Socket Closed".equals(iOException.getMessage())) break block17;
                    ErrorHandler.logAndReportException((String)"Tcp stream read error", (Throwable)iOException);
                }
            }
            if (BufferedTcpStream.this.mmfClient != null) {
                BufferedTcpStream.this.mmfClient.close();
                BufferedTcpStream.this.mmfClient = null;
            }
        }

        private String readMessage(TcpHeader tcpHeader) throws IOException {
            byte[] byArray = new byte[tcpHeader.getBodySize()];
            this.readData(byArray);
            return new String(byArray);
        }

        public void readData(byte[] byArray) throws IOException {
            if (BufferedTcpStream.this.mmfClient != null) {
                BufferedTcpStream.this.mmfClient.receiveData(byArray);
            } else {
                this.readBufferFromTcpStream(byArray);
            }
        }

        private void readBufferFromTcpStream(byte[] byArray) throws IOException {
            int n = 0;
            while (BufferedTcpStream.this.socketListener != null) {
                try {
                    if ((n += BufferedTcpStream.this.inputStream.read(byArray, n, byArray.length - n)) != byArray.length) continue;
                    return;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new SocketException("TcpStream connection to BreezeRuntime was broken", indexOutOfBoundsException);
                }
            }
        }
    }

    public static class NanoTime
    implements HeaderTime {
        private static final long TICKS_PER_MILLISECOND = 10000L;
        private static final long TICKS_AT_EPOCH = 621355968000000000L;
        private final long time;

        public NanoTime(long l) {
            this.time = l;
        }

        @Override
        public Timestamp toTimestamp() {
            return new Timestamp((this.time - 621355968000000000L) / 10000L);
        }

        @Override
        public long getValue() {
            return this.time;
        }

        public static NanoTime fromTime(long l) {
            long l2 = l * 10000L;
            return new NanoTime(l2 + 621355968000000000L);
        }

        public static NanoTime now() {
            return NanoTime.fromTime(System.currentTimeMillis());
        }
    }

    public static interface HeaderTime {
        public Timestamp toTimestamp();

        public long getValue();
    }

    public static class HeaderException
    extends RuntimeException {
        public HeaderException(String string) {
            super(string);
        }
    }

    public static class TcpHeader {
        private static final int inTimeOffset = 9;
        private static final int metaDataSizeOffset = 17;
        private static final int dataSizeOffset = 21;
        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private final HeaderType type;
        private final long frameNumber;
        private final HeaderTime inTime;
        private final int metaDataSize;
        private final int bodySize;

        public TcpHeader(byte[] byArray) {
            byte by = byArray[0];
            HeaderType[] headerTypeArray = HeaderType.values();
            if (by < 0 || by >= headerTypeArray.length) {
                throw new HeaderException("Breeze Runtime stream is not in sync: " + by);
            }
            this.type = headerTypeArray[by];
            this.frameNumber = TcpHeader.bytesToLong(byArray, 1);
            this.inTime = new NanoTime(TcpHeader.bytesToLong(byArray, 9));
            this.metaDataSize = TcpHeader.bytesToInt(byArray, 17);
            this.bodySize = TcpHeader.bytesToInt(byArray, 21);
        }

        public static int bytesToInt(byte[] byArray, int n) {
            return ByteBuffer.wrap(byArray, n, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }

        public static long bytesToLong(byte[] byArray, int n) {
            return ByteBuffer.wrap(byArray, n, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
        }

        public HeaderType getType() {
            return this.type;
        }

        public long getFrameNumber() {
            return this.frameNumber;
        }

        public HeaderTime getInTime() {
            return this.inTime;
        }

        public int getMetaDataSize() {
            return this.metaDataSize;
        }

        public int getBodySize() {
            return this.bodySize;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Type: " + this.type.toString());
            stringBuilder.append(", FrameNumber: " + this.frameNumber);
            stringBuilder.append(", InTime: " + sdf.format(this.inTime.toTimestamp()));
            stringBuilder.append(", MetaDataSize: " + this.metaDataSize);
            stringBuilder.append(", BodySize: " + this.bodySize);
            return stringBuilder.toString();
        }
    }

    public static enum HeaderType {
        Error,
        RawPixelLine,
        PredictionLines,
        RgbPixelLine,
        Event;


        public byte getType() {
            return (byte)this.ordinal();
        }
    }
}

