/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.performance.MeasuredFps;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class MemoryMappedFile {
    public static void main(String[] stringArray) throws Throwable {
        File file = new File("C:/data/test.mem");
        file.getParentFile().mkdirs();
        new Thread(() -> MemoryMappedFile.testRecieve(file, 1020000, 10, 10000)).start();
        MmfServer mmfServer = new MmfServer(file, 1020000, 10);
        byte[] byArray = new byte[1020000];
        for (int i = 0; i <= 10000; ++i) {
            mmfServer.send(byArray, i);
        }
        Thread.sleep(1000L);
        System.exit(0);
    }

    private static void testRecieve(File file, int n, int n2, int n3) {
        MmfClient mmfClient = new MmfClient(file, BufferedTcpStream.HEADERSIZE, n, n2);
        MeasuredFps measuredFps = new MeasuredFps();
        byte[] byArray = new byte[BufferedTcpStream.HEADERSIZE];
        byte[] byArray2 = new byte[n];
        long l = 0L;
        int n4 = 0;
        int n5 = 0;
        int n6 = BufferedTcpStream.HEADERSIZE + n + 8;
        while (n5++ < n3) {
            mmfClient.recieve(byArray, byArray2);
            BufferedTcpStream.TcpHeader tcpHeader = new BufferedTcpStream.TcpHeader(byArray);
            long l2 = tcpHeader.getFrameNumber();
            if (l > 0L) {
                n4 = (int)((long)n4 + (l2 - (l + 1L)));
            }
            measuredFps.increase();
            l = l2;
        }
        System.out.println(measuredFps.getActual());
        System.out.println("Data transfer rate " + UpdateHelper.formatSize((long)((long)(measuredFps.getActual().value * (float)n6))) + "/sec");
        System.out.println("Missing frames: " + n4);
    }

    private static FileChannel tryOpenFile(File file, String string) throws IOException {
        for (int i = 0; i < 25; ++i) {
            if (file.exists() && file.length() > 0L) {
                try {
                    return FileChannel.open(file.toPath(), StandardOpenOption.READ);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            ThreadUtil.sleep(200L);
        }
        throw new RuntimeException("Timeout wainting to connect to " + string + " file");
    }

    private static File getReponseFile(File file) {
        return new File(file.getParentFile(), file.getName() + "_response");
    }

    public static void UnloadMap(MappedByteBuffer mappedByteBuffer) {
        try {
            int n = MemoryMappedFile.getVersion();
            if (n <= 8) {
                Class<?> clazz = Class.forName("sun.nio.ch.DirectBuffer");
                Object object = clazz.getMethod("cleaner", new Class[0]).invoke((Object)mappedByteBuffer, new Object[0]);
                if (object != null) {
                    Class<?> clazz2 = Class.forName("sun.misc.Cleaner");
                    clazz2.getMethod("clean", new Class[0]).invoke(object, new Object[0]);
                }
            } else {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field = clazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Object object = field.get(null);
                Method method = clazz.getMethod("invokeCleaner", ByteBuffer.class);
                method.invoke(object, mappedByteBuffer);
            }
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot unload mapped byte buffer", (Throwable)exception);
        }
    }

    private static int getVersion() {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.")) {
            string = string.substring(2, 3);
        } else {
            int n = string.indexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return Integer.parseInt(string);
    }

    public static class MmfServer {
        private final File dataFile;
        private final int dataSize;
        private final int bufferLines;
        private long sendIndex;
        private final FileChannel responseChannel;
        private final MappedByteBuffer responseBuffer;
        private final FileChannel dataChannel;
        private final MappedByteBuffer dataBuffer;
        private final int lineSize;
        private int line = 0;

        public MmfServer(File file, int n, int n2) {
            this.dataFile = file;
            this.dataSize = n;
            this.bufferLines = n2;
            this.lineSize = BufferedTcpStream.HEADERSIZE + n + 8;
            this.sendIndex = n2;
            try {
                this.responseChannel = MemoryMappedFile.tryOpenFile(MemoryMappedFile.getReponseFile(file), "client response");
                this.responseBuffer = this.responseChannel.map(FileChannel.MapMode.READ_ONLY, 0L, 8L);
                file.delete();
                this.dataChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                this.dataBuffer = this.dataChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.lineSize * n2);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public void send(byte[] byArray, int n) {
            int n2 = this.line * this.lineSize;
            this.dataBuffer.putLong(0L);
            this.dataBuffer.put((byte)BufferedTcpStream.HeaderType.RawPixelLine.ordinal());
            this.dataBuffer.putLong(Long.reverseBytes(n));
            this.dataBuffer.putLong(0L);
            this.dataBuffer.putInt(0);
            this.dataBuffer.putInt(Integer.reverseBytes(this.dataSize));
            this.dataBuffer.put(byArray);
            this.dataBuffer.putLong(n2, Long.reverseBytes(this.sendIndex));
            if (++this.line == this.bufferLines) {
                this.dataBuffer.rewind();
                this.line = 0;
            }
            ThreadUtil.awaitOrThrow(() -> this.sendIndex - Long.reverseBytes(this.responseBuffer.getLong(0)) < (long)this.bufferLines, new Time.Seconds(5.0), "Timeout waiting for client to read frames");
            ++this.sendIndex;
        }

        public void stop() {
            try {
                this.responseChannel.close();
                MemoryMappedFile.UnloadMap(this.responseBuffer);
                Files.delete(MemoryMappedFile.getReponseFile(this.dataFile).toPath());
                this.dataChannel.close();
                MemoryMappedFile.UnloadMap(this.dataBuffer);
                Files.delete(this.dataFile.toPath());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static class MmfClient {
        private final File file;
        private final int bufferLines;
        private int recieveIndex = 0;
        private final FileChannel responseChannel;
        private final MappedByteBuffer responseBuffer;
        private final FileChannel dataChannel;
        private final MappedByteBuffer dataBuffer;
        private final int lineSize;
        private final byte[] recieveData = new byte[8];
        private int line = 0;
        private boolean stopped = false;

        public MmfClient(File file, int n, int n2, int n3) {
            this.file = file;
            this.bufferLines = n3;
            this.lineSize = n + n2 + 8;
            this.recieveIndex = n3;
            try {
                this.responseChannel = FileChannel.open(MemoryMappedFile.getReponseFile(file).toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                this.responseBuffer = this.responseChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 8L);
                this.dataChannel = MemoryMappedFile.tryOpenFile(file, "server data");
                this.dataBuffer = this.dataChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.lineSize * n3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public final void recieve(byte[] byArray, byte[] byArray2) {
            this.receiveNewLine();
            this.receiveData(byArray);
            this.receiveData(byArray2);
            this.receivedLine();
        }

        public final void receiveNewLine() {
            int n = this.line * this.lineSize;
            ThreadUtil.awaitOrThrow(() -> {
                if (this.stopped) {
                    return true;
                }
                this.dataBuffer.position(n);
                this.dataBuffer.get(this.recieveData);
                long l = BufferedTcpStream.TcpHeader.bytesToLong(this.recieveData, 0);
                return l == (long)this.recieveIndex;
            }, new Time.Seconds(5.0), "Timeout waiting for frame index: " + this.recieveIndex);
        }

        public final void receiveData(byte[] byArray) {
            this.dataBuffer.get(byArray);
        }

        public void receivedLine() {
            this.responseBuffer.putLong(0, Long.reverseBytes(this.recieveIndex++));
            if (++this.line == this.bufferLines) {
                this.dataBuffer.rewind();
                this.line = 0;
            }
        }

        public void stop() {
            this.stopped = true;
        }

        public void close() {
            try {
                this.responseChannel.close();
                MemoryMappedFile.UnloadMap(this.responseBuffer);
                this.dataChannel.close();
                MemoryMappedFile.UnloadMap(this.dataBuffer);
                System.out.println("Mmf client closed: " + this.file.getName());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

