/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.MemoryMappedFile;

public class MemoryMappedFileTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    @Ignore
    public void testMemoryMappedFile() throws IOException {
        int n;
        File file = this.tempFolder.newFile();
        int n2 = BufferedTcpStream.HEADERSIZE;
        byte[] byArray = new byte[100];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)i;
        }
        ArrayList arrayList = new ArrayList();
        new Thread(() -> {
            MemoryMappedFile.MmfClient mmfClient = new MemoryMappedFile.MmfClient(file, n2, 100, 10);
            for (int i = 0; i < 50; ++i) {
                byte[] byArray = new byte[n2];
                byte[] byArray2 = new byte[100];
                mmfClient.recieve(byArray, byArray2);
                arrayList.add(new DataWithHeader(byArray, byArray2));
            }
            mmfClient.stop();
            mmfClient.close();
        }).start();
        MemoryMappedFile.MmfServer mmfServer = new MemoryMappedFile.MmfServer(file, 100, 10);
        for (n = 0; n < 50; ++n) {
            mmfServer.send(byArray, n);
        }
        ThreadUtil.awaitOrThrow(() -> arrayList.size() == 50, new Time.Seconds(5.0), "Timeout waiting for frames");
        MatcherAssert.assertThat((Object)arrayList.size(), (Matcher)Matchers.is((Object)50));
        for (n = 0; n < arrayList.size(); ++n) {
            BufferedTcpStream.TcpHeader tcpHeader = new BufferedTcpStream.TcpHeader(((DataWithHeader)arrayList.get((int)n)).header);
            MatcherAssert.assertThat((Object)tcpHeader.getFrameNumber(), (Matcher)Matchers.is((Object)n));
            for (int i = 0; i < byArray.length; ++i) {
                MatcherAssert.assertThat((Object)byArray[i], (Matcher)Matchers.is((Object)((DataWithHeader)arrayList.get((int)n)).data[i]));
            }
        }
        mmfServer.stop();
    }

    private static class DataWithHeader {
        public final byte[] header;
        public final byte[] data;

        public DataWithHeader(byte[] byArray, byte[] byArray2) {
            this.header = byArray;
            this.data = byArray2;
        }
    }
}

