/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RuntimeWorkflowHandleFrame;
import se.prediktera.breeze.hardware.camera.capture.TcpStreamCaptureSession;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class PredictSession {
    private RemoteCameraPredictSession predictSession;

    public void startPredict(FrameCount frameCount, Camera.CaptureCallback captureCallback, RuntimeWorkflow runtimeWorkflow) {
        this.startPredict(frameCount, captureCallback, runtimeWorkflow, false);
    }

    public void startPredict(FrameCount frameCount, Camera.CaptureCallback captureCallback, RuntimeWorkflow runtimeWorkflow, boolean bl) {
        BufferedTcpStream bufferedTcpStream = new BufferedTcpStream(new RuntimeWorkflowHandleFrame(runtimeWorkflow), BreezeProperties.getInstance().getBreezeRuntimeConnectHost(), BreezeProperties.getInstance().getDataStreamPort());
        bufferedTcpStream.connect();
        this.predictSession = new RemoteCameraPredictSession(TcpManager.getInstance(), bufferedTcpStream, captureCallback, frameCount, bl);
        this.predictSession.runBlocking();
        bufferedTcpStream.disconnect();
    }

    public void stopPredict() {
        TcpManager.getInstance().stopPredict(BreezeProgressManager.createEmpty());
        this.predictSession.stop();
    }

    private static class RemoteCameraPredictSession
    extends TcpStreamCaptureSession {
        public RemoteCameraPredictSession(final TcpManager tcpManager, BufferedTcpStream bufferedTcpStream, Camera.CaptureCallback captureCallback, FrameCount frameCount, final Boolean bl) {
            super(bufferedTcpStream, frameCount, new TcpStreamCaptureSession.CameraCallbacks(){

                @Override
                public void startCapture(FrameCount frameCount) {
                    tcpManager.startPredict(frameCount, (boolean)bl);
                }

                @Override
                public void stopCapture() {
                    tcpManager.stopPredict(null);
                }
            }, captureCallback);
        }
    }
}

