/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import java.io.IOException;
import se.prediktera.breeze.common.frame.FrameType;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RawFrameStack;
import se.prediktera.breeze.hardware.camera.frame.RingBuffer;

public class RawHandleFrame
implements BufferedTcpStream.HandleFrame {
    private final FrameType frameType;
    private final byte[] buffert;

    public RawHandleFrame(DataSize dataSize, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, RtInterleave rtInterleave, RtByteOrder rtByteOrder, boolean bl) {
        int n = bandCount.value * pixelWidth.value;
        this.buffert = new byte[n * dataSize.size];
        this.frameType = FrameType.createFrameHandle(dataSize, bandCount, pixelWidth, bandNames, rtInterleave, rtByteOrder, bl);
    }

    @Override
    public void read(RingBuffer<FrameStack> ringBuffer, BufferedTcpStream.SocketStreamListener socketStreamListener, BufferedTcpStream.TcpHeader tcpHeader) throws IOException {
        BufferedTcpStream.HeaderType headerType = tcpHeader.getType();
        if (!headerType.equals((Object)BufferedTcpStream.HeaderType.RawPixelLine)) {
            throw new RuntimeException("Please handle stream type " + String.valueOf((Object)headerType));
        }
        socketStreamListener.readData(this.buffert);
        FrameStack frameStack = ringBuffer.getNext();
        ringBuffer.putDirect(new RawFrameStack(tcpHeader, this.frameType.read(frameStack != null ? frameStack.getFrame() : null, this.buffert, 0)));
    }

    @Override
    public int getDataSize() {
        return this.buffert.length;
    }
}

