/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RawFrameStack;
import se.prediktera.breeze.hardware.camera.capture.RawHandleFrame;
import se.prediktera.breeze.hardware.camera.capture.RemoteCameraCaptureSession;
import se.prediktera.breeze.hardware.tcp.FakeTcpManager;
import se.prediktera.breeze.util.datacreation.ShortFrameCreator;

public class RemoteCameraCaptureSessionTest {
    @Test
    public void itSendsStartCaptureOnStartCapture() {
        FakeBufferedTcpStream fakeBufferedTcpStream = new FakeBufferedTcpStream();
        FakeTcpManager fakeTcpManager = new FakeTcpManager(fakeBufferedTcpStream);
        new RemoteCameraCaptureSession(fakeTcpManager, fakeBufferedTcpStream, new VerifyingCaptureCallback(), 0, new FrameCount(1)).runBlocking();
        fakeTcpManager.assertStartCaptureSent();
    }

    @Test
    public void itSendsStartEventOnStartCapture() {
        FakeBufferedTcpStream fakeBufferedTcpStream = new FakeBufferedTcpStream();
        FakeTcpManager fakeTcpManager = new FakeTcpManager(fakeBufferedTcpStream);
        VerifyingCaptureCallback verifyingCaptureCallback = new VerifyingCaptureCallback();
        new RemoteCameraCaptureSession(fakeTcpManager, fakeBufferedTcpStream, verifyingCaptureCallback, 0, new FrameCount(1)).runBlocking();
        verifyingCaptureCallback.assertStartEventSent();
    }

    @Test
    public void itSendsStopEventWhenCaptureDone() {
        FakeBufferedTcpStream fakeBufferedTcpStream = new FakeBufferedTcpStream();
        FakeTcpManager fakeTcpManager = new FakeTcpManager(fakeBufferedTcpStream);
        VerifyingCaptureCallback verifyingCaptureCallback = new VerifyingCaptureCallback();
        new RemoteCameraCaptureSession(fakeTcpManager, fakeBufferedTcpStream, verifyingCaptureCallback, 0, new FrameCount(1)).runBlocking();
        verifyingCaptureCallback.assertStopEventSent();
    }

    @Test
    public void itForwardsCapturedFramesToCallbackOnCapture() {
        ShortFrame shortFrame = ShortFrameCreator.create(1, 1, 0.0f);
        FakeBufferedTcpStream fakeBufferedTcpStream = new FakeBufferedTcpStream(shortFrame);
        FakeTcpManager fakeTcpManager = new FakeTcpManager(fakeBufferedTcpStream);
        VerifyingCaptureCallback verifyingCaptureCallback = new VerifyingCaptureCallback();
        new RemoteCameraCaptureSession(fakeTcpManager, fakeBufferedTcpStream, verifyingCaptureCallback, 0, new FrameCount(1)).runBlocking();
        verifyingCaptureCallback.assertReceivedFrame(shortFrame);
    }

    private static class FakeBufferedTcpStream
    extends BufferedTcpStream {
        private RawFrameStack frameStack = new RawFrameStack();

        public FakeBufferedTcpStream(RawFrame rawFrame) {
            super(new RawHandleFrame(DataSize.SHORT_2, new BandCount(1), new PixelWidth(1), BandNames.fromIndex(1), RtInterleave.BIL, RtByteOrder.LittleEndian, false), "localhost", 1111);
            this.frameStack.setRawFrame(rawFrame);
        }

        public FakeBufferedTcpStream() {
            this(ShortFrameCreator.create(1, 1, 0.0f));
        }

        @Override
        public FrameStack getFrame() {
            RawFrameStack rawFrameStack = this.frameStack;
            this.frameStack = null;
            return rawFrameStack;
        }

        @Override
        public boolean isEndOfStream() {
            return this.frameStack == null;
        }
    }

    public static class VerifyingCaptureCallback
    implements Camera.CaptureCallback {
        private boolean startCalled;
        private final List<Frame> receivedFrames = new ArrayList<Frame>();
        private boolean stopCalled;

        @Override
        public void onStart(Camera.CaptureControl captureControl) {
            this.startCalled = true;
        }

        @Override
        public void onFrame(FrameStack frameStack, Camera.CaptureControl captureControl) {
            this.receivedFrames.add(frameStack.getFrame());
        }

        @Override
        public void onStop() {
            this.stopCalled = true;
        }

        @Override
        public void onError(Camera.CaptureControl captureControl, Exception exception) {
        }

        public void assertStartEventSent() {
            MatcherAssert.assertThat((String)"callback start called", (boolean)this.startCalled);
        }

        public void assertReceivedFrame(ShortFrame shortFrame) {
            MatcherAssert.assertThat(this.receivedFrames, (Matcher)CoreMatchers.hasItem((Object)shortFrame));
        }

        public void assertStopEventSent() {
            MatcherAssert.assertThat((String)"callback stopped called", (boolean)this.stopCalled);
        }
    }
}

