/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.util.Holder;

public class RuntimeEvent {
    private final String type;
    private final String message;
    private final int code;
    private final String error;

    public RuntimeEvent(JSONObject jSONObject) {
        this.type = jSONObject.getString("Event");
        this.code = jSONObject.getInt("Code");
        this.message = jSONObject.has("Message") ? jSONObject.getString("Message") : this.type;
        this.error = jSONObject.has("Error") ? jSONObject.getString("Error") : null;
    }

    public boolean isWorkflowLoaded() {
        return "WorkflowLoaded".equals(this.message);
    }

    public boolean isWorkflowListChanged() {
        return "WorkflowListChanged".equals(this.message);
    }

    public boolean isError() {
        return this.type.equals("Error");
    }

    public boolean isWarning() {
        return this.type.equals("Warning");
    }

    public boolean isObject() {
        return this.type.equals("Object") || this.type.equals("PredictionObject");
    }

    public boolean isMeasurement() {
        return this.type.equals("Measurement");
    }

    public String getMessageError() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.message)) {
            stringBuilder.append(this.message);
        }
        if (this.error != null) {
            stringBuilder.append(": ");
            stringBuilder.append(this.error);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.type + ":" + this.message;
    }

    public boolean handleAsError() {
        if (this.isError()) {
            if (this.message != null) {
                if (this.message.contains("Frame queue overflow")) {
                    return false;
                }
                return !this.message.contains("Camera not streaming");
            }
            return true;
        }
        return false;
    }

    public EventErrorException toException() {
        return new EventErrorException(this);
    }

    public static RuntimeEvent awaitEvent(List<RuntimeEvent> list, String string, String string2) {
        Holder holder = new Holder();
        ThreadUtil.awaitOrThrow(() -> {
            for (RuntimeEvent runtimeEvent : list) {
                if (runtimeEvent == null || !runtimeEvent.getType().equals(string) || string2 != null && !runtimeEvent.getMessage().equals(string2)) continue;
                holder.setValue(runtimeEvent);
                return true;
            }
            return false;
        }, Time.FiveSeconds, String.format("Timeout waiting for event server event with type '%s' and message '%s'", string, string2));
        return (RuntimeEvent)holder.getValue();
    }

    public boolean isProgress() {
        return this.code >= 5000 && this.code < 6000;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    public static class EventErrorException
    extends RuntimeException {
        public EventErrorException(RuntimeEvent runtimeEvent) {
            super(EventErrorException.formatMessage(runtimeEvent));
        }

        private static String formatMessage(RuntimeEvent runtimeEvent) {
            return String.format("Error in Breeze Runtime - %s(Code %d): %s", runtimeEvent.getError(), runtimeEvent.getCode(), runtimeEvent.getMessage());
        }
    }
}

