/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;

public class RuntimeWorkflowFrameStack
implements FrameStack {
    private final RawFrame[] frameStack;
    private final BufferedTcpStream.HeaderTime inHeaderTime;
    private final long frameNumber;
    private int[][] objectBorderArray;

    @Override
    public RawFrame getFrame() {
        return this.frameStack[0];
    }

    public RuntimeWorkflowFrameStack(BufferedTcpStream.TcpHeader tcpHeader, int n) {
        this(tcpHeader.getInTime(), tcpHeader.getFrameNumber(), n);
    }

    public RuntimeWorkflowFrameStack(BufferedTcpStream.HeaderTime headerTime, long l, int n) {
        this.inHeaderTime = headerTime;
        this.frameNumber = l;
        this.frameStack = new RawFrame[n];
    }

    public void setFrame(int n, RawFrame rawFrame) {
        this.frameStack[n] = rawFrame;
    }

    public RawFrame getFrame(int n) {
        return this.frameStack[n];
    }

    public int getSize() {
        return this.frameStack.length;
    }

    @Override
    public long getInTime() {
        return this.inHeaderTime.getValue();
    }

    public BufferedTcpStream.HeaderTime getInHeaderTime() {
        return this.inHeaderTime;
    }

    @Override
    public long getFrameNumber() {
        return this.frameNumber;
    }

    public void setObjectBorder(int[][] nArray) {
        this.objectBorderArray = nArray;
    }

    public int[][] getObjectBorder() {
        return this.objectBorderArray;
    }
}

