/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.frame.FrameType;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.entry.application.RuntimeStreamFormat;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RuntimeWorkflowFrameStack;
import se.prediktera.breeze.hardware.camera.frame.RingBuffer;
import se.prediktera.map.common.error.Logg;

public class RuntimeWorkflowHandleFrame
implements BufferedTcpStream.HandleFrame {
    private final List<FrameType> lineFrameTypes = new ArrayList<FrameType>();
    private final byte[] lineBuffer;
    private boolean rgbFrame = false;

    public RuntimeWorkflowHandleFrame(RuntimeWorkflow runtimeWorkflow) {
        this(runtimeWorkflow, runtimeWorkflow.getStreamFormat().getPixelWidth());
    }

    public RuntimeWorkflowHandleFrame(RuntimeWorkflow runtimeWorkflow, PixelWidth pixelWidth) {
        int n = 0;
        RuntimeStreamFormat runtimeStreamFormat = runtimeWorkflow.getStreamFormat();
        for (RuntimeStreamFormat.StreamType streamType : runtimeStreamFormat.getStreamTypes()) {
            if (streamType.getLineType().equals("RgbVector")) {
                this.rgbFrame = true;
            } else if (streamType.isObjectOnly()) continue;
            FrameType frameType = RuntimeWorkflowHandleFrame.createFrameHandle(streamType, pixelWidth);
            this.lineFrameTypes.add(frameType);
            n += frameType.getFrameSize();
            if (!this.rgbFrame) continue;
            break;
        }
        this.lineBuffer = new byte[n];
    }

    private static FrameType createFrameHandle(RuntimeStreamFormat.StreamType streamType, PixelWidth pixelWidth) {
        if (streamType.getLineType().equals("RgbVector")) {
            return FrameType.createFrameHandle(DataSize.BYTE_1, new BandCount(1), new PixelWidth(pixelWidth.value * 3), BandNames.fromIndex(1), RtInterleave.BIL, RtByteOrder.LittleEndian, false);
        }
        BasicAnalyse basicAnalyse = streamType.getAnalyse();
        BasicAnalyse.ModelType modelType = basicAnalyse.getModelMethod().getType();
        return switch (modelType) {
            case BasicAnalyse.ModelType.Sample, BasicAnalyse.ModelType.Classification -> FrameType.createFrameHandle(DataSize.BYTE_1, new BandCount(1), pixelWidth, BandNames.fromIndex(1), RtInterleave.BIL, RtByteOrder.LittleEndian, false);
            case BasicAnalyse.ModelType.Quantification -> FrameType.createFrameHandle(DataSize.FLOAT_4, new BandCount(1), pixelWidth, BandNames.fromIndex(basicAnalyse.getPropertyFactors().size()), RtInterleave.BIL, RtByteOrder.LittleEndian, false);
            default -> throw new RuntimeException("Cannot handle analyse type: " + String.valueOf((Object)modelType));
        };
    }

    @Override
    public void read(RingBuffer<FrameStack> ringBuffer, BufferedTcpStream.SocketStreamListener socketStreamListener, BufferedTcpStream.TcpHeader tcpHeader) throws IOException {
        RuntimeWorkflowFrameStack runtimeWorkflowFrameStack;
        BufferedTcpStream.HeaderType headerType;
        ringBuffer.getNext();
        if (BufferedTcpStream.PrintDebug) {
            Logg.debug((String)("Got prediction frame stack: " + tcpHeader.toString()), (Object[])new Object[0]);
        }
        if ((headerType = tcpHeader.getType()) == BufferedTcpStream.HeaderType.PredictionLines || headerType == BufferedTcpStream.HeaderType.RgbPixelLine) {
            runtimeWorkflowFrameStack = new RuntimeWorkflowFrameStack(tcpHeader, this.lineFrameTypes.size());
            socketStreamListener.readData(this.lineBuffer);
            int n = 0;
            for (int i = 0; i < this.lineFrameTypes.size(); ++i) {
                FrameType frameType = this.lineFrameTypes.get(i);
                RawFrame rawFrame = frameType.read(runtimeWorkflowFrameStack.getFrame(i), this.lineBuffer, n);
                rawFrame.rgbFrame = this.rgbFrame;
                runtimeWorkflowFrameStack.setFrame(i, rawFrame);
                n += frameType.getFrameSize();
            }
        } else {
            throw new RuntimeException("Please handle stream type " + String.valueOf((Object)headerType));
        }
        ringBuffer.putDirect(runtimeWorkflowFrameStack);
    }

    @Override
    public int getDataSize() {
        return this.lineBuffer.length;
    }
}

