/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.hardware.camera.capture.RawFrameStack;

public interface TcpStream {
    public void clearQueue();

    public void disconnect();

    public FrameStack getFrame();

    public boolean isEndOfStream();

    public int getQueueSize();

    public void connect();

    public static class FakeStream
    implements TcpStream {
        private final RawFrameStack returnFrame = new RawFrameStack();
        private AfterFrameCallback afterFirstFrameCallback = null;
        private boolean hasReturnedFrame = false;

        @Override
        public void clearQueue() {
        }

        @Override
        public void disconnect() {
        }

        @Override
        public boolean isEndOfStream() {
            return false;
        }

        @Override
        public FrameStack getFrame() {
            if (this.hasReturnedFrame && this.afterFirstFrameCallback != null) {
                this.afterFirstFrameCallback.afterFrame();
                this.afterFirstFrameCallback = null;
            }
            this.hasReturnedFrame = true;
            return this.returnFrame;
        }

        @Override
        public int getQueueSize() {
            return 0;
        }

        @Override
        public void connect() {
        }

        public void returnFrame(ShortFrame shortFrame) {
            this.returnFrame.setRawFrame(shortFrame);
        }

        public void afterFirstFrame(AfterFrameCallback afterFrameCallback) {
            this.afterFirstFrameCallback = afterFrameCallback;
        }

        public static interface AfterFrameCallback {
            public void afterFrame();
        }
    }
}

