/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.capture;

import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.capture.TcpStream;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class TcpStreamCaptureSession {
    public static int CAPTURE_TIMEOUT_MS = 5000;
    private final TcpStream stream;
    private final FrameCount frameCount;
    private final Camera.CaptureCallback callback;
    private final Camera.CaptureControl control;
    private int capturedFramesCount = 0;
    private boolean stop = false;
    private final CameraCallbacks cameraCallbacks;

    public TcpStreamCaptureSession(TcpStream tcpStream, FrameCount frameCount, CameraCallbacks cameraCallbacks, Camera.CaptureCallback captureCallback) {
        this.stream = tcpStream;
        this.frameCount = frameCount;
        this.cameraCallbacks = cameraCallbacks;
        this.callback = captureCallback;
        this.control = () -> {
            this.stop = true;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runBlocking() {
        this.callback.onStart(this.control);
        this.stream.clearQueue();
        this.cameraCallbacks.startCapture(this.frameCount);
        try {
            while (true) {
                FrameStack frameStack;
                if ((frameStack = this.grabNextFrameOrTimeout()) != null) {
                    this.callback.onFrame(frameStack, this.control);
                }
                if (!this.stop) continue;
                if (this.frameCount.isContinuously() || frameStack == null) return;
                if (this.isAllFramesReceived()) return;
            }
        }
        catch (Exception exception) {
            Logg.error((String)"Error receiving frame", (Throwable)exception);
            this.callback.onError(this.control, exception);
            throw exception;
        }
        finally {
            this.cameraCallbacks.stopCapture();
            this.callback.onStop();
        }
    }

    public FrameStack grabNextFrameOrTimeout() {
        long l = System.currentTimeMillis();
        do {
            FrameStack frameStack;
            if ((frameStack = this.stream.getFrame()) != null) {
                ++this.capturedFramesCount;
                if (this.isAllFramesReceived()) {
                    this.stop = true;
                }
                return frameStack;
            }
            ThreadUtil.sleep(1L);
            long l2 = System.currentTimeMillis() - l;
            if (l2 <= (long)CAPTURE_TIMEOUT_MS || !UpdateHelper.Product.isRunningProductBreezeClient()) continue;
            ToastHandler.getInstance().showToast("Breeze Runtime not streaming", Toast.IconType.Info);
            return null;
        } while (!this.stream.isEndOfStream() || this.stream.getQueueSize() != 0);
        return null;
    }

    private boolean isAllFramesReceived() {
        return this.frameCount.value > 0 && this.capturedFramesCount >= this.frameCount.value;
    }

    public void stop() {
        this.stop = true;
    }

    public static interface CameraCallbacks {
        public void startCapture(FrameCount var1);

        public void stopCapture();
    }
}

