/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.component;

import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;

public abstract class BinningInputField
extends BreezeInputField.Number {
    public BinningInputField(String string, int n, TextActionEvent.TextActionListener textActionListener) {
        super(string, n, "");
        this.addChangeListener(textActionListener);
        this.addValidator(new NumericMinMaxValidator(1.0, 12.0));
    }

    public static class BinningSpectralInputField
    extends BinningInputField {
        public BinningSpectralInputField(RemoteCamera remoteCamera, Hardware.SettingsPanelCallback settingsPanelCallback) {
            super("Binning Spectral (Bands)", ((RemoteCameraTypeSettings)remoteCamera.getSettings()).getBinningSpectral(), (TextActionEvent textActionEvent) -> {
                ((RemoteCameraTypeSettings)remoteCamera.getSettings()).setBinningSpectral(textActionEvent.getValueInt());
                if (remoteCamera.isConnected()) {
                    remoteCamera.getRemoteSettings().setBinningSpectral(textActionEvent.getValueInt());
                    settingsPanelCallback.reloadInformation();
                }
            });
        }
    }

    public static class BinningSpatialInputField
    extends BinningInputField {
        public BinningSpatialInputField(RemoteCamera remoteCamera, Hardware.SettingsPanelCallback settingsPanelCallback) {
            super("Binning Spatial (Pixels)", ((RemoteCameraTypeSettings)remoteCamera.getSettings()).getBinningSpatial(), (TextActionEvent textActionEvent) -> {
                ((RemoteCameraTypeSettings)remoteCamera.getSettings()).setBinningSpatial(textActionEvent.getValueInt());
                if (remoteCamera.isConnected()) {
                    remoteCamera.getRemoteSettings().setBinningSpatial(textActionEvent.getValueInt());
                    settingsPanelCallback.reloadInformation();
                }
            });
        }
    }
}

