/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.component;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.map.common.error.Logg;

public class NetworkAdapterIPComboBoxInputField
extends BreezeComboBoxInputField<String> {
    public NetworkAdapterIPComboBoxInputField(NetworkAdapterIPSettings networkAdapterIPSettings) {
        super("Network Adapter IP", NetworkAdapterIPComboBoxInputField.getAdaptorIps(networkAdapterIPSettings), networkAdapterIPSettings.getHostIp(), networkAdapterIPSettings::setHostIp);
        this.setEditable(true);
        this.setUnit(" ");
        this.setUnitLabelWidth(80);
    }

    private static List<String> getAdaptorIps(NetworkAdapterIPSettings networkAdapterIPSettings) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                    if (inetAddress instanceof Inet6Address) continue;
                    arrayList.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            Logg.warn((String)"Failed to parse network adaptor addresses", (Object[])new Object[]{exception});
        }
        if (!arrayList.contains(networkAdapterIPSettings.getHostIp())) {
            arrayList.add(networkAdapterIPSettings.getHostIp());
        }
        return arrayList;
    }

    public static interface NetworkAdapterIPSettings {
        public String getHostIp();

        public void setHostIp(String var1);
    }
}

