/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.view.preview.MeasurementPopup;

public class RgbBandsInputField
extends JPanel {
    private final BreezeInputField inputField;

    public RgbBandsInputField(BreezeFrame breezeFrame, String string, TextActionEvent.TextActionListener textActionListener) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.inputField = new BreezeInputField("Pseudo RGB bands", string, "", BreezeInputFieldHelper.Format.OneRow);
        this.inputField.setUsage("Pseudo RGB bands for visualization (example: 40;80;120)");
        this.inputField.setLabelWidth(CollapsePanel.DefaultLabelWidth);
        this.inputField.addChangeListener(textActionListener);
        this.inputField.reFormat();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.inputField, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        this.add((Component)EntryMainHelper.createSmallTextButton("Edit", () -> BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Settings.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Set RGB bands", "", (AbstractBreezeCustomPanel)new MeasurementPopup.RgbBandPanel(RgbBands.fromCommaSeparatedString(this.inputField.getValue()), null), null, breezeActionEvent -> {
            RgbBands rgbBands = ((MeasurementPopup.RgbBandPanel)breezeActionEvent.getBreezeCustomPanel()).getRgbBands();
            this.inputField.setTextAndTrigger(rgbBands.toCommaSeparatedString());
        })), gridBagConstraints2);
    }
}

