/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.component;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import lombok.Generated;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSplitPane;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectInformationPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectWavelengthPanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.WavelenghtPreviewPanel;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettingsWithRoi;
import se.prediktera.map.plot.spectral.DataWrapper;

public class SpectralRoiInputField
extends JPanel {
    private final BreezeLabel infoOnCurrentSelectionLabel;

    public SpectralRoiInputField(BreezeFrame breezeFrame, RemoteCamera<? extends RemoteCameraTypeSettingsWithRoi> remoteCamera, WavelengthSelectionListener wavelengthSelectionListener) {
        super(new GridBagLayout());
        this.setOpaque(false);
        BreezeLabel breezeLabel = new BreezeLabel("Spectral ROI", false, 14);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 0, 0, 180);
        this.add((Component)breezeLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 15, 0, 20);
        this.infoOnCurrentSelectionLabel = new BreezeLabel(SpectralRoiInputField.summarizeBands(remoteCamera.getSpectralROI(), remoteCamera.getSettings().getAllBandNames()), false, 14);
        this.infoOnCurrentSelectionLabel.setFontStyle(2);
        this.infoOnCurrentSelectionLabel.setFontSize(12);
        this.add((Component)this.infoOnCurrentSelectionLabel, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.insets = new Insets(0, 5, 0, 20);
        this.add((Component)EntryMainHelper.createSmallTextButton("Edit", () -> {
            BandNames bandNames = ((RemoteCameraTypeSettingsWithRoi)remoteCamera.getSettings()).getAllBandNames();
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Settings.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Spectral ROI", "", (AbstractBreezeCustomPanel)new SpectralROIInputPanel(bandNames, SpectralRoiInputField.getIncluded(remoteCamera.getSpectralROI(), bandNames), null), null, breezeActionEvent -> {
                SpectralROIInputPanel spectralROIInputPanel = (SpectralROIInputPanel)breezeActionEvent.getBreezeCustomPanel();
                StringBuilder stringBuilder = new StringBuilder();
                for (SelectWavelengthPanelStep.WavelengthClass wavelengthClass : spectralROIInputPanel.getWList()) {
                    if (!stringBuilder.isEmpty()) {
                        stringBuilder.append(";");
                    }
                    stringBuilder.append(wavelengthClass.isIncluded() ? "1" : "0");
                }
                wavelengthSelectionListener.updateInformation(stringBuilder.toString());
                this.infoOnCurrentSelectionLabel.setText(SpectralRoiInputField.summarizeBands(stringBuilder.toString(), bandNames));
                this.infoOnCurrentSelectionLabel.repaint();
            });
        }), gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 18;
        gridBagConstraints4.insets = new Insets(0, 5, 0, 0);
        BreezeButton breezeButton = EntryMainHelper.createSmallTextButton("Import as CSV", () -> BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Settings.getColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Enter CSV ROI", "Spectral region of interest per wavelength as csv (example: 0;0;1) - or 1 for all bands", remoteCamera.getSpectralROI(), breezeActionEvent -> wavelengthSelectionListener.updateInformation(breezeActionEvent.result().toString())));
        breezeButton.setPreferredAndMinimumSize(120, breezeButton.getPreferredSize().height);
        this.add((Component)breezeButton, gridBagConstraints4);
    }

    private static boolean[] getIncluded(String string, BandNames bandNames) {
        int n = bandNames.size();
        boolean[] blArray = new boolean[n];
        if (string.equals("1")) {
            Arrays.fill(blArray, true);
            return blArray;
        }
        String[] stringArray = string.split(";");
        for (int i = 0; i < Math.min(n, stringArray.length); ++i) {
            blArray[i] = stringArray[i].trim().equals("1");
        }
        return blArray;
    }

    private static String summarizeBands(String string, BandNames bandNames) {
        int n;
        int n2;
        boolean[] blArray = SpectralRoiInputField.getIncluded(string, bandNames);
        boolean bl = true;
        for (boolean n22 : blArray) {
            if (n22) continue;
            bl = false;
            break;
        }
        if (bl) {
            return "All included ";
        }
        boolean bl2 = true;
        int n3 = -1;
        int n4 = blArray.length;
        int n5 = -1;
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2]) continue;
            if (n2 < n4) {
                n4 = n2;
            } else if (n2 > n) {
                n = n2;
            }
            if (n3 >= 0 && n3 != n2 - 1) {
                bl2 = false;
                break;
            }
            n3 = n2;
        }
        if (bl2) {
            return "Included: " + bandNames.getFormated(n4) + " - " + bandNames.getFormated(n) + " nm ";
        }
        n2 = 0;
        for (boolean bl3 : blArray) {
            if (bl3) continue;
            ++n2;
        }
        return blArray.length - n2 + " of " + blArray.length + " included ";
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Spectrum selection");
        jFrame.setDefaultCloseOperation(3);
        Sample sample = new Sample();
        sample.getSamplePath().setAverageProfile(new float[]{1.0f, 2.0f, 1.0f, 2.0f, 1.0f, 2.0f});
        BandNames bandNames = new BandNames("1", "2", "3", "4", "5", "6");
        jFrame.getContentPane().add((Component)new SpectralROIInputPanel(bandNames, SpectralRoiInputField.getIncluded("1", bandNames), sample), "Center");
        jFrame.setSize(1000, 500);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    @Generated
    public BreezeLabel getInfoOnCurrentSelectionLabel() {
        return this.infoOnCurrentSelectionLabel;
    }

    public static interface WavelengthSelectionListener {
        public void updateInformation(String var1);
    }

    public static class SpectralROIInputPanel
    extends AbstractBreezeCustomPanel {
        private final WavelenghtPreviewPanel.WavelengthBreezeTable wavelengthTablePanel = new WavelenghtPreviewPanel.WavelengthBreezeTable();
        private final SelectInformationPanel selectInformationPanel = new SelectInformationPanel();
        private final ArrayList<SelectWavelengthPanelStep.WavelengthClass> wList = new ArrayList();
        private WavelenghtPreviewPanel.WavelengthSpectralPlot spectralPlot;

        public SpectralROIInputPanel(BandNames bandNames, boolean[] blArray, Sample sample) {
            Object object;
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            int n2 = 0;
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 20, 0, 0);
            this.add((Component)jPanel, gridBagConstraints);
            jPanel.add(EntryMainHelper.createButton("Include", "include", () -> this.changeIncluded(true, false)));
            jPanel.add(EntryMainHelper.createButton("Include Only", "include_only", () -> this.changeIncluded(true, true)));
            jPanel.add(EntryMainHelper.createButton("Exclude", "exclude", () -> this.changeIncluded(false, false)));
            this.wavelengthTablePanel.initTable(new SelectWavelengthPanelStep.WavelengthTableModel(false, n -> 0.0f), null, false);
            this.wavelengthTablePanel.addIntervalListener(new int[]{0}, () -> {
                this.selectInformationPanel.updateInformation(this.wavelengthTablePanel);
                if (this.spectralPlot != null) {
                    this.spectralPlot.repaint();
                }
            });
            for (int i = 0; i < bandNames.size(); ++i) {
                object = new SelectWavelengthPanelStep.WavelengthClass(bandNames.getFormated(i), this.wList.size());
                if (((SelectWavelengthPanelStep.WavelengthClass)object).index < blArray.length) {
                    ((BreezeIntervalClass)object).setIncluded(blArray[((SelectWavelengthPanelStep.WavelengthClass)object).index]);
                }
                this.wList.add((SelectWavelengthPanelStep.WavelengthClass)object);
            }
            this.wavelengthTablePanel.setTableList(this.wList, this.wList.isEmpty() ? null : this.wList.getFirst());
            this.selectInformationPanel.updateInformation(this.wavelengthTablePanel);
            BreezeSplitPane breezeSplitPane = new BreezeSplitPane();
            breezeSplitPane.setLeftComponent((Component)((Object)this.wavelengthTablePanel));
            if (sample != null) {
                Object object2;
                this.spectralPlot = new WavelenghtPreviewPanel.WavelengthSpectralPlot(this.wavelengthTablePanel, this.wavelengthTablePanel.getBackground());
                this.wavelengthTablePanel.addSpectralPlotInteraction(this.spectralPlot);
                object = sample.measurement();
                float[] fArray = sample.getPath().getAverageProfile();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (fArray != null) {
                    object2 = new DataWrapper(((Measurement)object).getBandNames().toFloatArray(), fArray, "");
                    object2.setColor(RtPerfectSpread.generateColor(0));
                    object2.setStroke((Stroke)new BasicStroke(4.0f, 1, 0, 10.0f));
                    arrayList.add(object2);
                }
                this.spectralPlot.setData(arrayList);
                object2 = new BreezeSplitPane(0);
                ((JSplitPane)object2).setTopComponent(this.selectInformationPanel);
                ((JSplitPane)object2).setBottomComponent((Component)((Object)this.spectralPlot));
                breezeSplitPane.setRightComponent((Component)object2);
            } else {
                breezeSplitPane.setRightComponent(this.selectInformationPanel);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(10, 20, 10, 20);
            this.add((Component)breezeSplitPane, gridBagConstraints);
            BreezeFrame.setRelativeSize(this, sample != null ? 0.85 : 0.5, 0.85);
        }

        private void changeIncluded(boolean bl, boolean bl2) {
            BreezeTable breezeTable = this.wavelengthTablePanel.getTable();
            if (bl2) {
                for (int i = 0; i < ((JTable)((Object)breezeTable)).getRowCount(); ++i) {
                    ((BreezeIntervalClass)((JTable)((Object)breezeTable)).getValueAt(i, 0)).setIncluded(false);
                }
            }
            for (Object e : this.wavelengthTablePanel.getSelectedValues()) {
                ((BreezeIntervalClass)e).setIncluded(bl);
            }
            this.wavelengthTablePanel.repaint();
            this.selectInformationPanel.updateInformation(this.wavelengthTablePanel);
            if (this.spectralPlot != null) {
                this.spectralPlot.repaint();
            }
        }

        public boolean[] getResult() {
            boolean[] blArray = new boolean[this.wList.size()];
            for (int i = 0; i < this.wList.size(); ++i) {
                blArray[i] = this.wList.get(i).isIncluded();
            }
            return blArray;
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Generated
        public ArrayList<SelectWavelengthPanelStep.WavelengthClass> getWList() {
            return this.wList;
        }
    }
}

