/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.component;

import java.util.Arrays;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.component.TriggerSettings;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class TriggerCollapsePanel
extends CollapsePanel {
    private final Hardware.SettingsPanelCallback callback;
    private final TriggerSettings settings;
    private final RemoteCamera camera;
    private final TcpManager tcpManager = TcpManager.getInstance();

    public TriggerCollapsePanel(RemoteCamera remoteCamera, Hardware.SettingsPanelCallback settingsPanelCallback, TriggerSettings triggerSettings) {
        super("Trigger settings", true, true);
        this.callback = settingsPanelCallback;
        this.settings = triggerSettings;
        this.camera = remoteCamera;
        this.fillPanel();
    }

    private void fillPanel() {
        this.addPanel(new TriggerSourceInputField(this.settings.getTriggerSource(), this::setTriggerSource));
        this.addPanel(new TriggerSelectorInputField(this.settings.getTriggerSelector(), this::setTriggerSelector));
        this.addPanel(new TriggerActivationInputField(this.settings.getTriggerActivation(), this::setTriggerActivation));
        BreezeInputField.Number number = new BreezeInputField.Number("Trigger Exposure Max", this.settings.getTriggerDelay(), "\u00b5s", this::setTriggerControlMax);
        number.setUsage("Trigger Controlled Exposure Time Max");
        this.addPanel(number);
        BreezeInputField.Number number2 = new BreezeInputField.Number("Trigger Exposure Min", this.settings.getTriggerDelay(), "\u00b5s", this::setTriggerControlMin);
        number2.setUsage("Trigger Controlled Exposure Time Min");
        this.addPanel(number2);
        this.addPanel(new BreezeInputField.Number("Trigger delay", this.settings.getTriggerDelay(), "\u00b5s", this::setTriggerDelay));
        this.addPanel(new BreezeCheckBoxInputField("Trigger mode", this.settings.getTriggerMode(), this::setTriggerMode));
    }

    private void setTriggerControlMax(TextActionEvent textActionEvent) {
        float f = textActionEvent.getValueFloat();
        this.settings.setTriggerControlledExposureTimeMax(f);
        if (this.camera.isConnected()) {
            this.tcpManager.setCameraProperty((Camera)this.camera, "TriggerControlledExposureTimeMax", f);
            this.callback.reloadInformation();
        }
    }

    private void setTriggerControlMin(TextActionEvent textActionEvent) {
        float f = textActionEvent.getValueFloat();
        this.settings.setTriggerControlledExposureTimeMin(f);
        if (this.camera.isConnected()) {
            this.tcpManager.setCameraProperty((Camera)this.camera, "TriggerControlledExposureTimeMin", f);
            this.callback.reloadInformation();
        }
    }

    private void setTriggerMode(boolean bl) {
        this.settings.setTriggerMode(bl);
        if (this.camera.isConnected()) {
            this.tcpManager.setCameraProperty((Camera)this.camera, "TriggerMode", Boolean.toString(bl));
            this.callback.reloadInformation();
        }
    }

    private void setTriggerSelector(String string) {
        this.settings.setTriggerSelector(string);
        if (this.camera.isConnected()) {
            this.tcpManager.setCameraProperty((Camera)this.camera, "TriggerSelector", string);
            this.callback.reloadInformation();
        }
    }

    private void setTriggerActivation(String string) {
        this.settings.setTriggerActivation(string);
        if (this.camera.isConnected()) {
            this.tcpManager.setCameraProperty((Camera)this.camera, "TriggerActivation", string);
            this.callback.reloadInformation();
        }
    }

    private void setTriggerSource(String string) {
        this.settings.setTriggerSource(string);
        if (this.camera.isConnected()) {
            this.tcpManager.setCameraProperty((Camera)this.camera, "TriggerSource", string);
            this.callback.reloadInformation();
        }
    }

    private void setTriggerDelay(TextActionEvent textActionEvent) {
        float f = textActionEvent.getValueFloat();
        this.settings.setTriggerDelay(f);
        if (this.camera.isConnected()) {
            this.tcpManager.setCameraProperty((Camera)this.camera, "TriggerDelay", f);
            this.callback.reloadInformation();
        }
    }

    private class TriggerSourceInputField
    extends BreezeComboBoxInputField<String> {
        public TriggerSourceInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Trigger Source", TriggerCollapsePanel.this.settings.getTriggerSourcesAvailable(), string, selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
            this.setUsage("Source of trigger, when TriggerMode is On. This might be an hardware trigger, a fixed rate generator, or software trigger only.");
        }
    }

    private class TriggerSelectorInputField
    extends BreezeComboBoxInputField<String> {
        public TriggerSelectorInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Trigger Selector", TriggerCollapsePanel.this.settings.getTriggerSelectorsAvailable(), string, selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
            this.setUsage("FrameStart is the trigger which starts each image (when acquisition is running). AcquisitionStart is the trigger which starts the acquisition process.");
        }
    }

    private class TriggerActivationInputField
    extends BreezeComboBoxInputField<String> {
        public TriggerActivationInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Trigger Activation", Arrays.asList("RisingEdge", "FallingEdge", "AnyEdge", "LevelHigh", "LevelLow"), string, selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
            this.setUsage("Type of activation, for hardware triggers. This controls edge/level and polarity sensitivities");
        }
    }
}

