/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.frame;

import java.lang.reflect.Array;

public class RingBuffer<T> {
    private final T[] ringBuffer;
    private final Object lock = new Object();
    private final int size;
    private int pos = 0;
    private int filled = 0;
    private int missed = 0;

    public RingBuffer(Class<T> clazz, int n) {
        this.size = n;
        this.ringBuffer = (Object[])Array.newInstance(clazz, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.pos = 0;
            this.filled = 0;
            this.missed = 0;
        }
    }

    public int getFilled() {
        return this.filled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int n) {
        Object object = this.lock;
        synchronized (object) {
            int n2 = (this.size + this.pos - this.filled + n) % this.size;
            return this.ringBuffer[n2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLast() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos == 0) {
                return this.ringBuffer[this.size - 1];
            }
            return this.ringBuffer[this.pos - 1];
        }
    }

    public int getMissed() {
        return this.missed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getNext() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos < this.ringBuffer.length) {
                return this.ringBuffer[this.pos];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getNextInc() {
        Object object = this.lock;
        synchronized (object) {
            T t = this.ringBuffer[this.pos];
            this.pos = (this.pos + 1) % this.size;
            if (this.filled < this.size) {
                ++this.filled;
            }
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll() {
        Object object = this.lock;
        synchronized (object) {
            if (this.filled > 0) {
                T t = this.get(0);
                --this.filled;
                return t;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDirect(T t) {
        Object object = this.lock;
        synchronized (object) {
            this.ringBuffer[this.pos] = t;
            this.pos = (this.pos + 1) % this.size;
            if (this.filled < this.size) {
                ++this.filled;
            } else {
                ++this.missed;
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public void cleanUp() {
        for (int i = 0; i < this.size; ++i) {
            this.ringBuffer[i] = null;
        }
    }
}

