/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.rgb;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunctionLagrangeForm;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.map.common.Threader;

public class RgbInterpolation {
    private final BandCount bandCount;
    private final byte[][][][] matrix;

    public RgbInterpolation(BreezeProgress breezeProgress, BandCount bandCount) {
        this.bandCount = bandCount;
        this.matrix = this.createRGBInterpolationMatrix(bandCount);
    }

    public final List<Frame> interpolateImage(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        SampleModel sampleModel = writableRaster.getSampleModel();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        ArrayList<Frame> arrayList = new ArrayList<Frame>(n);
        BandCount bandCount = new BandCount(this.matrix[0][0][0].length);
        PixelWidth pixelWidth = new PixelWidth(n2);
        for (int i = 0; i < n; ++i) {
            ByteFrameArray byteFrameArray = new ByteFrameArray(bandCount, pixelWidth, BandNames.fromIndex(bandCount.value));
            for (int j = 0; j < n2; ++j) {
                int n3 = sampleModel.getSample(j, i, 0, dataBuffer);
                int n4 = sampleModel.getSample(j, i, 1, dataBuffer);
                int n5 = sampleModel.getSample(j, i, 2, dataBuffer);
                byteFrameArray.setArray(j, this.matrix[n3][n4][n5]);
            }
            arrayList.add(byteFrameArray);
        }
        return arrayList;
    }

    public BandCount getBandCount() {
        return this.bandCount;
    }

    private final byte[][][][] createRGBInterpolationMatrix(final BandCount bandCount) {
        final byte[][][][] byArray = new byte[256][256][256][bandCount.value];
        final double d = 1.0 / ((double)bandCount.value - 1.0) * 2.0;
        Threader threader = new Threader(this){

            protected void doOp(boolean bl, int n, int n2) {
                for (int i = n; i < n2; ++i) {
                    for (int j = 0; j < 256; ++j) {
                        for (int k = 0; k < 256; ++k) {
                            PolynomialFunctionLagrangeForm polynomialFunctionLagrangeForm = new PolynomialFunctionLagrangeForm(new double[]{0.0, 1.0, 2.0}, new double[]{i, j, k});
                            byArray[i][j][k] = new byte[bandCount.value];
                            for (int i2 = 0; i2 < bandCount.value; ++i2) {
                                double d2 = polynomialFunctionLagrangeForm.value((double)i2 * d);
                                byArray[i][j][k][i2] = d2 < 0.0 ? 0 : (d2 > 255.0 ? -1 : (byte)d2);
                            }
                        }
                    }
                }
            }
        };
        threader.execute(256);
        return byArray;
    }

    public static class ByteFrameArray
    extends Frame
    implements Cloneable {
        private final byte[][] origframe;

        public ByteFrameArray(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
            super(bandCount, pixelWidth, bandNames);
            this.origframe = new byte[pixelWidth.value][];
        }

        @Override
        public ByteFrame copy() {
            throw new RuntimeException("Not implemented");
        }

        public final byte getFrameValueNative(int n, int n2) {
            return this.origframe[n2][n];
        }

        @Override
        public final float getFrameValue(int n, int n2) {
            return this.origframe[n2][n] & 0xFF;
        }

        public final void setArray(int n, byte[] byArray) {
            this.origframe[n] = byArray;
        }

        @Override
        public final void setFrameValue(int n, int n2, float f) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public DataSize getType() {
            return DataSize.BYTE_1;
        }
    }
}

