/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.rgb;

import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.camera.component.IScanMode;
import se.prediktera.breeze.hardware.camera.component.SpatialRoiInputField;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.NiceDataFormat;

public class RgbUsbCamera
extends RemoteCamera<RgbUsbCameraSettings>
implements StateCamera,
Camera.SnapshotCamera {
    @Override
    protected RgbUsbCameraSettings createSettings() {
        return new RgbUsbCameraSettings(this);
    }

    @Override
    public FieldOfView getFieldOfView() {
        if (this.isConnected() && ((RgbUsbCameraSettings)this.settings).fixedLength()) {
            return new FieldOfView(this.getWidth().value);
        }
        return BreezeProperties.getInstance().getCameraFieldOfView(this);
    }

    @Override
    public boolean canChangeView() {
        return !((RgbUsbCameraSettings)this.settings).fixedLength();
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    public MeasurementLength getMeasurementLength() {
        if (((RgbUsbCameraSettings)this.settings).fixedLength()) {
            if (this.isConnected()) {
                return new MeasurementLength(this.getHeight().value, MeasurementLength.LengthUnit.frames);
            }
            return new MeasurementLength(0.0f);
        }
        return BreezeProperties.getInstance().getMeasurementLength();
    }

    @Override
    public boolean canChangeLength() {
        return !((RgbUsbCameraSettings)this.settings).fixedLength();
    }

    @Override
    public String getDeviceName() {
        return "RgbUsbCamera";
    }

    @Override
    public boolean hasWhiteReference() {
        return true;
    }

    @Override
    public boolean autoChangeState() {
        return true;
    }

    @Override
    public Camera.CameraCaptureType getType() {
        return ((RgbUsbCameraSettings)this.settings).getType();
    }

    public String toString() {
        return "Rgb USB Camera";
    }

    @Override
    public boolean useReferencesWhenRecordingWithThisCamera() {
        return ((RgbUsbCameraSettings)this.settings).useReference();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Mode", this.getType().toString());
        informationList.add("CameraHeight", this.getHeight().value);
        informationList.add("Spatial ROI", this.getSpatialRoi());
    }

    @Override
    public boolean hasShutter() {
        return true;
    }

    @Override
    public FrameCount getHeight() {
        return ((RgbUsbCameraSettings)this.settings).getHeight();
    }

    public static class RgbUsbCameraSettings
    extends RemoteCameraTypeSettings
    implements IScanMode {
        private FrameRate frameRate;

        public RgbUsbCameraSettings(RemoteCamera<RgbUsbCameraSettings> remoteCamera) {
            super(remoteCamera);
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("ImageWidth", (Object)this.getImageWidth()));
            list.add(new Command.Argument("ImageHeight", (Object)this.getImageHeight()));
            list.add(new Command.Argument("Type", this.getType()));
            list.add(new Command.Argument("SpatialROI", (Object)this.getSpatialRoi()));
            return list;
        }

        public FrameRate frameRate() {
            if (this.frameRate == null) {
                this.frameRate = new FrameRate(BreezeProperties.getInstance().getCameraPropertyInt(this.camera, "frameRate", 480));
            }
            return this.frameRate;
        }

        public void setFrameRate(FrameRate frameRate) {
            this.frameRate = frameRate;
            BreezeProperties.getInstance().setCameraProperty(this.camera, "frameRate", NiceDataFormat.toString((double)frameRate.value));
        }

        public boolean useReference() {
            return BreezeProperties.getInstance().getCameraPropertyBool(this.camera, "useReference", false);
        }

        public void setUseReference(boolean bl) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "useReference", Boolean.toString(bl));
        }

        @Override
        public boolean fixedLength() {
            return BreezeProperties.getInstance().getCameraPropertyBool(this.camera, "fixedLength", true);
        }

        public Camera.CameraCaptureType getType() {
            return this.fixedLength() ? Camera.CameraCaptureType.Snapshot : Camera.CameraCaptureType.Linescan;
        }

        @Override
        public void setFixedLength(boolean bl) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "fixedLength", Boolean.toString(bl));
        }

        public void setSpatialRoi(String string) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "spatialRoi", string);
        }

        public String getSpatialRoi() {
            return BreezeProperties.getInstance().getCameraProperty(this.camera, "spatialRoi", "");
        }

        public final void setImageWidth(int n) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "imageWidth", String.valueOf(n));
        }

        public final int getImageWidth() {
            return BreezeProperties.getInstance().getCameraPropertyInt(this.camera, "imageWidth", 640);
        }

        public final void setImageHeight(int n) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "imageHeight", String.valueOf(n));
        }

        public final int getImageHeight() {
            return BreezeProperties.getInstance().getCameraPropertyInt(this.camera, "imageHeight", 480);
        }
    }

    private class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            if (!RgbUsbCamera.this.isConnected()) {
                InputFieldHelper.addPanel(this, new CameraType.CameraTypeInputField(settingsPanelCallback, RgbUsbCamera.this.settings, cameraType -> {}));
                InputFieldHelper.addPanel(this, new AdvancedPanel(breezeFrame, settingsPanelCallback));
            }
            this.setOpaque(false);
        }

        private class AdvancedPanel
        extends CollapsePanel {
            public AdvancedPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
                super("Advanced");
                this.addPanel(new BreezeCheckBoxInputField("Use first line as white reference", ((RgbUsbCameraSettings)RgbUsbCamera.this.settings).useReference(), ((RgbUsbCameraSettings)RgbUsbCamera.this.settings)::setUseReference));
                this.addPanel(new Camera.MirrorLineInputField(RgbUsbCamera.this.settings));
                this.addPanel(new ScanModeInputField(RgbUsbCamera.this, (IScanMode)((Object)RgbUsbCamera.this.settings), settingsPanelCallback));
                this.addPanel(new BreezeInputField.Number("Width", (double)((RgbUsbCameraSettings)RgbUsbCamera.this.settings).getImageWidth(), "px", textActionEvent -> ((RgbUsbCameraSettings)settingsPanel.RgbUsbCamera.this.settings).setImageWidth(textActionEvent.getValueInt())));
                this.addPanel(new BreezeInputField.Number("Height", (double)((RgbUsbCameraSettings)RgbUsbCamera.this.settings).getImageHeight(), "px", textActionEvent -> ((RgbUsbCameraSettings)settingsPanel.RgbUsbCamera.this.settings).setImageHeight(textActionEvent.getValueInt())));
                String string = ((RgbUsbCameraSettings)RgbUsbCamera.this.settings).getSpatialRoi();
                SpatialRoiInputField spatialRoiInputField = new SpatialRoiInputField(string, textActionEvent -> {
                    ((RgbUsbCameraSettings)settingsPanel.RgbUsbCamera.this.settings).setSpatialRoi(textActionEvent.getText());
                    settingsPanelCallback.reloadInformation();
                }, "Spatial region of interest with start pixel to end pixel (100-200)");
                this.addPanel(spatialRoiInputField, null, 250);
                this.addPanel(new Camera.OffsetInputField(breezeFrame, RgbUsbCamera.this, settingsPanelCallback));
            }
        }
    }

    public static class ScanModeInputField
    extends BreezeComboBoxInputField<Camera.CameraCaptureType> {
        public ScanModeInputField(RemoteCamera remoteCamera, IScanMode iScanMode, Hardware.SettingsPanelCallback settingsPanelCallback) {
            super("Scan mode", " ", BreezeInputFieldHelper.Format.OneRow);
            this.addItem(Camera.CameraCaptureType.Snapshot);
            this.addItem(Camera.CameraCaptureType.Linescan);
            this.setSelectedItem(iScanMode.fixedLength() ? Camera.CameraCaptureType.Snapshot : Camera.CameraCaptureType.Linescan);
            this.setChangedListener(cameraCaptureType -> {
                boolean bl = !cameraCaptureType.isSingleLine();
                iScanMode.setFixedLength(bl);
                if (remoteCamera.isConnected()) {
                    TcpManager.getInstance().setCameraProperty((Camera)remoteCamera, "Snapshot", Boolean.toString(bl));
                }
                settingsPanelCallback.reloadInformation();
            });
        }
    }
}

