/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.camera.spectra;

import se.prediktera.breeze.common.util.type.BandCount;

public abstract class Spectra {
    private final BandCount rows;

    public Spectra(BandCount bandCount) {
        this.rows = bandCount;
    }

    public BandCount getRows() {
        return this.rows;
    }

    public static class FloatSpectra
    extends Spectra {
        final float[] values;

        public FloatSpectra(BandCount bandCount) {
            super(bandCount);
            this.values = new float[bandCount.value];
        }

        public FloatSpectra(float[] fArray) {
            super(new BandCount(fArray.length));
            this.values = fArray;
        }

        public float[] getValues() {
            return this.values;
        }
    }
}

