/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.runtime;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.util.SocketExceptionFilter;
import se.prediktera.map.common.error.Logg;

public class BreezeRuntimeConnection
implements Closeable {
    private final Socket socket;
    private final BufferedReader reader;
    private final OutputStreamWriter out;

    public BreezeRuntimeConnection(BreezeProgress breezeProgress, String string, int n) {
        try {
            this.socket = new RetrySocket(string, n).connect(breezeProgress, 10, new Time.MilliSeconds(250L));
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8));
            this.out = new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public synchronized void send(String string) {
        try {
            this.out.write(string);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String readLine() throws BreezeRuntimeDisconnectedException {
        try {
            return this.reader.readLine();
        }
        catch (IOException iOException) {
            if (new SocketExceptionFilter(iOException).isSocketException()) {
                throw new BreezeRuntimeDisconnectedException(iOException);
            }
            return null;
        }
    }

    @Override
    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static class RetrySocket {
        private final String host;
        private final int port;

        public RetrySocket(String string, int n) {
            this.host = string;
            this.port = n;
        }

        public Socket connect(BreezeProgress breezeProgress, int n, Time time) {
            RetrySocket.checkForProxy(this.host, this.port);
            Exception exception = null;
            for (int i = 0; i < n; ++i) {
                try {
                    if (exception != null) {
                        ThreadUtil.sleep(200L);
                    }
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(this.host, this.port), 1000);
                    return socket;
                }
                catch (Exception exception2) {
                    Logg.error((String)("Cannot connect to Breeze Runtime (" + (i + 1) + " of " + n + "): " + exception2.getMessage()), (Object[])new Object[0]);
                    exception = exception2;
                    if (breezeProgress != null && breezeProgress.isAborted()) {
                        throw new BreezeProgress.ProgressActionCancelledException();
                    }
                    ThreadUtil.sleep(time);
                    continue;
                }
            }
            throw new RuntimeException(exception);
        }

        private static void checkForProxy(String string, int n) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
                for (Proxy proxy : ProxySelector.getDefault().select(new URI("http://" + string + ":" + n))) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
                    if (proxy.type().equals((Object)Proxy.Type.DIRECT) || inetSocketAddress == null) continue;
                    throw new RuntimeException("Proxy settings prevents connection to BreezeRuntime\n(proxy: hostname=" + inetSocketAddress.getHostName() + ", port=" + inetSocketAddress.getPort() + ")\n\nPlease disable proxy for \"" + string + "\" on port " + n + " and try again.");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public static class BreezeRuntimeDisconnectedException
    extends Exception {
        public BreezeRuntimeDisconnectedException(IOException iOException) {
            super(iOException);
        }
    }
}

