/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import org.apache.commons.lang3.SystemUtils;

public class BreezeRuntimeHelper {
    public static File getBreezeRuntimePathForTest() {
        return BreezeRuntimeHelper.getBreezeRuntimePathForTest(false);
    }

    public static File getBreezeRuntimePathForTest(boolean bl) {
        for (String string : BreezeRuntimeHelper.getPaths(bl)) {
            File file;
            if (string == null || !(file = new File(string)).exists()) continue;
            return file;
        }
        throw new FileNotFoundException("Cannot find BreezeRuntime path");
    }

    private static String[] getPaths(boolean bl) {
        String string = BreezeRuntimeHelper.getAppPath(bl);
        String string2 = System.getProperty("user.home");
        Object object = System.getenv("RUNTIME_PATH");
        if (object != null) {
            object = (String)object + "/BreezeRuntime";
            if (SystemUtils.IS_OS_WINDOWS) {
                object = (String)object + ".exe";
            }
        }
        return new String[]{object, string2 + "/dev" + string + "BreezeRuntime.exe", "C:/Dev" + string + "BreezeRuntime.exe", "C:/Prediktera" + string + "BreezeRuntime.exe", "D:/Prediktera" + string + "BreezeRuntime.exe", string2 + "/Prediktera" + string + "BreezeRuntime.dll", string2 + string + "BreezeRuntime", string2 + string + "BreezeRuntime.dll", "C:/Program Files/Prediktera/Breeze/Runtime/BreezeRuntime.exe"};
    }

    private static String getAppPath(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/breeze-runtime/src/BreezeRuntime/bin");
        if (SystemUtils.IS_OS_WINDOWS) {
            stringBuilder.append("/x64");
        }
        stringBuilder.append(bl ? "/Release/net9.0/" : "/Debug/net9.0/");
        return stringBuilder.toString();
    }

    public static boolean isLocalHost(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
                return true;
            }
            return NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

