/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeHelper;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeProcessWindow;
import se.prediktera.breeze.hardware.runtime.DefaultBreezeRuntime;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.IniManager;

public abstract class BreezeRuntimeProcess {
    public static final int PingInterval = 1;
    protected final File breezeRuntimePath;
    private Process ownedRunningProcess;
    private BreezeRuntimeProcessWindow processWindow;
    private static File exitCodeFile;

    public BreezeRuntimeProcess(File file) {
        this.breezeRuntimePath = file;
    }

    public BreezeRuntimeProcess(File file, int n, File file2, String string, Integer n2, Boolean bl, String string2, boolean bl2, BreezeProgress breezeProgress) {
        File file3 = this.checkBreezeRuntimePath(file);
        exitCodeFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        exitCodeFile.deleteOnExit();
        Logg.info((String)"Attempting to start local BreezeRuntime process '{}'...", (Object[])new Object[]{file});
        ProcessBuilder processBuilder = this.generateProcessBuilder(file, n, file2, string, n2, bl, string2);
        String string3 = BreezeProperties.getInstance().getBreezeRuntimeConnectHost();
        FileUtils.deleteQuietly((File)BreezeRuntimeProcess.getPidFile().toFile());
        Long l = BreezeRuntimeProcess.getRuntimeProcessHandle().map(ProcessHandle::pid).orElse(0L);
        boolean bl3 = SystemUtils.IS_OS_WINDOWS && Windows.existsAsService();
        breezeProgress.setInfoText(bl3 ? "Starting Breeze Runtime Service" : "Starting Breeze Runtime");
        processBuilder.directory(file3.getParentFile());
        if (bl3) {
            Logg.info((String)"Starting BreezeRuntime as a Windows Service", (Object[])new Object[0]);
        }
        if (!bl2 || bl3) {
            processBuilder.inheritIO();
            processBuilder.redirectError(exitCodeFile);
            this.ownedRunningProcess = processBuilder.start();
        } else {
            processBuilder.redirectErrorStream(true);
            this.processWindow = new BreezeRuntimeProcessWindow("Breeze Runtime", processBuilder);
            this.ownedRunningProcess = this.processWindow.getProcess();
        }
        try {
            boolean bl4 = ThreadUtil.awaitAndReturn(() -> !BreezeRuntimeProcess.getRuntimeProcessHandle().map(ProcessHandle::pid).orElse(l).equals(l), new Time.MilliSeconds(100L), new Time.Seconds((double)BreezeProperties.getInstance().getStartTimeoutSeconds()));
            if (!bl4) {
                throw new ThreadUtil.TimeoutException("Runtime failed to start");
            }
            ThreadUtil.awaitOrThrow(() -> BreezeRuntimeProcess.isSocketAlive(string3, n), new Time.Seconds(5.0), "Failed to connect to socket");
            Logg.debug((String)("BreezeRuntime started with pid: " + String.valueOf(BreezeRuntimeProcess.getRuntimeProcessHandle().map(ProcessHandle::pid).orElse(-1L))), (Object[])new Object[0]);
        }
        catch (ThreadUtil.TimeoutException timeoutException) {
            String string4 = this.readErrorFromFile();
            Object object = "Failed to confirm Breeze Runtime start";
            if (!StringUtils.isEmpty((CharSequence)string4)) {
                object = (String)object + "\nError file data: " + string4;
            }
            object = (String)object + "\nos.name: " + System.getProperty("os.name");
            object = (String)object + "\nos.version: " + System.getProperty("os.version");
            object = (String)object + "\nos.arch: " + System.getProperty("os.arch");
            Logg.warn((String)object, (Object[])new Object[0]);
            ToastHandler.getInstance().showToast(BreezeFrame.getInstance(), "Failed to start Runtime", Toast.IconType.Error, new Time.Seconds(30.0));
            throw new RuntimeException((String)object);
        }
        this.breezeRuntimePath = file3;
    }

    private String readErrorFromFile() {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(exitCodeFile.toPath()));
        }
        catch (IOException iOException) {
            return "Cannot read error file: " + iOException.getMessage();
        }
    }

    public static boolean isSocketAlive(String string, int n) {
        boolean bl = false;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        try (Socket socket = new Socket();){
            socket.connect(inetSocketAddress, 200);
            bl = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    protected abstract ProcessBuilder generateProcessBuilder(File var1, int var2, File var3, String var4, Integer var5, Boolean var6, String var7);

    protected List<String> getRuntimeArguments(File file, String string, Integer n, Boolean bl, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        UpdateHelper.Product product = BreezeFrame.getRunningProduct();
        arrayList.add("/product:" + String.valueOf(product));
        if (product.usePing()) {
            arrayList.add("/ping:1");
        }
        if (file != null) {
            arrayList.add("/w:" + file.getAbsolutePath());
        }
        if (string != null) {
            arrayList.add("/e:" + string);
        }
        if (n != null && n > 0) {
            arrayList.add("/t:" + n);
        }
        if (bl != null) {
            arrayList.add("/f:" + bl);
        }
        if (string2 != null) {
            arrayList.add("/s:" + string2);
        }
        return arrayList;
    }

    protected void addArguments(File file, String string, Integer n, Boolean bl, String string2, List<String> list) {
        list.addAll(this.getRuntimeArguments(file, string, n, bl, string2));
    }

    private File checkBreezeRuntimePath(File file) {
        if (file.exists()) {
            return file;
        }
        File file2 = BreezeRuntimeProcess.getDefaultBreezeRuntimePath();
        if (file2.exists()) {
            BreezeProperties.getInstance().setBreezeRuntimeExeFile(file2);
            throw new ErrorHandler.InformationMessageException("Breeze Runtime path has been reset:\n" + file2.getAbsolutePath() + "\n\nPlease try to connect again");
        }
        throw new RuntimeException("Unable to start Breeze Runtime.\n\nNo " + file2.getName() + " found at:\n" + String.valueOf(file) + "\n\nPlease reinstall Breeze and try again.");
    }

    public void kill() {
        if (this.ownedRunningProcess == null) {
            return;
        }
        this.ownedRunningProcess.destroy();
        try {
            this.ownedRunningProcess.onExit().get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            Logg.warn((String)"Process.destroy wait interrupted. Will now attempt to destroyForcibly.", (Object[])new Object[0]);
        }
        catch (TimeoutException timeoutException) {
            Logg.error((String)"Process.destroy wait timed out. Will now attempt to destroyForcibly.", (Object[])new Object[0]);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        if (this.ownedRunningProcess.isAlive()) {
            this.ownedRunningProcess.destroyForcibly();
        }
        this.ownedRunningProcess = null;
        if (this.processWindow != null) {
            this.processWindow.setVisible(false);
            this.processWindow = null;
        }
    }

    public static boolean closeAnyRuntimeProcess() {
        if (BreezeRuntimeProcess.isAnyBreezeRuntimeRunning()) {
            BreezeRuntimeProcess.forceKillAny();
            return true;
        }
        return false;
    }

    public static void forceKillAny() {
        Optional<ProcessHandle> optional = BreezeRuntimeProcess.getRuntimeProcessHandle();
        if (optional.isEmpty()) {
            Logg.warn((String)"No pid file found", (Object[])new Object[0]);
            return;
        }
        ProcessHandle processHandle = optional.get();
        processHandle.destroy();
        try {
            processHandle.onExit().get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            Logg.warn((String)"ProcessHandle.destroy wait interrupted. Will now attempt to destroyForcibly.", (Object[])new Object[0]);
        }
        catch (TimeoutException timeoutException) {
            Logg.error((String)"ProcessHandle.destroy wait timed out. Will now attempt to destroyForcibly.", (Object[])new Object[0]);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
        if (processHandle.isAlive()) {
            processHandle.destroyForcibly();
        }
    }

    public static Optional<ProcessHandle> getRuntimeProcessHandle() {
        Path path = BreezeRuntimeProcess.getPidFile();
        if (!Files.exists(path, new LinkOption[0])) {
            return Optional.empty();
        }
        List<String> list = Files.readAllLines(path);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        long l = RtDataFormat.toNumberLong(list.getFirst());
        Optional<ProcessHandle> optional = ProcessHandle.allProcesses().filter(processHandle -> processHandle.pid() == l).findFirst();
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        if (StringHelper.containsIgnoreCase((CharSequence)optional.get().info().command().orElse(""), (CharSequence)"Breeze")) {
            return optional;
        }
        if (SystemUtils.IS_OS_WINDOWS && BreezeRuntimeProcess.handleBreezeRuntimeProcessOnWindows(l)) {
            return optional;
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean handleBreezeRuntimeProcessOnWindows(long l) {
        ProcessBuilder processBuilder = new ProcessBuilder("powershell.exe", "-Command", String.format("Get-Process -Id %d|select -ExpandProperty ProcessName", l));
        try {
            Process process = processBuilder.start();
            StringBuilder stringBuilder = new StringBuilder();
            try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
            }
            if (StringHelper.containsIgnoreCase((CharSequence)stringBuilder.toString(), (CharSequence)"Breeze")) {
                return true;
            }
        }
        catch (IOException iOException) {
            processBuilder = new ProcessBuilder("tasklist.exe");
            try {
                Pattern pattern = Pattern.compile("\\b" + l + "\\b");
                Process process = processBuilder.start();
                Logg.info((String)"Using tasklist as a fallback.", (Object[])new Object[0]);
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        String[] stringArray;
                        String string2;
                        Matcher matcher = pattern.matcher(string);
                        if (!matcher.find() || !StringHelper.containsIgnoreCase((CharSequence)(string2 = Optional.ofNullable((stringArray = string.split("\\s+"))[0]).orElse("Unknown")), (CharSequence)"Breeze")) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (IOException iOException2) {
                Logg.warn((String)"Neither PowerShell nor tasklist are available.", (Object[])new Object[0]);
            }
        }
        if (BreezeRuntimeProcess.getPidFile().toFile().delete()) return false;
        Logg.warn((String)"Failed to clear Breeze Runtime pid file", (Object[])new Object[0]);
        return false;
    }

    private static Path getPidFile() {
        return Paths.get(IniManager.getPredikteraPath(), "Breeze", "runtime.pid");
    }

    public static boolean isAnyBreezeRuntimeRunning() {
        return BreezeRuntimeProcess.getRuntimeProcessHandle().isPresent();
    }

    public static File getDefaultBreezeRuntimePath() {
        File file = BreezeRuntimeProcess.getStartFolder();
        File file2 = new File(file, "Runtime");
        if (SystemUtils.IS_OS_WINDOWS) {
            File file3 = new File(file2, "BreezeRuntime.exe");
            if (file3.exists()) {
                return file3;
            }
            return new File(new File(System.getenv("programfiles"), "Prediktera/Breeze/Runtime"), "BreezeRuntime.exe");
        }
        return new File(file2, "BreezeRuntime");
    }

    private static File getStartFolder() {
        try {
            File file = new File(BreezeRuntimeProcess.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            return file.getParentFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(System.getProperty("user.dir"));
        }
    }

    public static void main(String[] stringArray) {
        DefaultBreezeRuntime defaultBreezeRuntime = new DefaultBreezeRuntime();
        if (!defaultBreezeRuntime.isAnyBreezeRuntimeRunning()) {
            defaultBreezeRuntime.startBreezeRuntime(BreezeRuntimeHelper.getBreezeRuntimePathForTest(false), 2000, true, BreezeProgressImpl.createEmpty());
        }
        defaultBreezeRuntime.closeServer();
    }

    static {
        try {
            exitCodeFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            Logg.error((String)"Fail to create exit code file", (Throwable)iOException);
        }
    }

    public static class Windows
    extends BreezeRuntimeProcess {
        private static final String ServiceName = "BreezeRuntimeService";

        public Windows(File file) {
            super(file);
        }

        public Windows(File file, int n, File file2, String string, Integer n2, Boolean bl, String string2, boolean bl2, BreezeProgress breezeProgress) {
            super(file, n, file2, string, n2, bl, string2, bl2, breezeProgress);
        }

        @Override
        protected ProcessBuilder generateProcessBuilder(File file, int n, File file2, String string, Integer n2, Boolean bl, String string2) {
            if (Windows.existsAsService()) {
                String string3 = new File(file.getParentFile().getParentFile(), "Elevate.exe").getAbsolutePath();
                return new ProcessBuilder(string3, "SC", "START", ServiceName);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = this.getRuntimeArguments(file2, string, n2, bl, string2);
            arrayList.add(file.getAbsolutePath());
            arrayList.addAll(list);
            return new ProcessBuilder(arrayList);
        }

        private static boolean existsAsService() {
            return Windows.getServiceState() != null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static String getServiceState() {
            ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList("SC", "QUERY", ServiceName));
            try {
                Process process = processBuilder.start();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String string;
                    do {
                        if ((string = bufferedReader.readLine()) == null) return null;
                    } while (!string.contains(" STATE"));
                    String[] stringArray = string.split(": ");
                    String string2 = stringArray[1].substring(0, 1);
                    return string2;
                }
            }
            catch (IOException iOException) {
                Logg.error((String)"Failed to collect information if runtime service exists", (Throwable)iOException);
            }
            return null;
        }
    }

    public static class MacOSX
    extends BreezeRuntimeProcess {
        public MacOSX(File file, int n, File file2, String string, Integer n2, Boolean bl, String string2, boolean bl2, BreezeProgress breezeProgress) {
            super(file, n, file2, string, n2, bl, string2, bl2, breezeProgress);
        }

        @Override
        protected ProcessBuilder generateProcessBuilder(File file, int n, File file2, String string, Integer n2, Boolean bl, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            this.addArguments(file2, string, n2, bl, string2, arrayList);
            return new ProcessBuilder(arrayList);
        }
    }

    public static class Linux
    extends BreezeRuntimeProcess {
        public Linux(File file, int n, File file2, String string, Integer n2, Boolean bl, String string2, boolean bl2, BreezeProgress breezeProgress) {
            super(file, n, file2, string, n2, bl, string2, bl2, breezeProgress);
        }

        @Override
        protected ProcessBuilder generateProcessBuilder(File file, int n, File file2, String string, Integer n2, Boolean bl, String string2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            this.addArguments(file2, string, n2, bl, string2, arrayList);
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.directory(file.getParentFile());
            File file3 = new File(file.getParentFile().getAbsolutePath(), "x64");
            if (!file3.exists()) {
                file3 = new File(file.getParentFile().getAbsolutePath(), "arm64");
            }
            String string3 = file3.getAbsolutePath();
            Object object = processBuilder.environment().get("LD_LIBRARY_PATH");
            if (!StringUtils.isEmpty((CharSequence)object)) {
                if (((String)object).contains(string3)) {
                    return processBuilder;
                }
                object = (String)object + ":";
            } else {
                object = "";
            }
            if (file3.exists()) {
                processBuilder.environment().put("LD_LIBRARY_PATH", (String)object + string3);
            }
            return processBuilder;
        }
    }
}

