/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.runtime;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.map.common.update.UpdateHelper;

public class BreezeRuntimeProcessWindow
extends JFrame {
    private final ProcessWorker processWorker;
    public static final Pattern pattern = Pattern.compile("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{4} (\\w+) .*$");
    private final JTextPane textPane;
    private Color lastColor;

    public BreezeRuntimeProcessWindow(String string, ProcessBuilder processBuilder) throws HeadlessException {
        super(string);
        this.setDefaultCloseOperation(3);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.textPane = new JTextPane();
        this.textPane.setBackground(breezeTheme.getDialogBackground());
        this.textPane.setEditable(false);
        this.textPane.setFont(new Font("Courier New", 0, 12));
        this.lastColor = breezeTheme.getLabelForeground();
        this.textPane.setForeground(this.lastColor);
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jPanel.add((Component)jScrollPane, "Center");
        this.add(jPanel);
        this.processWorker = new ProcessWorker(processBuilder, this);
        this.processWorker.execute();
        this.addAbortListener(this.textPane, this);
        UpdateHelper.Product.BreezeRuntime.setFrameIcons((Window)this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BreezeRuntimeProcessWindow.this.processWorker.abort();
            }
        });
        this.setState(1);
        this.setSize(1000, 350);
        this.setVisible(true);
    }

    public Process getProcess() {
        return this.processWorker.getProcess();
    }

    private void addAbortListener(JTextPane jTextPane, final JFrame jFrame) {
        jTextPane.addKeyListener(new KeyListener(){
            final /* synthetic */ BreezeRuntimeProcessWindow this$0;
            {
                this.this$0 = breezeRuntimeProcessWindow;
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 67 && (keyEvent.getModifiersEx() & 0x80) == 128) {
                    this.this$0.printLine("ABORTED");
                    this.this$0.processWorker.abort();
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    protected void printLine(String string) {
        String string2 = string.replace("\\\"", "\"");
        Matcher matcher = pattern.matcher(string2);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        this.lastColor = matcher.find() ? this.getColor(matcher.group(1)) : this.textPane.getForeground();
        StyleConstants.setForeground(simpleAttributeSet, this.lastColor);
        StyledDocument styledDocument = this.textPane.getStyledDocument();
        styledDocument.insertString(styledDocument.getLength(), string2 + "\n", simpleAttributeSet);
        this.textPane.setCaretPosition(styledDocument.getLength());
    }

    private Color getColor(String string) {
        return switch (string) {
            case "INFO" -> this.textPane.getForeground();
            case "DEBUG" -> Color.blue;
            case "TRACE" -> Color.cyan;
            case "WARN" -> Color.yellow;
            case "ERROR" -> Color.red;
            case "FATAL" -> Color.pink;
            default -> null;
        };
    }

    public static void main(String[] stringArray) {
        ProcessBuilder processBuilder = new ProcessBuilder("C:\\Users\\thoma\\dev\\breeze-runtime\\src\\BreezeRuntime\\bin\\Debug\\net9.0\\BreezeRuntime.exe", "/ping:1");
        processBuilder.directory(new File("C:\\Users\\thoma\\dev\\breeze-runtime\\src\\BreezeRuntime\\bin\\Debug\\net9.0"));
        SwingUtilities.invokeLater(() -> new BreezeRuntimeProcessWindow("Breeze Runtime Window TEST", processBuilder));
    }

    public static class ProcessWorker
    extends SwingWorker<Void, String> {
        private final BreezeRuntimeProcessWindow window;
        private final ProcessBuilder pb;
        private Process p;
        private AtomicBoolean started = new AtomicBoolean(false);

        public ProcessWorker(ProcessBuilder processBuilder, BreezeRuntimeProcessWindow breezeRuntimeProcessWindow) {
            this.pb = processBuilder;
            this.window = breezeRuntimeProcessWindow;
        }

        public Process getProcess() {
            while (!this.started.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            return this.p;
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.p = this.pb.start();
            this.started.set(true);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.p.getInputStream()));){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    this.publish(string);
                }
            }
            if (!this.p.isAlive()) {
                this.publish("ABORTED");
                this.window.setVisible(false);
                this.window.dispose();
            }
            return null;
        }

        @Override
        protected void process(List<String> list) {
            for (String string : list) {
                this.window.printLine(string);
            }
        }

        public void abort() {
            if (this.p != null) {
                this.p.destroyForcibly();
            }
        }
    }
}

