/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.runtime;

import java.io.Closeable;
import java.io.File;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeConnection;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeProcess;
import se.prediktera.breeze.hardware.tcp.BreezeRuntime;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class DefaultBreezeRuntime
implements BreezeRuntime {
    private BreezeRuntimeConnection runtimeCommandConnection;
    private BreezeRuntimeConnection runtimeEventConnection;
    private BreezeRuntimeProcess process;
    private String eventServerHost = null;
    private Integer numberOfThreads = null;
    private File workspacePath = null;
    private Boolean useFileWatcher;
    private String sessionName;
    private UpdateHelper.UpdateVersion version;
    private String source;
    private File runtimePath;

    @Override
    public void send(BreezeProgress breezeProgress, Command command) {
        if (BufferedTcpStream.PrintDebug) {
            Logg.debug((String)"Sending Command: {}", (Object[])new Object[]{command.toJsonString()});
        }
        this.getRuntimeConnection(breezeProgress).send(command.toJsonString() + "\r\n");
    }

    @Override
    public String readCommandLine() throws BreezeRuntimeConnection.BreezeRuntimeDisconnectedException {
        if (this.runtimeCommandConnection != null) {
            try {
                return this.runtimeCommandConnection.readLine();
            }
            catch (BreezeRuntimeConnection.BreezeRuntimeDisconnectedException breezeRuntimeDisconnectedException) {
                this.runtimeCommandConnection = null;
                throw breezeRuntimeDisconnectedException;
            }
        }
        return null;
    }

    @Override
    public String readEventLine() throws BreezeRuntimeConnection.BreezeRuntimeDisconnectedException {
        if (this.runtimeEventConnection != null) {
            try {
                return this.runtimeEventConnection.readLine();
            }
            catch (BreezeRuntimeConnection.BreezeRuntimeDisconnectedException breezeRuntimeDisconnectedException) {
                this.runtimeEventConnection = null;
                throw breezeRuntimeDisconnectedException;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized BreezeRuntimeConnection getRuntimeConnection(BreezeProgress breezeProgress) {
        if (this.runtimeCommandConnection == null && BreezeProperties.getInstance().isBreezeRuntimeLocalHost() && !this.isAnyBreezeRuntimeRunning()) {
            this.startBreezeRuntime(BreezeProperties.getInstance().getBreezeRuntimeExeFile(), BreezeProperties.getInstance().getCommandPort(), BreezeProperties.getInstance().showTerminalWindow(), breezeProgress);
        }
        if (this.runtimeCommandConnection == null) {
            this.runtimeCommandConnection = this.createConnection(breezeProgress, BreezeProperties.getInstance().getCommandPort());
            Logg.debug((String)"Connected to BreezeRuntime Command port {}", (Object[])new Object[]{BreezeProperties.getInstance().getCommandPort()});
        }
        if (this.runtimeEventConnection == null) {
            this.runtimeEventConnection = this.createConnection(breezeProgress, BreezeProperties.getInstance().getEventPort());
            Logg.debug((String)"Connected to BreezeRuntime Event port {}", (Object[])new Object[]{BreezeProperties.getInstance().getEventPort()});
            TcpManager tcpManager = TcpManager.getInstance();
            try {
                this.version = new UpdateHelper.UpdateVersion(tcpManager.getProperty("Version", false));
                this.source = tcpManager.getProperty("Source", false);
                this.runtimePath = new File(tcpManager.getProperty("BreezeRuntimePath", false));
            }
            catch (Exception exception) {
                Logg.error((String)"Cannot get Breeze Runtime properties", (Throwable)exception);
            }
            finally {
                tcpManager.setProgressManager(breezeProgress);
            }
        }
        return this.runtimeCommandConnection;
    }

    @Override
    public void startRuntime(BreezeProgress breezeProgress) {
        this.getRuntimeConnection(breezeProgress);
    }

    public void startBreezeRuntime(File file, int n, boolean bl, BreezeProgress breezeProgress) {
        this.process = this.createOwnRuntimeProcess(file, n, bl, breezeProgress);
    }

    public BreezeRuntimeProcess createOwnRuntimeProcess(File file, int n, boolean bl, BreezeProgress breezeProgress) {
        UpdateHelper.Platform platform = UpdateHelper.getPlatform();
        return switch (platform) {
            default -> throw new MatchException(null, null);
            case UpdateHelper.Platform.Windows -> new BreezeRuntimeProcess.Windows(file, n, this.workspacePath, this.eventServerHost, this.numberOfThreads, this.useFileWatcher, this.sessionName, bl, breezeProgress);
            case UpdateHelper.Platform.Linux, UpdateHelper.Platform.LinuxArm, UpdateHelper.Platform.Unknown -> new BreezeRuntimeProcess.Linux(file, n, this.workspacePath, this.eventServerHost, this.numberOfThreads, this.useFileWatcher, this.sessionName, bl, breezeProgress);
            case UpdateHelper.Platform.MacOSX -> new BreezeRuntimeProcess.MacOSX(file, n, this.workspacePath, this.eventServerHost, this.numberOfThreads, this.useFileWatcher, this.sessionName, bl, breezeProgress);
        };
    }

    private BreezeRuntimeConnection createConnection(BreezeProgress breezeProgress, int n) {
        try {
            return new BreezeRuntimeConnection(breezeProgress, BreezeProperties.getInstance().getBreezeRuntimeConnectHost(), n);
        }
        catch (BreezeProgress.ProgressActionCancelledException progressActionCancelledException) {
            throw progressActionCancelledException;
        }
        catch (Exception exception) {
            if (BreezeProperties.getInstance().isBreezeRuntimeLocalHost()) {
                throw new RuntimeException(exception);
            }
            throw new ErrorHandler.MessageException("Cannot connect to the remote Breeze Runtime at " + BreezeProperties.getInstance().getBreezeRuntimeConnectHost() + ":" + n + ")\n\nMake sure that Breeze Runtime is started there, and that network firewalls do not block the connection.", (Throwable)exception);
        }
    }

    @Override
    public boolean isAnyBreezeRuntimeRunning() {
        return BreezeRuntimeProcess.isAnyBreezeRuntimeRunning();
    }

    @Override
    public void closeServer() {
        if (this.runtimeCommandConnection != null) {
            IOUtils.closeQuietly((Closeable)this.runtimeCommandConnection);
            this.runtimeCommandConnection = null;
        }
        if (this.runtimeEventConnection != null) {
            IOUtils.closeQuietly((Closeable)this.runtimeEventConnection);
            this.runtimeEventConnection = null;
        }
        if (this.process != null) {
            this.process.kill();
            this.process = null;
        }
    }

    public void forceCloseAny() {
        boolean bl = this.hasCreatedOwnBreezeRuntimeProcess();
        this.closeServer();
        if (!bl) {
            BreezeRuntimeProcess.forceKillAny();
        }
    }

    public boolean hasCreatedOwnBreezeRuntimeProcess() {
        return this.process != null;
    }

    @Override
    public UpdateHelper.UpdateVersion getVersion() {
        return this.version;
    }

    @Override
    public File getRuntimeBinaryFile() {
        return this.runtimePath;
    }

    @Generated
    public void setEventServerHost(String string) {
        this.eventServerHost = string;
    }

    @Generated
    public void setNumberOfThreads(Integer n) {
        this.numberOfThreads = n;
    }

    @Generated
    public void setWorkspacePath(File file) {
        this.workspacePath = file;
    }

    @Generated
    public void setUseFileWatcher(Boolean bl) {
        this.useFileWatcher = bl;
    }

    @Generated
    public void setSessionName(String string) {
        this.sessionName = string;
    }

    @Generated
    public String getSource() {
        return this.source;
    }
}

