/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import se.prediktera.map.common.error.Logg;

public class Busy {
    private final AtomicBoolean busy = new AtomicBoolean(false);
    private final ReentrantLock waitLock = new ReentrantLock();
    private final Condition notBusyCondition = this.waitLock.newCondition();
    private String lastActivity = null;

    public boolean isBusy() {
        return this.busy.get();
    }

    private boolean setBusy(String string) {
        this.waitLock.lock();
        try {
            if (!this.busy.compareAndSet(false, true)) {
                boolean bl = false;
                return bl;
            }
            this.lastActivity = string;
            boolean bl = true;
            return bl;
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public void setNotBusy() {
        this.waitLock.lock();
        try {
            this.busy.set(false);
            this.notBusyCondition.signalAll();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    private void waitReady(String string) {
        this.waitLock.lock();
        try {
            while (this.busy.get()) {
                try {
                    if (this.notBusyCondition.await(30L, TimeUnit.SECONDS)) continue;
                    throw new RuntimeException("Timeout waiting for last activity: " + this.lastActivity + ", current activity: " + string);
                }
                catch (InterruptedException interruptedException) {
                    Logg.debug((String)("Interrupted while waiting for device to be ready: " + interruptedException.getMessage() + " - " + string + " - " + this.lastActivity), (Object[])new Object[0]);
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            this.waitLock.unlock();
        }
    }

    public void doWhenReady(String string, Runnable runnable) {
        do {
            this.waitReady(string);
        } while (!this.setBusy(string));
        try {
            runnable.run();
        }
        finally {
            this.setNotBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doWhenReady(String string, Supplier<T> supplier) {
        do {
            this.waitReady(string);
        } while (!this.setBusy(string));
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.setNotBusy();
        }
    }
}

