/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover;

import java.awt.GridBagLayout;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.frontend.hardware.ComPortComboBox;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettingsPanel;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.map.common.error.ErrorHandler;

public class GenericSampleMover
extends RemoteSampleMover<GenericHttpSampleMoverSettings> {
    public GenericSampleMover() {
        super("GenericSampleMover");
    }

    @Override
    public String getXmlNodeName() {
        return "GenericSampleMover";
    }

    @Override
    public boolean hasWhiteRefState() {
        return false;
    }

    @Override
    public void moveToReturnPosition(Camera camera) {
        if (!this.isConveyor()) {
            super.moveToReturnPosition(camera);
        }
    }

    @Override
    public void enterWhiteRefState(Camera camera) {
        if (!this.isConveyor()) {
            super.enterWhiteRefState(camera);
        }
    }

    @Override
    public void enterFocusState(Camera camera) {
        if (!this.isConveyor()) {
            super.enterFocusState(camera);
        }
    }

    @Override
    public JPanel getSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        if (!this.isConnected()) {
            String string = ((GenericHttpSampleMoverSettings)this.settings).getMotorType();
            boolean bl2 = string.equals("http");
            boolean bl3 = string.equals("lucidControl");
            boolean bl4 = ((GenericHttpSampleMoverSettings)this.settings).getIsLucidControlDigitalOutput();
            BreezeInputField breezeInputField = new BreezeInputField("Host name / ip with port and path", ((GenericHttpSampleMoverSettings)this.settings).getHost(), " ", textActionEvent -> ((GenericHttpSampleMoverSettings)this.settings).setHost(textActionEvent.getText()), BreezeInputFieldHelper.Format.TwoRows);
            breezeInputField.setVisible(bl2);
            ComPortComboBox comPortComboBox = new ComPortComboBox("COM port", ((GenericHttpSampleMoverSettings)this.settings).getComPort(), false, ((GenericHttpSampleMoverSettings)this.settings)::setComPort);
            comPortComboBox.setVisible(bl3);
            ChannelComboBox channelComboBox = new ChannelComboBox("Start / Stop channel", ((GenericHttpSampleMoverSettings)this.settings).getChannelStartStop(), optionType -> ((GenericHttpSampleMoverSettings)this.settings).setChannelStartStop(optionType.Value));
            channelComboBox.setVisible(bl3);
            BreezeInputField breezeInputField2 = new BreezeInputField("Set start value", ((GenericHttpSampleMoverSettings)this.settings).getStartValue(), "mA / V", textActionEvent -> ((GenericHttpSampleMoverSettings)this.settings).setStartValue(textActionEvent.getText()), BreezeInputFieldHelper.Format.TwoRows);
            breezeInputField2.setUsage("Unit depends on type of LucidControl device, as well as acceptable value range");
            breezeInputField2.reFormat();
            breezeInputField2.setVisible(bl3 && !bl4);
            BreezeInputField breezeInputField3 = new BreezeInputField("Set stop value", ((GenericHttpSampleMoverSettings)this.settings).getStopValue(), "mA / V", textActionEvent -> ((GenericHttpSampleMoverSettings)this.settings).setStopValue(textActionEvent.getText()), BreezeInputFieldHelper.Format.TwoRows);
            breezeInputField3.setUsage("Unit depends on type of LucidControl device, as well as acceptable value range");
            breezeInputField3.reFormat();
            breezeInputField3.setVisible(bl3 && !bl4);
            BreezeCheckBox breezeCheckBox = new BreezeCheckBox("Is digital output", bl4, bl -> {
                breezeInputField2.setVisible(!bl);
                breezeInputField3.setVisible(!bl);
                ((GenericHttpSampleMoverSettings)this.settings).setIsLucidControlDigitalOutput(bl);
                settingsPanelCallback.reloadInformation();
            });
            breezeCheckBox.setVisible(bl3);
            SampleMoverTypeInputField sampleMoverTypeInputField = new SampleMoverTypeInputField(((GenericHttpSampleMoverSettings)this.settings).getSampleMoverType(), ((GenericHttpSampleMoverSettings)this.settings)::setSampleMoverType);
            sampleMoverTypeInputField.setVisible(bl2);
            InputFieldHelper.addPanel(jPanel, new MotorTypeInputField(string, optionType -> {
                ((GenericHttpSampleMoverSettings)this.settings).setMotorType(optionType.Value);
                boolean bl = optionType.Value.equals("http");
                breezeInputField.setVisible(bl);
                comPortComboBox.setVisible(!bl);
                channelComboBox.setVisible(!bl);
                breezeInputField2.setVisible(!bl && !((GenericHttpSampleMoverSettings)this.settings).getIsLucidControlDigitalOutput());
                breezeInputField3.setVisible(!bl && !((GenericHttpSampleMoverSettings)this.settings).getIsLucidControlDigitalOutput());
                breezeCheckBox.setVisible(!bl);
                sampleMoverTypeInputField.setVisible(bl);
                if (!bl) {
                    sampleMoverTypeInputField.setSelectedItemAndTrigger("Conveyor");
                }
                settingsPanelCallback.reloadInformation();
            }));
            InputFieldHelper.addPanel(jPanel, breezeInputField);
            InputFieldHelper.addPanel(jPanel, comPortComboBox);
            InputFieldHelper.addPanel(jPanel, channelComboBox);
            InputFieldHelper.addPanel(jPanel, breezeCheckBox);
            InputFieldHelper.addPanel(jPanel, breezeInputField2);
            InputFieldHelper.addPanel(jPanel, breezeInputField3);
            InputFieldHelper.addPanel(jPanel, sampleMoverTypeInputField);
        }
        InputFieldHelper.addBottomFillPanel(jPanel);
        InputFieldHelper.addPanel(jPanel, RemoteSampleMoverSettingsPanel.createAdvancedPanel(this, settingsPanelCallback, true));
        return jPanel;
    }

    @Override
    protected GenericHttpSampleMoverSettings createSettings() {
        return new GenericHttpSampleMoverSettings(this);
    }

    public String toString() {
        return "Generic Sample Mover";
    }

    @Override
    public String getDisplayName() {
        return "Generic Sample Mover: " + MotorTypeInputField.getDisplayName(((GenericHttpSampleMoverSettings)this.settings).getMotorType());
    }

    @Override
    public boolean isConveyor() {
        return ((GenericHttpSampleMoverSettings)this.settings).isConveyor();
    }

    @Override
    public ComPort getComPort() {
        return null;
    }

    public String getSampleMoverType() {
        return ((GenericHttpSampleMoverSettings)this.settings).getSampleMoverType();
    }

    @Override
    public void addAddtionalInformation(InformationPanel.InformationList informationList) {
        super.addAddtionalInformation(informationList);
        informationList.add("Communication", MotorTypeInputField.getDisplayName(((GenericHttpSampleMoverSettings)this.settings).getMotorType()));
        if (((GenericHttpSampleMoverSettings)this.settings).getMotorType().equals("http")) {
            informationList.add("Host", ((GenericHttpSampleMoverSettings)this.settings).getHost());
        } else {
            informationList.add("COM Port", ((GenericHttpSampleMoverSettings)this.settings).getComPort().name);
            informationList.add("Start / Stop channel", ChannelComboBox.getDisplayName(((GenericHttpSampleMoverSettings)this.settings).getChannelStartStop()));
            if (((GenericHttpSampleMoverSettings)this.settings).getIsLucidControlDigitalOutput()) {
                informationList.add("Is digital output", "true");
            } else {
                informationList.add("Is digital output", "false");
                informationList.add("Start value", ((GenericHttpSampleMoverSettings)this.settings).getStartValue() + " mA / V");
                informationList.add("Stop value", ((GenericHttpSampleMoverSettings)this.settings).getStopValue() + " mA / V");
            }
        }
        informationList.add("Type of mover", ((GenericHttpSampleMoverSettings)this.settings).getSampleMoverType());
    }

    @Override
    public void runContinuously(Speed speed) {
        this.remoteMotor.runContinuously(speed);
    }

    public static class GenericHttpSampleMoverSettings
    extends RemoteSampleMoverSettings {
        public GenericHttpSampleMoverSettings(GenericSampleMover genericSampleMover) {
            super(genericSampleMover);
        }

        @Override
        public float scanStartLocation() {
            if (this.isConveyor()) {
                return 0.0f;
            }
            return super.scanStartLocation();
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("Host", (Object)this.getHost()));
            list.add(new Command.Argument("comPort", (Object)this.getComPort().name));
            list.add(new Command.Argument("channelStartStop", (Object)this.getChannelStartStop()));
            list.add(new Command.Argument("startValue", (Object)this.getStartValue()));
            list.add(new Command.Argument("stopValue", (Object)this.getStopValue()));
            list.add(new Command.Argument("isDigital", (Object)this.getIsLucidControlDigitalOutput()));
            list.add(new Command.Argument("Host", (Object)this.getHost()));
            list.add(new Command.Argument("MotorInterfaceType", (Object)this.getMotorType()));
            return list;
        }

        public boolean isConveyor() {
            return this.getSampleMoverType().equals("Conveyor");
        }

        public void setHost(String string) {
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ErrorHandler.MessageException("Host format incorrect", (Throwable)uRISyntaxException);
            }
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "host", string);
        }

        public String getHost() {
            return BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "host", "https://127.0.0.1:5500/command");
        }

        public void setSampleMoverType(String string) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "moverType", string);
        }

        public String getSampleMoverType() {
            return BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "moverType", "Tray");
        }

        public void setMotorType(String string) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "motorType", string);
        }

        public String getMotorType() {
            return BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "motorType", "http");
        }

        public void setStopValue(String string) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "stopValue", string);
        }

        public String getStopValue() {
            return BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "stopValue", "0");
        }

        public void setStartValue(String string) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "startValue", string);
        }

        public String getStartValue() {
            return BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "startValue", "20");
        }

        public void setChannelStartStop(String string) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "channelStartStop", string);
        }

        public String getChannelStartStop() {
            return BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "channelStartStop", "0");
        }

        public void setComPort(ComPort comPort) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "comPort", comPort.name);
        }

        public ComPort getComPort() {
            return ComPort.fromXmlValue(BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "comPort", "COM2"));
        }

        public boolean getIsLucidControlDigitalOutput() {
            return BreezeProperties.getInstance().getSampleMoverPropertyBool(this.mover, "isDi", false);
        }

        public void setIsLucidControlDigitalOutput(boolean bl) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "isDi", Boolean.toString(bl));
        }
    }

    private static class ChannelComboBox
    extends BreezeComboBoxInputField<OptionType> {
        private static final List<OptionType> values = Arrays.asList(new OptionType("Channel 1", "0"), new OptionType("Channel 2", "1"), new OptionType("Channel 3", "2"), new OptionType("Channel 4", "3"));

        public ChannelComboBox(String string, String string2, BreezeComboBoxInputField.SelectionChangedListener<OptionType> selectionChangedListener) {
            super(string, values, values.stream().filter(optionType -> optionType.Value.equals(string2)).findFirst().get(), selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
        }

        public static String getDisplayName(String string) {
            return ChannelComboBox.values.stream().filter((Predicate<OptionType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(java.lang.String se.prediktera.breeze.hardware.samplemover.GenericSampleMover$OptionType ), (Lse/prediktera/breeze/hardware/samplemover/GenericSampleMover$OptionType;)Z)((String)string)).findFirst().get().DisplayName;
        }
    }

    private static class SampleMoverTypeInputField
    extends BreezeComboBoxInputField<String> {
        public SampleMoverTypeInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<String> selectionChangedListener) {
            super("Type of mover", Arrays.asList("Tray", "Conveyor"), string, selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
        }
    }

    private static class MotorTypeInputField
    extends BreezeComboBoxInputField<OptionType> {
        private static final List<OptionType> values = Arrays.asList(new OptionType("HTTP", "http"), new OptionType("LucidControl", "lucidControl"));

        public MotorTypeInputField(String string, BreezeComboBoxInputField.SelectionChangedListener<OptionType> selectionChangedListener) {
            super("Type of communication", values, values.stream().filter(optionType -> optionType.Value.equals(string)).findFirst().get(), selectionChangedListener);
            this.setFormat(BreezeInputFieldHelper.Format.TwoRows);
            this.setUnit(" ");
        }

        public static String getDisplayName(String string) {
            return MotorTypeInputField.values.stream().filter((Predicate<OptionType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(java.lang.String se.prediktera.breeze.hardware.samplemover.GenericSampleMover$OptionType ), (Lse/prediktera/breeze/hardware/samplemover/GenericSampleMover$OptionType;)Z)((String)string)).findFirst().get().DisplayName;
        }
    }

    private record OptionType(String DisplayName, String Value) {
        @Override
        public String toString() {
            return this.DisplayName;
        }
    }
}

