/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.samplemover.Busy;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.CommandReply;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.Logg;

public class RemoteMotor {
    private final String description;
    private final String breezeRuntimeClassName;
    private final Busy busy = new Busy();
    private boolean demoRunning;
    private final Time defaultTimeout = new Time.Minutes(1.0);
    private boolean connected;

    public RemoteMotor(String string) {
        this(string, StringHelper.formatLabel(string));
    }

    public RemoteMotor(String string, String string2) {
        this.breezeRuntimeClassName = string;
        this.description = string2;
    }

    public void connect(BreezeProgress breezeProgress, ComPort comPort, TcpManager.OnDisconnectCallback onDisconnectCallback) {
        this.connect(breezeProgress, comPort, onDisconnectCallback, new ArrayList<Command.Argument>());
    }

    public void connect(BreezeProgress breezeProgress, ComPort comPort, TcpManager.OnDisconnectCallback onDisconnectCallback, List<Command.Argument> list) {
        TcpManager.getInstance().initializeMotor(breezeProgress, this, this.breezeRuntimeClassName, comPort, onDisconnectCallback, list);
        this.connected = true;
    }

    public void disconnect() {
        TcpManager.getInstance().disconnect(this);
        this.connected = false;
    }

    public boolean isBusy() {
        return this.busy.isBusy();
    }

    public void move(Speed speed, double d, MotorDirection motorDirection, MotorDriveMode motorDriveMode) {
        this.move(speed, d, motorDirection, motorDriveMode, this.defaultTimeout);
    }

    public void move(Speed speed, double d, MotorDirection motorDirection, MotorDriveMode motorDriveMode, Time time) {
        this.busy.doWhenReady("move " + d, () -> TcpManager.getInstance().move(this, speed, d, motorDirection, motorDriveMode, time));
    }

    public Map<String, String> remoteScan(BreezeProgress breezeProgress, Camera camera, SampleMover.ScanMode scanMode, Speed speed, Speed speed2, Speed speed3, LengthValue lengthValue, LengthValue lengthValue2, List<FrameCount> list, boolean bl, Time time) {
        String string;
        if (scanMode.equals((Object)SampleMover.ScanMode.DemoByLength)) {
            this.demoRunning = true;
        }
        if (StringUtils.isBlank((CharSequence)(string = this.busy.doWhenReady("scan " + String.valueOf(lengthValue) + " - " + String.valueOf(lengthValue2), () -> {
            CommandReply commandReply = TcpManager.getInstance().scan(breezeProgress, camera, this, scanMode, speed, speed2, speed3, lengthValue, lengthValue2, list, bl, time);
            return commandReply.getMessage();
        })))) {
            return new HashMap<String, String>();
        }
        try {
            JSONObject jSONObject = new JSONObject(string.replace("\\", "\\\\"));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator iterator = jSONObject.keySet().iterator();
            while (iterator.hasNext()) {
                String string2;
                Object object = jSONObject.get(string2 = (String)iterator.next());
                hashMap.put(string2, object != null ? object.toString() : null);
            }
            return hashMap;
        }
        catch (Exception exception) {
            Logg.warn((String)("Failed to parse JSON message: " + exception.getMessage()), (Object[])new Object[0]);
            return new HashMap<String, String>();
        }
    }

    public void stopMotor() {
        this.stopMotorLocally();
        this.demoRunning = false;
    }

    public void stopDemo() {
        if (this.demoRunning) {
            this.stopMotor();
        }
    }

    public void runContinuously(Speed speed) {
        this.move(speed, 0.0, MotorDirection.Forward, MotorDriveMode.Continuous);
    }

    private void stopMotorLocally() {
        TcpManager.getInstance().stop(this);
        this.busy.setNotBusy();
        ThreadUtil.sleep(200L);
    }

    public void runScan(Speed speed, float f, LengthValue lengthValue, Speed speed2, Speed speed3, SampleMover.ScanEventListener scanEventListener) {
        this.move(speed2, f, MotorDirection.Forward, MotorDriveMode.Absolute);
        this.stopMotorLocally();
        Speed speed4 = new Speed(Math.min(speed3.value, speed.value));
        Time time = Time.max(new Time.Minutes(1.0), lengthValue.timeToTravel(speed4).multiplied(5.0));
        Thread thread = new Thread(() -> this.move(speed4, f + lengthValue.value, MotorDirection.Forward, MotorDriveMode.Absolute, time));
        scanEventListener.onScanStarted();
        thread.start();
        if (this.useAccelerationTimeSleep()) {
            int n = (int)Math.min(500.0f, 30.0f * speed4.value);
            ThreadUtil.sleep(n);
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        this.stopMotorLocally();
        scanEventListener.onScanFinished();
    }

    protected boolean useAccelerationTimeSleep() {
        return false;
    }

    public void runDemo(Speed speed, float f, LengthValue lengthValue, Speed speed2, Speed speed3, SampleMover.ScanEventListener scanEventListener, Camera camera) {
        this.move(speed2, f, MotorDirection.Forward, MotorDriveMode.Absolute);
        this.stopMotorLocally();
        this.demoRunning = true;
        scanEventListener.onScanStarted();
        Speed speed4 = new Speed(Math.min(speed3.value, speed.value));
        boolean bl = true;
        while (this.demoRunning) {
            this.move(speed4, bl ? (double)(f + lengthValue.value) : (double)f, MotorDirection.Forward, MotorDriveMode.Absolute, Time.Forever);
            bl = !bl;
            this.stopMotorLocally();
            scanEventListener.onScanDemo();
        }
        scanEventListener.onScanFinished();
    }

    public String toString() {
        return this.description;
    }

    public boolean withinPositon(float f) {
        if (this.connected) {
            return Math.abs(this.getPosition() - f) < 1.0f;
        }
        return false;
    }

    public float getPosition() {
        if (this.connected) {
            return this.getMotorPropertyFloat("Position", false);
        }
        return 0.0f;
    }

    public boolean isRunning() {
        if (this.connected) {
            return this.getMotorPropertyBool("IsRunning", false);
        }
        return false;
    }

    public void setMotorProperty(String string, String string2) {
        TcpManager.getInstance().setMotorProperty(this, string, string2);
    }

    public String getMotorProperty(String string, boolean bl) {
        return TcpManager.getInstance().getMotorProperty(this, string, bl);
    }

    public float getMotorPropertyFloat(String string, boolean bl) {
        return RtDataFormat.toNumberFloat(this.getMotorProperty(string, bl));
    }

    public double getMotorPropertyDouble(String string, boolean bl) {
        return RtDataFormat.toNumber(this.getMotorProperty(string, bl));
    }

    public boolean getMotorPropertyBool(String string, boolean bl) {
        return Boolean.parseBoolean(this.getMotorProperty(string, bl));
    }

    @Generated
    public boolean isConnected() {
        return this.connected;
    }

    public static enum MotorDirection {
        NotSet,
        Forward,
        Reverse,
        Up,
        Down;

    }

    public static enum MotorDriveMode {
        Relative,
        Absolute,
        Homing,
        Continuous;

    }
}

