/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.awt.GridBagLayout;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.IFramesToAverage;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.raw.RtReferenceTarget;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.CalibratedReflectanceTargetList;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraMode;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.RemoteCameraTypeSettings;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettingsPanel;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class CameraIndexSampleMover
extends RemoteCamera<CameraIndexSampleMoverSettings>
implements StateCamera,
IFramesToAverage,
Camera.WhiteReferenceIntensity,
Camera.ICameraMode {
    private int imageWidth = 320;
    private int imageHeight = 1;
    private int warmUpDelay;
    private int preCaptureDelay;
    private int maxSignal = 1000;
    private boolean dataRange;
    private String wavelengthRange;
    private String mode;
    private String referenceMode;
    private String motorType = "Tray";
    private String cameraType = "FileReader";
    private File rawFile;
    private File darRefFile;
    private int offset;
    private boolean hasShutter = true;
    private boolean hasWhiteReference = true;
    private File whiteRefIntensityFile;
    private int framesToAverage = 1;
    private int initiateAvailableDevicesTime;
    private int initiateModesTime;
    private FrameRate maxFrameRate = new FrameRate(2.1474836E9f);
    private int readoutTime;
    private boolean binaryHeader;
    private boolean takeDarkAfterMeasurement;

    public CameraIndexSampleMover(int n) {
        this.setId(n);
    }

    public String toString() {
        return "Prediktera Simulator Camera";
    }

    @Override
    public String getXmlNodeName() {
        return "cameraIndexSampleMover";
    }

    @Override
    public JComponent getCameraSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame, settingsPanelCallback);
    }

    @Override
    public String getDeviceName() {
        return "CameraIndexSampleMover";
    }

    public void setCameraType(String string) {
        this.cameraType = string;
    }

    public void setHasShutter(boolean bl) {
        this.hasShutter = bl;
    }

    @Override
    public boolean hasShutter() {
        return this.hasShutter;
    }

    public void setHasWhiteReference(boolean bl) {
        this.hasWhiteReference = bl;
    }

    @Override
    public boolean hasWhiteReference() {
        return this.hasWhiteReference;
    }

    public void setImageWidth(int n) {
        this.imageWidth = n;
    }

    public void setImageHeight(int n) {
        this.imageHeight = n;
    }

    public void setWarmUpDelay(int n) {
        this.warmUpDelay = n;
    }

    public void setPreCaptureDelay(int n) {
        this.preCaptureDelay = n;
    }

    public void setMaxSignal(int n) {
        this.maxSignal = n;
    }

    public void setWavelengthRange(String string) {
        this.wavelengthRange = string;
    }

    public void setDataRange(boolean bl) {
        this.dataRange = bl;
    }

    public void setMode(String string) {
        this.mode = string;
    }

    public void setReferenceMode(String string) {
        this.referenceMode = string;
    }

    public void setMotorType(String string) {
        this.motorType = string;
    }

    public void setRawFile(File file) {
        this.rawFile = file;
    }

    public void setDarkRefFile(File file) {
        this.darRefFile = file;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public void setMaxFrameRate(FrameRate frameRate) {
        this.maxFrameRate = frameRate;
    }

    public void setReadoutTime(int n) {
        this.readoutTime = n;
    }

    public void setBinaryHeader(boolean bl) {
        this.binaryHeader = bl;
    }

    public void setTakeDarkAfterMeasurement(boolean bl) {
        this.takeDarkAfterMeasurement = bl;
    }

    @Override
    public boolean takeDarkAfterMeasurement() {
        return this.takeDarkAfterMeasurement;
    }

    @Override
    public void setWhiteReferenceTargetFile(File file) {
        this.whiteRefIntensityFile = file;
        BreezeProperties.getInstance().increaseSaveIndex();
        if (this.isConnected()) {
            TcpManager.getInstance().setCameraProperty((Camera)this, "ReferenceTargetFile", FileHelper.getAbsolutePathOrEmpty(file));
        }
    }

    @Override
    public RtReferenceTarget getReferenceTarget() {
        if (this.whiteRefIntensityFile != null) {
            return CalibratedReflectanceTargetList.fromTargetFile(this.whiteRefIntensityFile).getReferenceTarget(this.getBandNames());
        }
        return null;
    }

    @Override
    public File getWhiteReferenceTargetFile() {
        return this.whiteRefIntensityFile;
    }

    @Override
    public int getFramesToAverage() {
        return this.framesToAverage;
    }

    @Override
    public void setFramesToAverage(int n) {
        this.framesToAverage = n;
    }

    public void setInitiateAvailableDevicesTime(int n) {
        this.initiateAvailableDevicesTime = n;
    }

    public void setInitiateModesTime(int n) {
        this.initiateModesTime = n;
    }

    @Override
    public CameraMode getCameraMode() {
        return ((CameraIndexSampleMoverSettings)this.settings).getCameraMode();
    }

    @Override
    public void setFieldOfView(FieldOfView fieldOfView) {
        super.setFieldOfView(fieldOfView);
        ((CameraIndexSampleMoverSettings)this.settings).setFieldOfView(fieldOfView);
    }

    @Override
    public FieldOfView getFieldOfView() {
        FieldOfView fieldOfView;
        if (!this.canChangeView() && (fieldOfView = ((CameraIndexSampleMoverSettings)this.settings).getFieldOfView()) != null) {
            return fieldOfView;
        }
        return super.getFieldOfView();
    }

    public void setCanChangeView(boolean bl) {
        ((CameraIndexSampleMoverSettings)this.settings).setChangeView(bl);
    }

    @Override
    public boolean canChangeView() {
        return ((CameraIndexSampleMoverSettings)this.settings).canChangeView();
    }

    @Override
    public void add(InformationPanel.InformationList informationList) {
        super.add(informationList);
        informationList.add("Serial no", ((CameraIndexSampleMoverSettings)this.settings).getSerialNo());
        informationList.add("Mode", ((CameraIndexSampleMoverSettings)this.settings).getCameraMode().getName());
        informationList.add("Temperature", this.getTemperature().toString());
        if (this.whiteRefIntensityFile != null) {
            informationList.add("Calibrated reflectance target", this.whiteRefIntensityFile.getAbsolutePath());
        }
        informationList.add("Readout time", this.getReadoutTime() + " \u03bcs");
    }

    @Override
    protected CameraIndexSampleMoverSettings createSettings() {
        return new CameraIndexSampleMoverSettings(this);
    }

    @Override
    public CameraMode.CameraModeInputField createCameraModeField(Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new CameraMode.CameraModeInputField("Mode", "modes", settingsPanelCallback, (CameraMode.CameraModeSettings)((Object)this.settings));
    }

    private class SettingsPanel
    extends JPanel {
        public SettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            this.setLayout(new GridBagLayout());
            CameraMode.CameraModeInputField cameraModeInputField = CameraIndexSampleMover.this.createCameraModeField(settingsPanelCallback);
            if (!CameraIndexSampleMover.this.isConnected()) {
                CameraType.CameraTypeInputField cameraTypeInputField = new CameraType.CameraTypeInputField(settingsPanelCallback, CameraIndexSampleMover.this.settings, cameraType -> {
                    ((CameraIndexSampleMoverSettings)CameraIndexSampleMover.this.settings).clearCameraModeList();
                    cameraModeInputField.reload();
                });
                InputFieldHelper.addPanel(this, cameraTypeInputField);
            }
            InputFieldHelper.addPanel(this, cameraModeInputField);
            InputFieldHelper.addPanel(this, new BreezeCheckBoxInputField("Allow editing Field of view of connected camera", ((CameraIndexSampleMoverSettings)CameraIndexSampleMover.this.settings).canChangeView(), ((CameraIndexSampleMoverSettings)CameraIndexSampleMover.this.settings)::setChangeView));
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }
    }

    public class CameraIndexSampleMoverSettings
    extends RemoteCameraTypeSettings
    implements CameraMode.CameraModeSettings {
        private CameraMode.CameraModeList cameraModeList;
        private FieldOfView fow;

        public CameraIndexSampleMoverSettings(CameraIndexSampleMover cameraIndexSampleMover2) {
            super(cameraIndexSampleMover2);
        }

        public boolean canChangeView() {
            return BreezeProperties.getInstance().getCameraPropertyBool(this.camera, "editFow", false);
        }

        public void setChangeView(boolean bl) {
            BreezeProperties.getInstance().setCameraProperty(this.camera, "editFow", String.valueOf(bl));
        }

        public void setFieldOfView(FieldOfView fieldOfView) {
            this.fow = fieldOfView;
        }

        public FieldOfView getFieldOfView() {
            if (this.fow == null && this.camera.isConnected()) {
                String string = TcpManager.getInstance().getCameraProperty(this.camera, "FieldOfView");
                this.fow = new FieldOfView(RtDataFormat.toNumberFloat(string));
            }
            return this.fow;
        }

        @Override
        protected List<Command.Argument> getListCameraNamesArguments() {
            return this.getArguments();
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("ImageHeight", (Object)CameraIndexSampleMover.this.imageHeight));
            list.add(new Command.Argument("ImageWidth", (Object)CameraIndexSampleMover.this.imageWidth));
            list.add(new Command.Argument("WarmUpDelay", (Object)CameraIndexSampleMover.this.warmUpDelay));
            list.add(new Command.Argument("PreCaptureDelay", (Object)CameraIndexSampleMover.this.preCaptureDelay));
            list.add(new Command.Argument("MaxSignal", (Object)CameraIndexSampleMover.this.maxSignal));
            list.add(new Command.Argument("CameraType", (Object)CameraIndexSampleMover.this.cameraType));
            list.add(new Command.Argument("Offset", (Object)CameraIndexSampleMover.this.offset));
            list.add(new Command.Argument("MaxFrameRate", (Object)Float.valueOf(CameraIndexSampleMover.this.maxFrameRate.value)));
            list.add(new Command.Argument("ReadoutTime", (Object)CameraIndexSampleMover.this.readoutTime));
            if (this.fow != null) {
                list.add(new Command.Argument("FieldOfView", (Object)Float.valueOf(this.fow.value)));
            }
            if (CameraIndexSampleMover.this.rawFile != null) {
                list.add(new Command.Argument("RawFile", (Object)CameraIndexSampleMover.this.rawFile.getAbsolutePath()));
            }
            if (CameraIndexSampleMover.this.darRefFile != null) {
                list.add(new Command.Argument("DarkRawFile", (Object)CameraIndexSampleMover.this.darRefFile.getAbsolutePath()));
            }
            if (CameraIndexSampleMover.this.wavelengthRange != null) {
                list.add(new Command.Argument("WavelengthRange", (Object)CameraIndexSampleMover.this.wavelengthRange));
            }
            list.add(new Command.Argument("DataRange", (Object)CameraIndexSampleMover.this.dataRange));
            if (CameraIndexSampleMover.this.mode != null) {
                list.add(new Command.Argument("Mode", (Object)CameraIndexSampleMover.this.mode));
            }
            if (CameraIndexSampleMover.this.referenceMode != null) {
                list.add(new Command.Argument("ReferenceMode", (Object)CameraIndexSampleMover.this.referenceMode));
            }
            list.add(new Command.Argument("MotorType", (Object)CameraIndexSampleMover.this.motorType));
            if (CameraIndexSampleMover.this.whiteRefIntensityFile != null) {
                list.add(new Command.Argument("ReferenceTargetFile", CameraIndexSampleMover.this.whiteRefIntensityFile.getAbsoluteFile()));
            }
            list.add(new Command.Argument("InitiateAvailableDevicesTime", (Object)CameraIndexSampleMover.this.initiateAvailableDevicesTime));
            list.add(new Command.Argument("InitiateModesTime", (Object)CameraIndexSampleMover.this.initiateModesTime));
            list.add(new Command.Argument("FramesToAverage", (Object)CameraIndexSampleMover.this.framesToAverage));
            list.add(new Command.Argument("BinaryHeader", (Object)CameraIndexSampleMover.this.binaryHeader));
            return list;
        }

        @Override
        public CameraType getCameraType() {
            return new CameraType(CameraIndexSampleMover.this.cameraType);
        }

        @Override
        public CameraMode.CameraModeList listCameraModes() {
            if (this.cameraModeList == null) {
                this.cameraModeList = TcpManager.getInstance().getCameraModes(this.camera, this.getCameraType(), this.getListCameraNamesArguments());
            }
            return this.cameraModeList;
        }

        @Override
        public void clearCameraModeList() {
            this.cameraModeList = null;
        }

        @Override
        public void changeCameraMode(CameraMode cameraMode) {
            if (this.isConnected()) {
                TcpManager.getInstance().setCameraProperty((Camera)this.camera, "Mode", cameraMode.getId());
                this.fow = null;
            }
            BreezeProperties.getInstance().setCameraMode(this.camera, this.getCameraType(), cameraMode);
        }

        @Override
        public CameraMode getCameraMode() {
            return CameraMode.getCameraMode(this.camera, this);
        }

        @Override
        public void clear() {
            super.clear();
            this.fow = null;
        }
    }

    public static class CameraIndexSampleMoverDriver
    extends RemoteSampleMover {
        private LengthValue minLength = new LengthValue(0.0f);
        private LengthValue maxLength = new LengthValue(1000.0f);
        private Speed maxSpeed = new Speed(500.0f);
        private String type = "translation";

        public CameraIndexSampleMoverDriver() {
            super("CameraIndexSampleMover");
        }

        protected RemoteSampleMoverSettings createSettings() {
            return new RemoteSampleMoverSettings(this){

                @Override
                public List<Command.Argument> getArguments() {
                    List<Command.Argument> list = super.getArguments();
                    list.add(new Command.Argument("MaxSpeedMm", (Object)Float.valueOf(maxSpeed.value)));
                    list.add(new Command.Argument("MinLength", (Object)Float.valueOf(minLength.value)));
                    list.add(new Command.Argument("MaxLength", (Object)Float.valueOf(maxLength.value)));
                    list.add(new Command.Argument("Type", (Object)type));
                    return list;
                }
            };
        }

        public String toString() {
            return "Prediktera Simulator Tray";
        }

        @Override
        public String getXmlNodeName() {
            return "cameraIndexSampleMover";
        }

        @Override
        public JPanel getSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
            RemoteSampleMoverSettingsPanel remoteSampleMoverSettingsPanel = new RemoteSampleMoverSettingsPanel(this, settingsPanelCallback, false);
            return remoteSampleMoverSettingsPanel;
        }

        public void setMinLength(LengthValue lengthValue) {
            this.minLength = lengthValue;
        }

        public void setMaxLength(LengthValue lengthValue) {
            this.maxLength = lengthValue;
            ((RemoteSampleMoverSettings)this.getSettings()).changeMaxLength(lengthValue.value);
        }

        public void setMaxSpeed(Speed speed) {
            this.maxSpeed = speed;
        }

        public void setType(String string) {
            this.type = string;
        }
    }
}

