/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeMultiSelectInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.camera.HySpexTelopCamera;
import se.prediktera.breeze.hardware.camera.IDSCamera;
import se.prediktera.breeze.hardware.camera.SonyCamera;
import se.prediktera.breeze.hardware.camera.rgb.RgbUsbCamera;
import se.prediktera.breeze.hardware.samplemover.tray.HySpexStepperTable;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.tcp.Command;

public class HySpexCoreScannerTable
extends HySpexStepperTable<HySpexCoreScannerTableSettings> {
    private static final List<String> AvailableSensors = List.of("Sony", "LWIR", "MWIR", "VNIR", "SWIR", "Profile");
    private final BreezeInfoPanel sensorInfoPanel = new BreezeInfoPanel();

    public HySpexCoreScannerTable() {
        super("HySpexCoreScannerTableMotor");
    }

    @Override
    public String toString() {
        return "HySpex Core Scanner";
    }

    @Override
    public String getXmlNodeName() {
        return "HySpexCoreStepperTable";
    }

    @Override
    public void moveToReturnPosition(Camera camera) {
    }

    @Override
    public void moveToScanStartPosition(Camera camera) {
    }

    @Override
    public void runScan(LengthValue lengthValue, SampleMover.ScanMode scanMode, SampleMover.ScanEventListener scanEventListener, Camera camera) {
    }

    @Override
    public Map<String, String> remoteScan(LengthValue lengthValue, SampleMover.ScanMode scanMode, List<Camera> list, List<FrameCount> list2, boolean bl, boolean bl2) {
        return super.remoteScan(lengthValue, scanMode, list, list2, bl, bl2);
    }

    @Override
    public void addAddtionalInformation(InformationPanel.InformationList informationList) {
        super.addAddtionalInformation(informationList);
        informationList.add("Sony RGB location", ((HySpexCoreScannerTableSettings)this.getSettings()).getRgbLocation());
        informationList.add("Sony RGB segment length", ((HySpexCoreScannerTableSettings)this.getSettings()).getRgbScanLength());
        informationList.add("MWIR location", ((HySpexCoreScannerTableSettings)this.getSettings()).getMwirLocation());
        informationList.add("MWIR segment length", ((HySpexCoreScannerTableSettings)this.getSettings()).getMwirLocation());
        informationList.add("LWIR location", ((HySpexCoreScannerTableSettings)this.getSettings()).getLwirLocation());
        informationList.add("LWIR segment length", ((HySpexCoreScannerTableSettings)this.getSettings()).getLwirScanLength());
        informationList.add("VNIR/SWIR Start position", ((HySpexCoreScannerTableSettings)this.getSettings()).getPushBroomCamerasLocation());
        informationList.add("Active devices", String.join((CharSequence)", ", ((HySpexCoreScannerTableSettings)this.getSettings()).getActiveSensors()));
        informationList.add("Homing disabled", ((HySpexCoreScannerTableSettings)this.getSettings()).isHomingDisabled() ? "Yes" : "No");
    }

    @Override
    protected HySpexCoreScannerTableSettings createSettings() {
        return new HySpexCoreScannerTableSettings(this);
    }

    @Override
    protected void addAdditionalComponents(JPanel jPanel) {
        this.updateSensorInfoPanel();
        if (this.isConnected()) {
            InputFieldHelper.addPanel(jPanel, this.sensorInfoPanel);
            return;
        }
        InputFieldHelper.addPanel(jPanel, new BreezeSpinnerInputPanel("Sony RGB camera location", "", 0.0f, 9999.0f, 1.0f, ((HySpexCoreScannerTableSettings)this.getSettings()).getRgbLocation(), "mm", d -> ((HySpexCoreScannerTableSettings)this.getSettings()).setRgbLocation((double)d)));
        InputFieldHelper.addPanel(jPanel, new BreezeSpinnerInputPanel("Sony RGB snapshot segment length", "The distance to move for each snapshot segment", 0.0f, 9999.0f, 1.0f, ((HySpexCoreScannerTableSettings)this.getSettings()).getRgbScanLength(), "mm", d -> ((HySpexCoreScannerTableSettings)this.getSettings()).setRgbScanLength((double)d)));
        InputFieldHelper.addPanel(jPanel, new BreezeSpinnerInputPanel("MWIR camera location", "", 0.0f, 9999.0f, 1.0f, ((HySpexCoreScannerTableSettings)this.getSettings()).getMwirLocation(), "mm", d -> ((HySpexCoreScannerTableSettings)this.getSettings()).setMwirLocation((double)d)));
        InputFieldHelper.addPanel(jPanel, new BreezeSpinnerInputPanel("MWIR snapshot segment length", "The distance to move for each snapshot segment", 0.0f, 9999.0f, 1.0f, ((HySpexCoreScannerTableSettings)this.getSettings()).getMwirScanLength(), "mm", d -> ((HySpexCoreScannerTableSettings)this.getSettings()).setMwirScanLength((double)d)));
        InputFieldHelper.addPanel(jPanel, new BreezeSpinnerInputPanel("LWIR camera location", "", 0.0f, 9999.0f, 1.0f, ((HySpexCoreScannerTableSettings)this.getSettings()).getLwirLocation(), "mm", d -> ((HySpexCoreScannerTableSettings)this.getSettings()).setLwirLocation((double)d)));
        InputFieldHelper.addPanel(jPanel, new BreezeSpinnerInputPanel("LWIR snapshot segment length", "The distance to move for each snapshot segment", 0.0f, 9999.0f, 1.0f, ((HySpexCoreScannerTableSettings)this.getSettings()).getLwirScanLength(), "mm", d -> ((HySpexCoreScannerTableSettings)this.getSettings()).setLwirScanLength((double)d)));
        InputFieldHelper.addPanel(jPanel, new BreezeSpinnerInputPanel("VNIR/SWIR cameras location", "", 0.0f, 9999.0f, 1.0f, ((HySpexCoreScannerTableSettings)this.getSettings()).getPushBroomCamerasLocation(), "mm", d -> ((HySpexCoreScannerTableSettings)this.getSettings()).setPushBroomCamerasLocation((double)d)));
        InputFieldHelper.addPanel(jPanel, new BreezeMultiSelectInputField(BreezeFrame.getInstance(), "Select sensors for scanning sequence \u25bc", AvailableSensors, ((HySpexCoreScannerTableSettings)this.getSettings()).getActiveSensors(), 14, list -> {
            ((HySpexCoreScannerTableSettings)this.getSettings()).setActiveSensors(list);
            this.updateSensorInfoPanel();
        }));
        InputFieldHelper.addPanel(jPanel, this.sensorInfoPanel);
        InputFieldHelper.addPanel(jPanel, new BreezeCheckBox("Disable homing", ((HySpexCoreScannerTableSettings)this.getSettings()).isHomingDisabled(), bl -> ((HySpexCoreScannerTableSettings)this.getSettings()).setHomingDisabled(bl)));
    }

    private void updateSensorInfoPanel() {
        boolean bl;
        List<String> list = ((HySpexCoreScannerTableSettings)this.getSettings()).getActiveSensors();
        if (list.isEmpty() || list.getFirst().isBlank()) {
            this.sensorInfoPanel.updatePanel(BreezeInfoPanel.InfoType.Warning, "Select at least one sensor to use the Core Scanner.");
            return;
        }
        boolean bl2 = bl = list.contains("Profile") && !((HySpexCoreScannerTableSettings)this.getSettings()).getActiveSensors().contains("VNIR") && !((HySpexCoreScannerTableSettings)this.getSettings()).getActiveSensors().contains("SWIR");
        if (bl) {
            this.sensorInfoPanel.updatePanel(BreezeInfoPanel.InfoType.Warning, "Profile is selected but will not be captured, since VNIR or SWIR is needed to trigger it.");
        } else {
            this.sensorInfoPanel.updatePanel(BreezeInfoPanel.InfoType.Note, "The selected sensors will be used to record measurements.");
        }
    }

    public static class HySpexCoreScannerTableSettings
    extends HySpexStepperTable.HySpexStepperTableSettings {
        public HySpexCoreScannerTableSettings(HySpexCoreScannerTable hySpexCoreScannerTable) {
            super((RemoteSampleMover<? extends HySpexStepperTable.HySpexStepperTableSettings>)hySpexCoreScannerTable);
        }

        public float getRgbLocation() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "RgbLocation", 1.0f);
        }

        public void setRgbLocation(double d) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "RgbLocation", (float)d);
        }

        public float getRgbScanLength() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "RgbScanLength", 400.0f);
        }

        public void setRgbScanLength(double d) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "RgbScanLength", (float)d);
        }

        public float getLwirLocation() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "LwirLocation", 690.0f);
        }

        public void setLwirLocation(double d) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "LwirLocation", (float)d);
        }

        public float getMwirLocation() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "MwirLocation", 2600.0f);
        }

        public void setMwirLocation(double d) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "MwirLocation", (float)d);
        }

        public float getPushBroomCamerasLocation() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "LineScannersLocation", 1050.0f);
        }

        public void setPushBroomCamerasLocation(double d) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "LineScannersLocation", (float)d);
        }

        public float getMwirScanLength() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "MwirScanLength", 500.0f);
        }

        public void setMwirScanLength(double d) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "MwirScanLength", (float)d);
        }

        public float getLwirScanLength() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "LwirScanLength", 485.0f);
        }

        public void setLwirScanLength(double d) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "LwirScanLength", (float)d);
        }

        public List<String> getActiveSensors() {
            return Arrays.asList(BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "ActiveSensors", String.join((CharSequence)";", AvailableSensors)).split(";"));
        }

        public void setActiveSensors(List<String> list) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "ActiveSensors", String.join((CharSequence)";", list));
        }

        public boolean isHomingDisabled() {
            return BreezeProperties.getInstance().getSampleMoverPropertyBool(this.mover, "IsHomingDisabled", true);
        }

        public void setHomingDisabled(boolean bl) {
            BreezeProperties.getInstance().setSampleMoverPropertyBool(this.mover, "IsHomingDisabled", bl);
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("rgbLocation", (Object)Float.valueOf(this.getRgbLocation())));
            list.add(new Command.Argument("rgbLength", (Object)Float.valueOf(this.getRgbScanLength())));
            list.add(new Command.Argument("lwirLocation", (Object)Float.valueOf(this.getLwirLocation())));
            list.add(new Command.Argument("mwirLocation", (Object)Float.valueOf(this.getMwirLocation())));
            list.add(new Command.Argument("lwirLength", (Object)Float.valueOf(this.getLwirScanLength())));
            list.add(new Command.Argument("mwirLength", (Object)Float.valueOf(this.getMwirScanLength())));
            list.add(new Command.Argument("lineScannersLocation", (Object)Float.valueOf(this.getPushBroomCamerasLocation())));
            list.add(new Command.Argument("isCoreScanner", (Object)true));
            list.add(new Command.Argument("isHomingDisabled", (Object)this.isHomingDisabled()));
            list.add(new Command.Argument("cameraIdsInOrder", (Object)this.getCamerasString()));
            list.add(new Command.Argument("activeDevices", (Object)String.join((CharSequence)";", this.getActiveSensors())));
            return list;
        }

        private String getCamerasString() {
            StringBuilder stringBuilder = new StringBuilder();
            List<Camera> list = HardwareRegistry.getInstance().getCameras();
            list.stream().filter(camera -> camera instanceof IDSCamera).findFirst().ifPresentOrElse(camera -> stringBuilder.append(camera.getId()).append(';'), () -> stringBuilder.append("-1;"));
            list.stream().filter(camera -> camera instanceof RgbUsbCamera).findFirst().ifPresentOrElse(camera -> stringBuilder.append(camera.getId()).append(';'), () -> stringBuilder.append("-1;"));
            list.stream().filter(camera -> camera instanceof SonyCamera).findFirst().ifPresentOrElse(camera -> stringBuilder.append(camera.getId()).append(';'), () -> stringBuilder.append("-1;"));
            List<Camera> list2 = list.stream().filter(camera -> camera instanceof HySpexCamera).toList();
            List<Camera> list3 = list.stream().filter(camera -> camera instanceof HySpexTelopCamera).toList();
            list3.stream().filter(camera -> camera.getFormattedCameraType().contains("LWIR")).findFirst().ifPresentOrElse(camera -> stringBuilder.append(camera.getId()).append(";"), () -> stringBuilder.append("-1;"));
            list3.stream().filter(camera -> camera.getFormattedCameraType().contains("MWIR")).findFirst().ifPresentOrElse(camera -> stringBuilder.append(camera.getId()).append(";"), () -> stringBuilder.append("-1;"));
            list2.stream().filter(camera -> camera.getFormattedCameraType().contains("VNIR")).findFirst().ifPresentOrElse(camera -> stringBuilder.append(camera.getId()).append(";"), () -> stringBuilder.append("-1;"));
            list2.stream().filter(camera -> camera.getFormattedCameraType().contains("SWIR")).findFirst().ifPresentOrElse(camera -> stringBuilder.append(camera.getId()), () -> stringBuilder.append("-1"));
            return stringBuilder.toString();
        }
    }
}

