/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.HySpexCamera;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettingsPanel;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.util.FileFromAbsolutePath;

public class HySpexStepperTable<T extends HySpexStepperTableSettings>
extends RemoteSampleMover<T> {
    public HySpexStepperTable() {
        this("HySpexStepperTableMotor");
    }

    public HySpexStepperTable(String string) {
        super(string);
    }

    public String toString() {
        return "HySpex Lab/Tripod Scanner";
    }

    @Override
    public String getXmlNodeName() {
        return "hySpexStepperTable";
    }

    @Override
    protected boolean automaticHomingOnConnect() {
        return false;
    }

    @Override
    public JPanel getSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        File file = ((HySpexStepperTableSettings)this.getSettings()).settingsFolder();
        if (file != null && file.getName().isEmpty()) {
            file = null;
        }
        RemoteSampleMoverSettingsPanel remoteSampleMoverSettingsPanel = new RemoteSampleMoverSettingsPanel(this, settingsPanelCallback, false);
        FileInputField.FolderInputField folderInputField = new FileInputField.FolderInputField((Component)remoteSampleMoverSettingsPanel, "Settings folder", file, textActionEvent -> ((HySpexStepperTableSettings)this.getSettings()).changeSettingsFolder(new FileFromAbsolutePath(textActionEvent.getText()).getAbsolutePathOrEmpty()), true, BreezeInputFieldHelper.Format.TwoRows);
        folderInputField.setUsage("Path to stepper table settings folder (must include hyspex_auxiliary.json). If not specified, the camera's settings folder will be used");
        InputFieldHelper.addPanel(remoteSampleMoverSettingsPanel, folderInputField);
        this.addAdditionalComponents(remoteSampleMoverSettingsPanel);
        remoteSampleMoverSettingsPanel.addAdvancedAndFill(settingsPanelCallback);
        return remoteSampleMoverSettingsPanel;
    }

    protected void addAdditionalComponents(JPanel jPanel) {
    }

    @Override
    protected T createSettings() {
        return (T)new HySpexStepperTableSettings((RemoteSampleMover<? extends HySpexStepperTableSettings>)this);
    }

    public static class HySpexStepperTableSettings
    extends RemoteSampleMoverSettings {
        public HySpexStepperTableSettings(RemoteSampleMover<? extends HySpexStepperTableSettings> remoteSampleMover) {
            super(remoteSampleMover);
        }

        public void changeSettingsFolder(String string) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "settingsFolder", string);
        }

        public File settingsFolder() {
            String string = BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "settingsFolder", null);
            if (string == null) {
                return null;
            }
            return new File(string);
        }

        private static File getDefaultHySpexSettingsFolder(File file) {
            Camera camera = HardwareRegistry.getInstance().getActiveCamera();
            boolean bl = camera.getDeviceName().equals("HySpexCamera");
            if (file == null || file.getName().isEmpty()) {
                file = bl ? ((HySpexCamera.HySpexSettings)((HySpexCamera)camera).getSettings()).getSettingsFile() : HySpexCamera.DEFAULT_SETTINGS_PATH;
            }
            return file;
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("SetFilePath", HySpexStepperTableSettings.getDefaultHySpexSettingsFolder(this.settingsFolder())));
            return list;
        }
    }
}

