/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.map.main.script.EvinceScriptCommands;

public class MoverMode {
    private final String name;

    public MoverMode(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getXmlNodeName() {
        return EvinceScriptCommands.removeSpace((String)this.name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof MoverMode) {
            return ((MoverMode)object).getXmlNodeName().equals(this.getXmlNodeName());
        }
        return super.equals(object);
    }

    public static MoverMode fromXml(String string) {
        return new MoverMode(string);
    }

    public static MoverModeList list() {
        MoverModeList moverModeList = new MoverModeList();
        moverModeList.add(new MoverMode("Reflectance"));
        moverModeList.add(new MoverMode("Transmittance"));
        return moverModeList;
    }

    public static class MoverModeList
    extends ArrayList<MoverMode> {
    }

    public static class MoverModeInputField
    extends BreezeComboBoxInputField<MoverMode> {
        public MoverModeInputField(List<MoverMode> list, MoverMode moverMode, BreezeComboBoxInputField.SelectionChangedListener<MoverMode> selectionChangedListener) {
            super("Mode", list, moverMode, selectionChangedListener);
        }
    }

    public static class MoverModeSettings {
        protected SampleMover mover;

        public MoverModeSettings(SampleMover sampleMover) {
            this.mover = sampleMover;
        }

        public String getName() {
            return this.mover.toString();
        }

        public MoverMode getMode() {
            return MoverMode.fromXml(BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "mode", "mode1"));
        }

        public void setMode(MoverMode moverMode) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "mode", moverMode.getName());
            this.clear();
        }

        public void clear() {
        }
    }
}

