/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;

public class PositionInputField
extends BreezeInputField.Number {
    private final RemoteSampleMover mover;
    private final TrayCallback callback;
    private BreezeButton backButton;
    private BreezeButton nextButton;
    private BreezeButton moveButton;

    public PositionInputField(String string, double d, TrayCallback trayCallback, RemoteSampleMover remoteSampleMover) {
        this(string, d, trayCallback, remoteSampleMover, null);
    }

    public PositionInputField(String string, double d, TrayCallback trayCallback, RemoteSampleMover remoteSampleMover, TextActionEvent.TextActionListener textActionListener) {
        super(string, d, remoteSampleMover.getType().getUnit());
        this.mover = remoteSampleMover;
        this.callback = trayCallback;
        this.addValidator(new NumericMinMaxValidator(-SampleMover.getValidatorMaxLength((SampleMover)remoteSampleMover, (int)Integer.MAX_VALUE).value, SampleMover.getValidatorMaxLength((SampleMover)remoteSampleMover, (int)Integer.MAX_VALUE).value, "max length"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
        boolean bl = remoteSampleMover.isConnected();
        RemoteSampleMoverSettings.MoverType moverType = HardwareRegistry.getInstance().getSampleMoverType();
        int n = moverType.equals((Object)RemoteSampleMoverSettings.MoverType.Rotation) ? 1 : 5;
        String string2 = remoteSampleMover.getType().getUnit();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = jPanel.getComponentCount();
        this.backButton = this.createButton("<", -n, bl);
        jPanel.add((Component)this.backButton, gridBagConstraints);
        this.backButton.setToolTipText("Move backwards by " + n + " " + string2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = jPanel.getComponentCount();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.moveButton = this.createButton("Move", 0, bl);
        jPanel.add((Component)this.moveButton, gridBagConstraints);
        this.moveButton.setToolTipText("Move to given position");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = jPanel.getComponentCount();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.nextButton = this.createButton(">", n, bl);
        jPanel.add((Component)this.nextButton, gridBagConstraints);
        this.nextButton.setToolTipText("Move forward by " + n + " " + string2);
        this.getTextField().replaceCrossPanel(jPanel);
        if (textActionListener != null) {
            this.addChangeListener(textActionListener);
        }
    }

    private BreezeButton createButton(String string, int n, boolean bl) {
        BreezeButton breezeButton = new BreezeButton(string, null){

            @Override
            protected void mouseEnteredLocal() {
                super.mouseEnteredLocal();
                if (this.isEnabled()) {
                    this.setTextForeground(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse());
                }
            }

            @Override
            protected void mouseExitedLocal() {
                super.mouseExitedLocal();
                if (this.isEnabled()) {
                    this.setTextForeground(BreezeTheme.getInstance().getLabelForeground());
                }
            }
        };
        breezeButton.addClickCallBack(() -> {
            if (this.moveButton.getText().equals("Stop")) {
                this.callback.stop();
                this.toggle(true);
                return;
            }
            this.toggle(false);
            if (n != 0) {
                this.setTextAndTrigger(RtDataFormat.toString(this.getNumber() + (double)n));
            }
            float f = this.getNumberFloat();
            if (this.mover.checkWithinLimits(BreezeFrame.getInstance(), BreezeType.Project.getColor(), f)) {
                new Thread(() -> {
                    this.callback.moveToPosition(f);
                    SwingUtilities.invokeLater(() -> this.toggle(true));
                }).start();
            } else {
                this.toggle(true);
            }
        });
        breezeButton.setOpaque(true);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        breezeButton.setRoundedBorder(false);
        int n2 = string.length() > 1 ? 50 : 15;
        breezeButton.setPreferredSize(new Dimension(n2, 28));
        breezeButton.setMinimumSize(new Dimension(n2, 28));
        if (bl) {
            breezeButton.setBackground(breezeTheme.getDialogBackground());
            breezeButton.setTextForeground(breezeTheme.getLabelForeground());
        } else {
            breezeButton.setDisabledBackground(breezeTheme.getSettingPanelBackground());
            breezeButton.setTextForeground(breezeTheme.getLabelForegroundMoreDifuse());
        }
        breezeButton.setEnabled(bl);
        breezeButton.setTextFont(new Font("Tahoma", 0, 14));
        return breezeButton;
    }

    private void toggle(boolean bl) {
        this.backButton.setEnabled(bl);
        this.moveButton.setText(bl ? "Move" : "Stop");
        this.nextButton.setEnabled(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.backButton.setEnabled(bl);
        this.moveButton.setEnabled(bl);
        this.nextButton.setEnabled(bl);
    }

    public static interface TrayCallback {
        public void moveToPosition(float var1);

        public void stop();
    }
}

