/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import lombok.Generated;
import se.prediktera.breeze.common.hardware.settings.MeasureLengthSettings;
import se.prediktera.breeze.common.util.BreezeInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.samplemover.RemoteMotor;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;

public abstract class RemoteSampleMover<T extends RemoteSampleMoverSettings>
implements SampleMover,
SampleMover.SettingsPanelSampleMover {
    protected RemoteMotor remoteMotor;
    private boolean connected;
    protected final T settings = this.createSettings();

    protected T createSettings() {
        return (T)new RemoteSampleMoverSettings(this);
    }

    public RemoteSampleMover(String string) {
        this.remoteMotor = this.createRemoteMotor(string);
    }

    protected RemoteMotor createRemoteMotor(String string) {
        return new RemoteMotor(string, this.toString());
    }

    @Override
    public void connect(BreezeProgress breezeProgress, BreezeInterface breezeInterface) {
        breezeProgress.setInfoText("Connecting to " + String.valueOf(this));
        ComPort comPort = ((RemoteSampleMoverSettings)this.getSettings()).port();
        this.remoteMotor.connect(breezeProgress, comPort, () -> {
            this.connected = false;
        }, ((RemoteSampleMoverSettings)this.getSettings()).getArguments());
        if (this.isTray() && this.automaticHomingOnConnect()) {
            breezeProgress.setIndeterminate(true);
            breezeProgress.setInfoText("Homing");
            this.remoteMotor.move(((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), -1.0, ((RemoteSampleMoverSettings)this.getSettings()).homingDirection(), RemoteMotor.MotorDriveMode.Homing);
        }
        this.connected = true;
        ComPort comPort2 = this.getComPort();
        if (comPort != null && comPort2 != null && !comPort.name.equals(comPort2.name)) {
            ((RemoteSampleMoverSettings)this.getSettings()).changePort(comPort2);
        }
        BreezeProperties.getInstance().increaseSaveIndex();
    }

    protected boolean automaticHomingOnConnect() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void disconnect(BreezeProgressManager breezeProgressManager) {
        try {
            this.remoteMotor.disconnect();
        }
        finally {
            this.connected = false;
        }
        ((RemoteSampleMoverSettings)this.settings).clear();
        BreezeProperties.getInstance().increaseSaveIndex();
    }

    @Override
    public void stop() {
        this.remoteMotor.stopMotor();
    }

    public void stopDemo() {
        this.remoteMotor.stopDemo();
    }

    public boolean supportVerticalMovement() {
        return ((RemoteSampleMoverSettings)this.settings).supportVerticalMovement();
    }

    public void home() {
        this.remoteMotor.move(((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), 0.0, RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Homing);
    }

    @Override
    public void moveToReturnPosition(Camera camera) {
        this.remoteMotor.move(((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), ((RemoteSampleMoverSettings)this.getSettings()).returnLocationDependingOnHoming(), RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Absolute);
    }

    @Override
    public void moveToScanStartPosition(Camera camera) {
        this.remoteMotor.move(((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), ((RemoteSampleMoverSettings)this.getSettings()).scanStartLocationDependingOnHoming(), RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Absolute);
    }

    @Override
    public boolean isBusy() {
        return this.remoteMotor.isBusy();
    }

    @Override
    public ImageIcon getIcon() {
        return RemoteCamera.HardwareIcon.create(this);
    }

    @Override
    public void runScan(LengthValue lengthValue, SampleMover.ScanMode scanMode, SampleMover.ScanEventListener scanEventListener, Camera camera) {
        if (scanMode.equals((Object)SampleMover.ScanMode.DemoByLength)) {
            this.remoteMotor.runDemo(new Speed(camera), ((RemoteSampleMoverSettings)this.getSettings()).scanStartLocationDependingOnHoming(), lengthValue.withScanMarginal(), ((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), ((RemoteSampleMoverSettings)this.getSettings()).maxSpeed(), scanEventListener, camera);
        } else {
            this.remoteMotor.runScan(new Speed(camera), ((RemoteSampleMoverSettings)this.getSettings()).scanStartLocationDependingOnHoming(), lengthValue.withScanMarginal(), ((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), ((RemoteSampleMoverSettings)this.getSettings()).maxSpeed(), scanEventListener);
        }
    }

    public Map<String, String> remoteScan(LengthValue lengthValue, SampleMover.ScanMode scanMode, List<Camera> list, List<FrameCount> list2, boolean bl, boolean bl2) {
        Camera camera = MeasureLengthSettings.getReferenceCamera(list.getFirst());
        return this.remoteScan(null, ((RemoteSampleMoverSettings)this.getSettings()).scanStartLocationDependingOnHoming(), lengthValue, scanMode, camera, list2, bl, bl2);
    }

    public Map<String, String> remoteScan(LengthValue lengthValue, SampleMover.ScanMode scanMode, Camera camera, List<FrameCount> list, boolean bl, boolean bl2) {
        return this.remoteScan(null, ((RemoteSampleMoverSettings)this.getSettings()).scanStartLocationDependingOnHoming(), lengthValue, scanMode, camera, list, bl, bl2);
    }

    public Map<String, String> remoteScan(BreezeProgress breezeProgress, float f, LengthValue lengthValue, SampleMover.ScanMode scanMode, Camera camera, List<FrameCount> list, boolean bl, boolean bl2) {
        Speed speed = scanMode.whiteReference() ? new Speed(camera, list.getFirst(), lengthValue.value) : new Speed(camera);
        Speed speed2 = speed.limitByMaxSpeed(((RemoteSampleMoverSettings)this.getSettings()).maxSpeed().value);
        SampleMover.ScanMode scanMode2 = scanMode.actual();
        return this.remoteMotor.remoteScan(breezeProgress, camera, scanMode2, speed2, ((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), ((RemoteSampleMoverSettings)this.getSettings()).maxSpeed(), this.getStartLocationWithOffset(f, camera, bl2), lengthValue, list, bl, RemoteSampleMover.getTimeOut(scanMode2, lengthValue, speed2));
    }

    private LengthValue getStartLocationWithOffset(float f, Camera camera, boolean bl) {
        if (bl) {
            return new LengthValue(f).withOffset(HardwareRegistry.getInstance().getMinOffset());
        }
        return Camera.withOffset(f, camera);
    }

    private static Time getTimeOut(SampleMover.ScanMode scanMode, LengthValue lengthValue, Speed speed) {
        if (scanMode.equals((Object)SampleMover.ScanMode.DemoByLength)) {
            return Time.Forever;
        }
        return lengthValue.timeToTravel(speed).multiplied(5.0).add(new Time.Minutes(15.0));
    }

    @Override
    public void moveToEndScanPosition() {
        this.moveToReturnPosition(null);
    }

    @Override
    public ComPort getComPort() {
        if (((RemoteSampleMoverSettings)this.getSettings()).port().isAuto() && this.isConnected()) {
            String string = this.getRemoteMotor().getMotorProperty("SerialPortName", true);
            return new ComPort(string);
        }
        return ((RemoteSampleMoverSettings)this.getSettings()).port();
    }

    @Override
    public boolean inFocusState(Camera camera) {
        return this.remoteMotor.withinPositon(Camera.withOffset((float)((RemoteSampleMoverSettings)this.getSettings()).focusLocation(), (Camera)camera).value);
    }

    @Override
    public void exitFocusState() {
    }

    @Override
    public void enterFocusState(Camera camera) {
        this.remoteMotor.move(((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), Camera.withOffset((float)((RemoteSampleMoverSettings)this.getSettings()).focusLocationDependingOnHoming(), (Camera)camera).value, RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Absolute);
    }

    @Override
    public boolean hasWhiteRefState() {
        return ((RemoteSampleMoverSettings)this.getSettings()).useWhiteRefLocation();
    }

    @Override
    public boolean inWhiteRefState(Camera camera) {
        return this.remoteMotor.withinPositon(Camera.withOffset((float)((RemoteSampleMoverSettings)this.getSettings()).whiteRefLocation(), (Camera)camera).value);
    }

    @Override
    public void exitWhiteRefState() {
    }

    @Override
    public LengthValue whiteRefScanLength() {
        return new LengthValue(((RemoteSampleMoverSettings)this.getSettings()).whiteRefScanLength());
    }

    @Override
    public void enterWhiteRefState(Camera camera) {
        this.remoteMotor.move(((RemoteSampleMoverSettings)this.getSettings()).movementSpeed(), this.getWhiteRefLocation((Camera)camera).value, RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Absolute);
    }

    private LengthValue getWhiteRefLocation(Camera camera) {
        return Camera.withOffset(((RemoteSampleMoverSettings)this.getSettings()).whiteRefLocationDependingOnHoming(), camera);
    }

    public boolean isScanWhiteReference() {
        return ((RemoteSampleMoverSettings)this.getSettings()).whiteRefScanLength() != 0.0f;
    }

    public void scanWhiteReference(BreezeProgress breezeProgress, Camera camera, SampleMover.ScanMode scanMode) {
        this.remoteScan(breezeProgress, ((RemoteSampleMoverSettings)this.getSettings()).whiteRefLocationDependingOnHoming(), new LengthValue(((RemoteSampleMoverSettings)this.getSettings()).whiteRefScanLength()), scanMode, camera, Arrays.asList(BreezeProperties.getInstance().getWhiteReferenceFrames()), false, false);
    }

    @Override
    public Speed movementSpeed() {
        return ((RemoteSampleMoverSettings)this.getSettings()).movementSpeed();
    }

    @Override
    public Speed maxSpeed() {
        return ((RemoteSampleMoverSettings)this.getSettings()).maxSpeed();
    }

    @Override
    public LengthValue minLength() {
        return ((RemoteSampleMoverSettings)this.getSettings()).minLength();
    }

    @Override
    public LengthValue maxLength() {
        return ((RemoteSampleMoverSettings)this.getSettings()).maxLength();
    }

    @Override
    public RemoteSampleMoverSettings.MoverType getType() {
        return ((RemoteSampleMoverSettings)this.getSettings()).getType();
    }

    @Override
    public float getPosition() {
        return this.getRemoteMotor().getPosition();
    }

    @Override
    public boolean isRunning() {
        return this.getRemoteMotor().isRunning();
    }

    public boolean checkWithinLimits(BreezeFrame breezeFrame, Color color, MeasurementLength measurementLength, Camera camera) {
        float f = ((RemoteSampleMoverSettings)this.settings).scanStartLocation();
        LengthValue lengthValue = measurementLength.getLength(camera);
        lengthValue.setUnit(HardwareRegistry.getInstance().getSampleMoverUnit());
        float f2 = camera.getOffset().value;
        float f3 = lengthValue.value + f + f2;
        RemoteSampleMoverSettings.MoverType moverType = ((RemoteSampleMoverSettings)this.settings).getType();
        LengthValue lengthValue2 = ((RemoteSampleMoverSettings)this.settings).maxLength();
        if (lengthValue2.value > 0.0f && f3 >= lengthValue2.value) {
            BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Max length exceeded", RemoteSampleMover.getMaxLengthMessage("Max", f, lengthValue, f3, moverType, lengthValue2, f2));
            return false;
        }
        LengthValue lengthValue3 = ((RemoteSampleMoverSettings)this.settings).minLength();
        if (f3 < lengthValue3.value) {
            BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Min length exceeded", RemoteSampleMover.getMaxLengthMessage("Min", f, lengthValue, f3, moverType, lengthValue3, f2));
            return false;
        }
        return true;
    }

    private static String getMaxLengthMessage(String string, float f, LengthValue lengthValue, float f2, RemoteSampleMoverSettings.MoverType moverType, LengthValue lengthValue2, float f3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + " length of the sample mover will be exceeded (" + lengthValue2.toString() + ")\n\n");
        stringBuilder.append("Start location: " + moverType.addUnit(f) + "\n");
        if (f3 > 0.0f) {
            stringBuilder.append("Camera offset: " + moverType.addUnit(f3) + "\n");
        }
        stringBuilder.append("Measurement length: " + lengthValue.toString() + "\n");
        stringBuilder.append("End location: " + moverType.addUnit(f2) + "\n\n");
        stringBuilder.append("Change measurement length and try again");
        return stringBuilder.toString();
    }

    public boolean checkWithinLimits(BreezeFrame breezeFrame, Color color, float f) {
        LengthValue lengthValue = ((RemoteSampleMoverSettings)this.settings).maxLength();
        if (lengthValue.value > 0.0f && f >= lengthValue.value) {
            BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Max length exceeded", "Max length of the sample mover will be exceeded (" + lengthValue.toString() + ")\n\nChange position and try again");
            return false;
        }
        LengthValue lengthValue2 = ((RemoteSampleMoverSettings)this.settings).minLength();
        if (f < lengthValue2.value) {
            BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Min length exceeded", "Min length of the sample mover will be exceeded (" + lengthValue2.toString() + ")\n\nChange position and try again");
            return false;
        }
        return true;
    }

    public void waitUntilStop(Time time) {
        boolean bl = this.isConveyor();
        float f = ((RemoteSampleMoverSettings)this.getSettings()).returnLocation();
        ThreadUtil.awaitOrThrow(() -> {
            if (bl || this.getPosition() == f) {
                return !this.isRunning();
            }
            return false;
        }, time, "Timeout wating for motor to stop at return location (" + f + "), current location (" + this.getPosition() + ")");
    }

    @Generated
    public RemoteMotor getRemoteMotor() {
        return this.remoteMotor;
    }

    @Generated
    public T getSettings() {
        return this.settings;
    }
}

