/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.hardware.samplemover.RemoteMotor;
import se.prediktera.breeze.hardware.samplemover.tray.MoverMode;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class RemoteSampleMoverSettings
extends MoverMode.MoverModeSettings {
    private LengthValue minLength;
    private LengthValue maxLength;
    private Speed maxSpeed;
    private Boolean supportVerticalMovement;
    private MoverType type;

    public RemoteSampleMoverSettings(RemoteSampleMover remoteSampleMover) {
        super(remoteSampleMover);
    }

    public ComPort port() {
        return ComPort.fromXmlValue(BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "port", ComPort.Auto.toXmlValue()));
    }

    public float focusLocationDependingOnHoming() {
        return this.getLocationDependingOnHoming(this.focusLocation());
    }

    public float whiteRefLocationDependingOnHoming() {
        return this.getLocationDependingOnHoming(this.whiteRefLocation());
    }

    public float scanStartLocationDependingOnHoming() {
        return this.getLocationDependingOnHoming(this.scanStartLocation());
    }

    public float returnLocationDependingOnHoming() {
        return this.getLocationDependingOnHoming(this.returnLocation());
    }

    public float getLocationDependingOnHoming(float f) {
        return this.homingDirection() == this.getDefaultHomingDirection() ? f : -f;
    }

    public LengthValue minLength() {
        if (this.minLength == null) {
            if (this.mover.isConnected()) {
                this.minLength = new LengthValue(((RemoteSampleMover)this.mover).getRemoteMotor().getMotorPropertyFloat("MinLength", true), this.getType().getUnit());
                return this.minLength;
            }
            return new LengthValue(0.0f);
        }
        return this.minLength;
    }

    public LengthValue maxLength() {
        if (this.maxLength == null) {
            float f;
            if (this.mover.isConnected() && (f = ((RemoteSampleMover)this.mover).getRemoteMotor().getMotorPropertyFloat("MaxLength", true)) != 0.0f) {
                this.maxLength = new LengthValue(f, this.getType().getUnit());
                return this.maxLength;
            }
            return new LengthValue(BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "maxLength", 0.0f));
        }
        return this.maxLength;
    }

    public Speed movementSpeed() {
        return new Speed(BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "movementSpeed", this.getDefaultMovementSpeed()), this.getType().getUnit());
    }

    protected float getDefaultMovementSpeed() {
        return 50.0f;
    }

    public Speed verticalMovementSpeed() {
        return new Speed(BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "verticalMovementSpeed", this.getDefaultVerticalMovementSpeed()));
    }

    protected float getDefaultVerticalMovementSpeed() {
        return 10.0f;
    }

    public float focusLocation() {
        return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "focusLocation", 28.0f);
    }

    public boolean useWhiteRefLocation() {
        return BreezeProperties.getInstance().getSampleMoverPropertyBool(this.mover, "useWhiteRefLocation", true);
    }

    public float whiteRefLocation() {
        return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "whiteRefLocation", 8.0f);
    }

    public float whiteRefScanLength() {
        return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "whiteRefLength", 0.0f);
    }

    public float scanStartLocation() {
        return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "startLocation", 35.0f);
    }

    public float returnLocation() {
        return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "sampleLocation", 0.0f);
    }

    public float verticalLocation() {
        return BreezeProperties.getInstance().getSampleMoverPropertyFloat(this.mover, "verticalLocation", 0.0f);
    }

    public Speed maxSpeed() {
        if (this.maxSpeed == null && this.mover.isConnected()) {
            this.maxSpeed = new Speed(((RemoteSampleMover)this.mover).getRemoteMotor().getMotorPropertyFloat("MaxSpeedMm", true), this.getType().getUnit());
        }
        return this.maxSpeed;
    }

    public MoverType getType() {
        if (this.type == null) {
            if (this.mover.isConnected()) {
                String string = ((RemoteSampleMover)this.mover).getRemoteMotor().getMotorProperty("Type", true);
                this.type = MoverType.parse(string);
                BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "moverType", string);
            } else {
                return MoverType.parse(BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "moverType", "translation"));
            }
        }
        return this.type;
    }

    public RemoteMotor.MotorDirection homingDirection() {
        return RemoteMotor.MotorDirection.valueOf(BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "homingDirection", this.getDefaultHomingDirection().name()));
    }

    protected RemoteMotor.MotorDirection getDefaultHomingDirection() {
        return RemoteMotor.MotorDirection.Forward;
    }

    public void changePort(ComPort comPort) {
        BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "port", comPort.name);
    }

    public void changeMaxLength(double d) {
        BreezeProperties.getInstance().setSampleMoverPropertyDouble(this.mover, "maxLength", d);
    }

    public void changeMovementSpeed(float f) {
        BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "movementSpeed", f);
    }

    public void changeFocusLocation(float f) {
        BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "focusLocation", f);
    }

    public void changeUseWhiteRefLocation(boolean bl) {
        BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "useWhiteRefLocation", Boolean.toString(bl));
    }

    public void changeWhiteRefLocation(float f) {
        BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "whiteRefLocation", f);
    }

    public void changeWhiteRefScanLength(float f) {
        BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "whiteRefLength", f);
    }

    public void changeScanStartLocation(float f) {
        BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "startLocation", f);
    }

    public void changeReturnLocation(float f) {
        BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "sampleLocation", f);
    }

    public void changeVerticalLocation(float f) {
        BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "verticalLocation", f);
    }

    public void changeHomingDirection(RemoteMotor.MotorDirection motorDirection) {
        BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "homingDirection", motorDirection.name());
    }

    private boolean transmittanceModeEnabled() {
        return BreezeProperties.getInstance().getSampleMoverTransmittanceModeEnabled(this.mover);
    }

    public Mode reflectanceTransmittanceMode() {
        return Mode.fromBoolean(this.transmittanceModeEnabled());
    }

    public void setTransmittanceReflectanceMode(Mode mode) {
        BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "transmittanceModeEnabled", Boolean.toString(mode.isTransmittance()));
    }

    public boolean supportVerticalMovement() {
        if (this.supportVerticalMovement == null && this.mover.isConnected()) {
            this.supportVerticalMovement = Boolean.parseBoolean(TcpManager.getInstance().getMotorProperty(((RemoteSampleMover)this.mover).getRemoteMotor(), "SupportVerticalMovement", true));
        }
        if (this.supportVerticalMovement != null) {
            return this.supportVerticalMovement;
        }
        return false;
    }

    public List<Command.Argument> getArguments() {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("Direction", this.getDefaultHomingDirection()));
        return arrayList;
    }

    @Override
    public void clear() {
        this.minLength = null;
        this.maxLength = null;
        this.maxSpeed = null;
        this.type = null;
        this.supportVerticalMovement = null;
    }

    public static enum MoverType {
        Translation("mm"),
        Rotation("\u00b0"),
        Lateral("mm");

        private final String unit;

        private MoverType(String string2) {
            this.unit = string2;
        }

        public String addUnit(float f) {
            return RtDataFormat.toString(f) + " " + this.unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public String getType() {
            return this.name().toLowerCase();
        }

        public static MoverType parse(String string) {
            for (MoverType moverType : MoverType.values()) {
                if (!moverType.name().equalsIgnoreCase(string)) continue;
                return moverType;
            }
            return Translation;
        }

        public boolean isTranslation() {
            return this.equals((Object)Translation);
        }

        public boolean isRotation() {
            return this.equals((Object)Rotation);
        }
    }

    public static enum Mode {
        Reflectance,
        Transmittance;


        public static Mode fromBoolean(boolean bl) {
            return bl ? Transmittance : Reflectance;
        }

        public boolean isTransmittance() {
            return this.equals((Object)Transmittance);
        }

        public static List<Mode> list() {
            return Arrays.asList(Mode.values());
        }
    }

    public static enum SampleMoverType {
        Tray,
        Conveyor;

    }
}

