/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.awt.GridBagLayout;
import java.util.Arrays;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.frontend.hardware.ComPortComboBox;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.samplemover.RemoteMotor;
import se.prediktera.breeze.hardware.samplemover.tray.MoverMode;
import se.prediktera.breeze.hardware.samplemover.tray.PositionInputField;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;

public class RemoteSampleMoverSettingsPanel
extends JPanel {
    private RemoteSampleMover<? extends RemoteSampleMoverSettings> sampleMover;

    public RemoteSampleMoverSettingsPanel(RemoteSampleMover<? extends RemoteSampleMoverSettings> remoteSampleMover, Hardware.SettingsPanelCallback settingsPanelCallback, boolean bl) {
        this.setLayout(new GridBagLayout());
        this.sampleMover = remoteSampleMover;
        if (!remoteSampleMover.isConnected()) {
            InputFieldHelper.addPanel(this, new ComPortComboBox("Serial port", remoteSampleMover.getSettings().port(), true, comPort -> ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changePort((ComPort)comPort)));
            if (bl) {
                InputFieldHelper.addPanel(this, new BreezeComboBoxInputField<RemoteMotor.MotorDirection>("Homing direction", Arrays.asList(RemoteMotor.MotorDirection.Reverse, RemoteMotor.MotorDirection.Forward), remoteSampleMover.getSettings().homingDirection(), motorDirection -> {
                    this.sampleMover = remoteSampleMover;
                    this.sampleMover.getSettings().changeHomingDirection((RemoteMotor.MotorDirection)((Object)motorDirection));
                }));
            }
            if (BreezeFrame.isModeFeature()) {
                InputFieldHelper.addPanel(this, new BreezeComboBoxInputField<RemoteSampleMoverSettings.Mode>("Mode", RemoteSampleMoverSettings.Mode.list(), remoteSampleMover.getSettings().reflectanceTransmittanceMode(), mode -> {
                    ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).setTransmittanceReflectanceMode((RemoteSampleMoverSettings.Mode)((Object)mode));
                    this.addAdvancedAndFill(settingsPanelCallback);
                }));
            }
        }
        this.setOpaque(false);
    }

    public CollapsePanel addAdvancedAndFill(Hardware.SettingsPanelCallback settingsPanelCallback) {
        if (BreezeFrame.isModeFeature()) {
            InputFieldHelper.addPanel(this, new MoverMode.MoverModeInputField(MoverMode.list(), this.sampleMover.getSettings().getMode(), moverMode -> this.sampleMover.getSettings().setMode((MoverMode)moverMode)));
        }
        CollapsePanel collapsePanel = RemoteSampleMoverSettingsPanel.createAdvancedPanel(this.sampleMover, settingsPanelCallback, false);
        InputFieldHelper.addPanel(this, collapsePanel);
        if (!this.sampleMover.automaticHomingOnConnect()) {
            CollapsePanel collapsePanel2 = new CollapsePanel("More");
            collapsePanel2.addPanelNoFillHorizontal(EntryMainHelper.createTextButton(this.sampleMover.getType().isRotation() ? "Set zero" : "Homing", () -> this.sampleMover.home()));
            collapsePanel.addPanel(collapsePanel2);
        }
        InputFieldHelper.addBottomFillPanel(this);
        return collapsePanel;
    }

    public static CollapsePanel createAdvancedPanel(final RemoteSampleMover<? extends RemoteSampleMoverSettings> remoteSampleMover, final Hardware.SettingsPanelCallback settingsPanelCallback, boolean bl2) {
        CollapsePanel collapsePanel = new CollapsePanel("Advanced");
        collapsePanel.setUnitWidth(40);
        collapsePanel.setCollapsed(bl2);
        collapsePanel.addPanel(new BreezeCheckBox("Take automatic white reference on \"White reference location\"", remoteSampleMover.getSettings().useWhiteRefLocation(), bl -> ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changeUseWhiteRefLocation(bl)));
        PositionInputField.TrayCallback trayCallback = new PositionInputField.TrayCallback(){

            @Override
            public void moveToPosition(float f) {
                remoteSampleMover.getRemoteMotor().move(((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).movementSpeed(), f, RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Absolute);
                settingsPanelCallback.reloadInformation();
            }

            @Override
            public void stop() {
                remoteSampleMover.getRemoteMotor().stopMotor();
            }
        };
        collapsePanel.addPanel(new SampleMover.MaxLengthInputField(remoteSampleMover.getSettings().maxLength(), remoteSampleMover), textActionEvent -> {
            ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changeMaxLength(textActionEvent.getValueFloat());
            settingsPanelCallback.reloadInformation();
        });
        collapsePanel.addPanel(new SampleMover.MovementInputField(remoteSampleMover.getSettings().movementSpeed(), remoteSampleMover), textActionEvent -> {
            ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changeMovementSpeed(textActionEvent.getValueFloat());
            settingsPanelCallback.reloadInformation();
        });
        collapsePanel.addPanel(new PositionInputField("Focus location", (double)remoteSampleMover.getSettings().focusLocation(), trayCallback, remoteSampleMover), textActionEvent -> ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changeFocusLocation(textActionEvent.getValueFloat()));
        collapsePanel.addPanel(new PositionInputField("White reference location", (double)remoteSampleMover.getSettings().whiteRefLocation(), trayCallback, remoteSampleMover), textActionEvent -> ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changeWhiteRefLocation(textActionEvent.getValueFloat()));
        collapsePanel.addPanel(new BreezeInputField.Number("White reference scan length", remoteSampleMover.getSettings().whiteRefScanLength(), remoteSampleMover.getUnit()), textActionEvent -> ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changeWhiteRefScanLength(textActionEvent.getValueFloat()));
        collapsePanel.addPanel(new PositionInputField("Scan start location", (double)remoteSampleMover.getSettings().scanStartLocation(), trayCallback, remoteSampleMover), textActionEvent -> ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changeScanStartLocation(textActionEvent.getValueFloat()));
        collapsePanel.addPanel(new PositionInputField("Return location", (double)remoteSampleMover.getSettings().returnLocation(), trayCallback, remoteSampleMover), textActionEvent -> ((RemoteSampleMoverSettings)remoteSampleMover.getSettings()).changeReturnLocation(textActionEvent.getValueFloat()));
        return collapsePanel;
    }
}

