/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.entry.application.status.StatusList;
import se.prediktera.breeze.hardware.samplemover.tray.CameraIndexSampleMover;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class TrayDialog
extends JDialog {
    private final CameraIndexSampleMover.CameraIndexSampleMoverDriver mover;
    private final List<MoverStatus> positionsOverTime = new ArrayList<MoverStatus>(8192);
    private final long startTime;
    private final ScheduledExecutorService poller = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable, "TrayDialog-Poller");
        thread.setDaemon(true);
        return thread;
    });
    private final TrayPanel trayPanel = new TrayPanel();
    private final TimePositionPanel timePanel = new TimePositionPanel();
    private static final int POLL_MS = 200;
    private static final int MAX_POINTS = 500000;
    private static final int PIXELS_PER_SECOND = 80;
    private static final int LEFT_MARGIN = 40;
    private static final int RIGHT_MARGIN = 20;
    private static final int TOP_MARGIN = 10;
    private static final int BOTTOM_MARGIN = 24;

    public TrayDialog(CameraIndexSampleMover.CameraIndexSampleMoverDriver cameraIndexSampleMoverDriver) {
        this.mover = cameraIndexSampleMoverDriver;
        this.setTitle("Camera Index Sample Mover");
        this.setPreferredSize(new Dimension(900, 600));
        this.setLayout(new BorderLayout());
        this.trayPanel.setPreferredSize(new Dimension(200, 0));
        this.add((Component)this.trayPanel, "West");
        this.timePanel.setScale(80, 40, 20, 10, 24);
        this.add((Component)this.timePanel, "Center");
        this.startTime = System.currentTimeMillis();
        Breeze.setFrameIcons(this);
        this.poller.scheduleAtFixedRate(this::pollOnce, 200L, 200L, TimeUnit.MILLISECONDS);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                TrayDialog.this.shutdownPoller();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TrayDialog.this.shutdownPoller();
            }
        });
    }

    private void shutdownPoller() {
        this.poller.shutdownNow();
    }

    private void pollOnce() {
        try {
            if (!TcpManager.getInstance().isRuntimeAvailable()) {
                return;
            }
            long l = System.currentTimeMillis() - this.startTime;
            String string = TcpManager.getInstance().getProperty(this.mover.getRemoteMotor(), "MotorStatus", false);
            if (string == null || string.isBlank()) {
                return;
            }
            String[] stringArray = string.split(";");
            if (stringArray.length < 2) {
                return;
            }
            double d = RtDataFormat.toNumberFloat(stringArray[0]);
            StatusList.ServerState serverState = StatusList.ServerState.valueOf(stringArray[1]);
            MoverStatus moverStatus = new MoverStatus(l, d, serverState);
            this.positionsOverTime.add(moverStatus);
            if (this.positionsOverTime.size() > 500000) {
                this.positionsOverTime.subList(0, this.positionsOverTime.size() - 500000).clear();
            }
            SwingUtilities.invokeLater(() -> {
                this.timePanel.updateNow(l, this.mover.maxLength().value);
                this.trayPanel.repaint();
                Rectangle rectangle = this.timePanel.getVisibleRect();
                this.timePanel.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void showDialog(CameraIndexSampleMover.CameraIndexSampleMoverDriver cameraIndexSampleMoverDriver) {
        TrayDialog trayDialog = new TrayDialog(cameraIndexSampleMoverDriver);
        trayDialog.pack();
        trayDialog.setLocationRelativeTo(null);
        trayDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> TrayDialog.showDialog(new CameraIndexSampleMover.CameraIndexSampleMoverDriver(){

            @Override
            public LengthValue maxLength() {
                return new LengthValue(1000.0f);
            }

            @Override
            public float getPosition() {
                return 500.0f;
            }
        }));
    }

    private final class TrayPanel
    extends JPanel {
        private final int cw = 20;
        private final int tw = 80;
        private final int th = 10;

        private TrayPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (TrayDialog.this.positionsOverTime.isEmpty()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                int n;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                MoverStatus moverStatus = TrayDialog.this.positionsOverTime.get(TrayDialog.this.positionsOverTime.size() - 1);
                double d = moverStatus.position;
                double d2 = Math.max((double)TrayDialog.this.mover.maxLength().value * 1.5, d * 1.02);
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                for (n = 0; n <= 10; ++n) {
                    double d3 = (double)n / 10.0;
                    int n4 = (int)Math.round((double)n3 * (1.0 - d3));
                    graphics2D.drawLine(n2 / 2, n4, n2 / 2 + 20, n4);
                    graphics2D.drawString(RtDataFormat.toString(d3 * d2), n2 / 2 + 20 + 5, n4 + fontMetrics.getAscent() / 2);
                }
                graphics2D.setColor(Color.GRAY);
                graphics2D.fillRect(n2 / 2 - 10, 0, 20, n3);
                n = (int)Math.round((double)n3 - d / d2 * (double)n3);
                graphics2D.setColor(moverStatus.state.getColor());
                graphics2D.fillRect(n2 / 2 - 40, n - 5, 80, 10);
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    private final class TimePositionPanel
    extends JPanel {
        private final BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f);
        private int pxPerSec = 80;
        private int left = 40;
        private int right = 20;
        private int top = 10;
        private int bottom = 24;
        private long nowMs = 0L;
        private double cachedMaxLen = 1.0;

        private TimePositionPanel() {
        }

        void setScale(int n, int n2, int n3, int n4, int n5) {
            this.pxPerSec = Math.max(1, n);
            this.left = n2;
            this.right = n3;
            this.top = n4;
            this.bottom = n5;
            this.revalidate();
            this.repaint();
        }

        void updateNow(long l, double d) {
            this.nowMs = Math.max(this.nowMs, l);
            this.cachedMaxLen = Math.max(1.0, d * 1.5);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(600, 400);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (TrayDialog.this.positionsOverTime.isEmpty()) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setStroke(this.stroke);
                int n = this.getWidth();
                int n2 = this.getHeight();
                int n3 = Math.max(1, n - this.left - this.right);
                int n4 = Math.max(1, n2 - this.top - this.bottom);
                graphics2D.setColor(new Color(0, 0, 0, 70));
                graphics2D.drawRect(this.left, this.top, n3, n4);
                long l = (long)Math.floor((double)n3 / (double)this.pxPerSec * 1000.0);
                long l2 = this.nowMs;
                long l3 = Math.max(0L, l2 - l);
                double d = (double)n4 / this.cachedMaxLen;
                double d2 = (double)this.pxPerSec / 1000.0;
                for (int i = Math.max(0, TrayDialog.this.positionsOverTime.size() - 1); i > 0 && TrayDialog.this.positionsOverTime.get((int)(i - 1)).time >= l3; --i) {
                }
                MoverStatus moverStatus = null;
                int n5 = TrayDialog.this.positionsOverTime.size();
                for (int i = i; i < n5; ++i) {
                    MoverStatus moverStatus2 = TrayDialog.this.positionsOverTime.get(i);
                    if (moverStatus2.time > l2) break;
                    int n6 = this.left + (int)Math.round((double)(moverStatus2.time - l3) * d2);
                    int n7 = this.top + (int)Math.round((double)n4 - moverStatus2.position * d);
                    if (moverStatus != null) {
                        int n8 = this.left + (int)Math.round((double)(moverStatus.time - l3) * d2);
                        int n9 = this.top + (int)Math.round((double)n4 - moverStatus.position * d);
                        if (n8 < this.left && n6 < this.left || n8 > this.left + n3 && n6 > this.left + n3) {
                            moverStatus = moverStatus2;
                            continue;
                        }
                        graphics2D.setColor(moverStatus2.state.getColor());
                        graphics2D.drawLine(Math.max(this.left, Math.min(this.left + n3, n8)), Math.max(this.top, Math.min(this.top + n4, n9)), Math.max(this.left, Math.min(this.left + n3, n6)), Math.max(this.top, Math.min(this.top + n4, n7)));
                    }
                    moverStatus = moverStatus2;
                }
                graphics2D.setFont(this.getFont().deriveFont(11.0f));
                graphics2D.setColor(new Color(0, 0, 0, 120));
                String string = String.format("Showing last %.1fs", (double)l / 1000.0);
                graphics2D.drawString(string, this.left, n2 - 6);
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    private static final class MoverStatus {
        final long time;
        final double position;
        final StatusList.ServerState state;

        MoverStatus(long l, double d, StatusList.ServerState serverState) {
            this.time = l;
            this.position = d;
            this.state = serverState;
        }
    }
}

