/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.tray.schneidermotor;

import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettingsPanel;
import se.prediktera.breeze.hardware.tcp.Command;

public abstract class SchneiderMotorTrayRemote
extends RemoteSampleMover<SchneiderMotorTrayRemoteSettings> {
    public SchneiderMotorTrayRemote() {
        super("SchneiderMotorTray");
    }

    @Override
    public JPanel getSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        RemoteSampleMoverSettingsPanel remoteSampleMoverSettingsPanel = new RemoteSampleMoverSettingsPanel(this, settingsPanelCallback, false);
        CollapsePanel collapsePanel = new CollapsePanel("More");
        collapsePanel.addPanelNoFillHorizontal(EntryMainHelper.createTextButton("Reprogram", () -> this.reprogramMotor(breezeFrame, settingsPanelCallback)));
        collapsePanel.addPanel(new BreezeInputField.Number("Tray steps per mm", (double)((SchneiderMotorTrayRemoteSettings)this.getSettings()).trayStepsPerMillimeter(), "steps/mm", textActionEvent -> ((SchneiderMotorTrayRemoteSettings)this.getSettings()).changeTrayStepsPerMillimeter(textActionEvent.getValueInt())));
        CollapsePanel collapsePanel2 = remoteSampleMoverSettingsPanel.addAdvancedAndFill(settingsPanelCallback);
        collapsePanel2.addPanel(collapsePanel);
        return remoteSampleMoverSettingsPanel;
    }

    private void reprogramMotor(final BreezeFrame breezeFrame, final Hardware.SettingsPanelCallback settingsPanelCallback) {
        BreezeProgressDialog.startProgress(breezeFrame, new ProgressAction(this){
            final /* synthetic */ SchneiderMotorTrayRemote this$0;
            {
                this.this$0 = schneiderMotorTrayRemote;
            }

            @Override
            public void runAction() {
                if (this.this$0.isConnected()) {
                    this.this$0.disconnect(this.getProgressManager());
                }
                ((SchneiderMotorTrayRemoteSettings)this.this$0.getSettings()).setReprogram(true);
                this.this$0.connect(this.getProgressManager(), breezeFrame);
                settingsPanelCallback.reloadInformation();
            }
        }, "Reprogramming");
    }

    public static class SchneiderMotorTrayRemoteSettings
    extends RemoteSampleMoverSettings {
        private final int defaultTrayStepsPerMillimeter;
        private final int defaultAcceleration;
        private final int defaultSwitchpolarity;
        private final int defaultMotorRunCurrent = 50;
        private final int defaultMotorHoldingCurrent = 40;
        private boolean reprogram;
        private final int defaultMovementSpeed;

        public SchneiderMotorTrayRemoteSettings(RemoteSampleMover remoteSampleMover, int n, int n2, int n3, int n4) {
            super(remoteSampleMover);
            this.defaultTrayStepsPerMillimeter = n;
            this.defaultAcceleration = n2;
            this.defaultMovementSpeed = n3;
            this.defaultSwitchpolarity = n4;
        }

        @Override
        protected float getDefaultMovementSpeed() {
            return this.defaultMovementSpeed;
        }

        public int acceleration() {
            return BreezeProperties.getInstance().getSampleMoverPropertyInt(this.mover, "acceleration", this.defaultAcceleration);
        }

        public int getIM() {
            return BreezeProperties.getInstance().getSampleMoverPropertyInt(this.mover, "im", -1);
        }

        public int getSwitchPolarity() {
            return BreezeProperties.getInstance().getSampleMoverPropertyInt(this.mover, "switchpolarity", this.defaultSwitchpolarity);
        }

        public int getMotorRunCurrent() {
            return BreezeProperties.getInstance().getSampleMoverPropertyInt(this.mover, "motorRunCurrent", 50);
        }

        public int getMotorHoldingCurrent() {
            return BreezeProperties.getInstance().getSampleMoverPropertyInt(this.mover, "motorHoldingCurrent", 40);
        }

        public int trayStepsPerMillimeter() {
            return BreezeProperties.getInstance().getSampleMoverPropertyInt(this.mover, "trayStepsPerMillimeter", this.defaultTrayStepsPerMillimeter);
        }

        @Override
        public ComPort port() {
            return ComPort.fromXmlValue(BreezeProperties.getInstance().getSampleMoverProperty(this.mover, "port", ComPort.Auto.toXmlValue()));
        }

        @Override
        public void changePort(ComPort comPort) {
            BreezeProperties.getInstance().setSampleMoverProperty(this.mover, "port", comPort.toXmlValue());
        }

        public void changeMaxLength(float f) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(this.mover, "maxLength", f);
        }

        public void changeTrayStepsPerMillimeter(int n) {
            BreezeProperties.getInstance().setSampleMoverPropertyInt(this.mover, "trayStepsPerMillimeter", n);
        }

        public void setReprogram(boolean bl) {
            this.reprogram = bl;
        }

        @Override
        public List<Command.Argument> getArguments() {
            List<Command.Argument> list = super.getArguments();
            list.add(new Command.Argument("Name", (Object)this.getName()));
            list.add(new Command.Argument("TrayStepsPerMillimeter", (Object)this.trayStepsPerMillimeter()));
            list.add(new Command.Argument("SwitchPolarity", (Object)this.getSwitchPolarity()));
            list.add(new Command.Argument("IM", (Object)this.getIM()));
            list.add(new Command.Argument("Acceleration", (Object)this.acceleration()));
            list.add(new Command.Argument("MotorRunCurrent", (Object)this.getMotorRunCurrent()));
            list.add(new Command.Argument("MotorHoldingCurrent", (Object)this.getMotorHoldingCurrent()));
            list.add(new Command.Argument("Reprogram", (Object)this.reprogram));
            this.reprogram = false;
            return list;
        }
    }
}

