/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.umbioinspector;

import java.awt.GridBagLayout;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BreezeInterface;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.frontend.hardware.ComPortComboBox;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.samplemover.RemoteMotor;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.hardware.samplemover.umbioinspector.RemoteCDA3000;
import se.prediktera.breeze.hardware.samplemover.umbioinspector.RemoteCDE3000;
import se.prediktera.breeze.hardware.samplemover.umbioinspector.UmbioInspectorHeight;
import se.prediktera.breeze.hardware.samplemover.umbioinspector.UmbioInspectorWhiteReference;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.NiceDataFormat;

public class UmbioInspector
extends RemoteSampleMover
implements SampleMover.SettingsPanelSampleMover {
    private static final float MIN_HEIGHT = 27.0f;
    private static final float MAX_HEIGHT = 262.0f;
    private final UmbioInspectorWhiteReference whiteReference = new UmbioInspectorWhiteReference();
    private final UmbioInspectorHeight height = new UmbioInspectorHeight();
    private Settings settings;
    private boolean connected;
    private float moveOutLength;

    public UmbioInspector() {
        super("UmBioInspector");
    }

    @Override
    protected RemoteMotor createRemoteMotor(String string) {
        return new RemoteCDE3000();
    }

    public Settings getSettings() {
        if (this.settings == null) {
            this.settings = new Settings(this);
        }
        return this.settings;
    }

    @Override
    public void connect(BreezeProgress breezeProgress, BreezeInterface breezeInterface) {
        TcpManager.OnDisconnectCallback onDisconnectCallback = () -> {
            this.connected = false;
        };
        this.whiteReference.connect(breezeProgress, this.getSettings().referencePort(), onDisconnectCallback, this.getSettings().getReferenceHomingDirection());
        this.height.connect(breezeProgress, this.getSettings().heightPort(), onDisconnectCallback);
        this.remoteMotor = this.getConveyorFromType(this.getSettings().conveyorType());
        this.remoteMotor.connect(breezeProgress, this.getSettings().conveyorPort(), onDisconnectCallback);
        this.connected = true;
    }

    private RemoteMotor getConveyorFromType(String string) {
        if (string.equals("CDE")) {
            return new RemoteCDE3000();
        }
        if (string.equals("CDA")) {
            return new RemoteCDA3000();
        }
        throw new RuntimeException("No such conveyor type : " + string);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void disconnect(BreezeProgressManager breezeProgressManager) {
    }

    @Override
    public boolean inFocusState(Camera camera) {
        return this.whiteReference.isExtended();
    }

    @Override
    public void exitFocusState() {
        this.whiteReference.retract();
    }

    @Override
    public void enterFocusState(Camera camera) {
        this.whiteReference.extend(this.getSettings().referenceLocation());
    }

    @Override
    public boolean hasWhiteRefState() {
        return true;
    }

    @Override
    public boolean inWhiteRefState(Camera camera) {
        return this.whiteReference.isExtended();
    }

    @Override
    public void exitWhiteRefState() {
        this.whiteReference.retract();
    }

    @Override
    public LengthValue whiteRefScanLength() {
        return new LengthValue(0.0f);
    }

    @Override
    public void enterWhiteRefState(Camera camera) {
        this.whiteReference.extend(this.getSettings().referenceLocation());
    }

    @Override
    public void moveToReturnPosition(Camera camera) {
    }

    @Override
    public void moveToScanStartPosition(Camera camera) {
    }

    @Override
    public void runScan(LengthValue lengthValue, SampleMover.ScanMode scanMode, SampleMover.ScanEventListener scanEventListener, Camera camera) {
    }

    public Map<String, String> remoteScan(LengthValue lengthValue, SampleMover.ScanMode scanMode, Camera camera, List list, boolean bl, boolean bl2) {
        this.whiteReference.retract();
        Map<String, String> map = super.remoteScan(lengthValue, scanMode, camera, (List<FrameCount>)list, bl, bl2);
        this.moveOutLength = this.getSettings().endLocation() - this.getSettings().scanStartLocation() - lengthValue.value;
        return map;
    }

    @Override
    public void moveToEndScanPosition() {
        this.remoteMotor.move(this.getSettings().movementSpeed(), this.moveOutLength, RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Absolute);
    }

    @Override
    public void runContinuously(Speed speed) {
        this.whiteReference.retract();
        this.remoteMotor.runContinuously(speed);
    }

    @Override
    public boolean isConveyor() {
        return true;
    }

    @Override
    public boolean isBusy() {
        return super.isBusy() || this.whiteReference.isBusy() || this.height.isBusy();
    }

    public String toString() {
        return "UmBio Inspector";
    }

    @Override
    public String getXmlNodeName() {
        return "UmbioInspector";
    }

    @Override
    public SettingsPanel getSettingsPanel(BreezeFrame breezeFrame, Hardware.SettingsPanelCallback settingsPanelCallback) {
        return new SettingsPanel(breezeFrame);
    }

    @Override
    public Speed movementSpeed() {
        return this.getSettings().movementSpeed();
    }

    @Override
    public Speed maxSpeed() {
        return this.getSettings().maxSpeed();
    }

    @Override
    public ComPort getComPort() {
        return this.getSettings().conveyorPort();
    }

    @Override
    public LengthValue maxLength() {
        return new LengthValue(2.1474836E9f);
    }

    private class Settings
    extends RemoteSampleMoverSettings {
        public Settings(RemoteSampleMover remoteSampleMover) {
            super(remoteSampleMover);
        }

        @Override
        public Speed movementSpeed() {
            return new Speed(BreezeProperties.getInstance().getSampleMoverPropertyFloat(UmbioInspector.this, SampleMover.Property.movementSpeed.name(), 200.0f));
        }

        @Override
        public Speed maxSpeed() {
            return new Speed(BreezeProperties.getInstance().getSampleMoverPropertyFloat(UmbioInspector.this, SampleMover.Property.maximumSpeed.name(), 200.0f));
        }

        public String conveyorType() {
            return BreezeProperties.getInstance().getSampleMoverProperty(UmbioInspector.this, "conveyorType", "CDE");
        }

        public ComPort conveyorPort() {
            return ComPort.fromXmlValue(BreezeProperties.getInstance().getSampleMoverProperty(UmbioInspector.this, "conveyorPort", "COM1"));
        }

        public ComPort heightPort() {
            return ComPort.fromXmlValue(BreezeProperties.getInstance().getSampleMoverProperty(UmbioInspector.this, "heightPort", "COM2"));
        }

        public ComPort referencePort() {
            return ComPort.fromXmlValue(BreezeProperties.getInstance().getSampleMoverProperty(UmbioInspector.this, "referencePort", "COM3"));
        }

        public RemoteMotor.MotorDirection getReferenceHomingDirection() {
            return RemoteMotor.MotorDirection.valueOf(BreezeProperties.getInstance().getSampleMoverProperty(UmbioInspector.this, "referenceHomingDirection", "Reverse"));
        }

        public float referenceLocation() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(UmbioInspector.this, "referenceLocation", 35.0f);
        }

        @Override
        public float scanStartLocation() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(UmbioInspector.this, "startLocation", 120.0f);
        }

        public float endLocation() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(UmbioInspector.this, "endLocation", 800.0f);
        }

        public float getHeight() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(UmbioInspector.this, "height", 40.0f);
        }

        public float getHeightOffset() {
            return BreezeProperties.getInstance().getSampleMoverPropertyFloat(UmbioInspector.this, "heightOffset", 0.0f);
        }

        public void changeConveyorPort(ComPort comPort) {
            BreezeProperties.getInstance().setSampleMoverProperty(UmbioInspector.this, "conveyorPort", comPort.name);
        }

        public void changeHeightPort(ComPort comPort) {
            BreezeProperties.getInstance().setSampleMoverProperty(UmbioInspector.this, "heightPort", comPort.name);
        }

        public void changeWhiteReferencePort(ComPort comPort) {
            BreezeProperties.getInstance().setSampleMoverProperty(UmbioInspector.this, "referencePort", comPort.name);
        }

        @Override
        public void changeFocusLocation(float f) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(UmbioInspector.this, "referenceLocation", f);
        }

        @Override
        public void changeScanStartLocation(float f) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(UmbioInspector.this, "startLocation", f);
        }

        @Override
        public void changeReturnLocation(float f) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(UmbioInspector.this, "endLocation", f);
        }

        public void setHeight(float f) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(UmbioInspector.this, "height", f);
        }

        @Override
        public void changeMovementSpeed(float f) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(UmbioInspector.this, "movementSpeed", f);
        }

        public void changeMaxSpeed(float f) {
            BreezeProperties.getInstance().setSampleMoverPropertyFloat(UmbioInspector.this, SampleMover.Property.maximumSpeed.name(), f);
        }
    }

    public class SettingsPanel
    extends JPanel {
        private final BreezeInputField.Number heightInputField;

        public SettingsPanel(BreezeFrame breezeFrame) {
            this.setLayout(new GridBagLayout());
            this.heightInputField = new BreezeInputField.Number("Height", UmbioInspector.this.getSettings().getHeight(), "mm");
            InputFieldHelper.addPanel(this, this.heightInputField, textActionEvent -> this.setHeight(breezeFrame, (BreezeTextField)textActionEvent.getSource(), textActionEvent.getValueFloat()));
            if (!UmbioInspector.this.isConnected()) {
                this.heightInputField.setEnabled(false);
                this.heightInputField.setDescription("Height (Press Connect to change height)");
                InputFieldHelper.addPanel(this, new ComPortComboBox("Conveyor port", UmbioInspector.this.getSettings().conveyorPort(), false, comPort -> UmbioInspector.this.getSettings().changeConveyorPort((ComPort)comPort)));
                InputFieldHelper.addPanel(this, new ComPortComboBox("Height port", UmbioInspector.this.getSettings().heightPort(), false, comPort -> UmbioInspector.this.getSettings().changeHeightPort((ComPort)comPort)));
                InputFieldHelper.addPanel(this, new ComPortComboBox("Reference port", UmbioInspector.this.getSettings().referencePort(), false, comPort -> UmbioInspector.this.getSettings().changeWhiteReferencePort((ComPort)comPort)));
            }
            CollapsePanel collapsePanel = new CollapsePanel("Advanced");
            collapsePanel.addPanel(new SampleMover.MovementInputField(UmbioInspector.this.getSettings().movementSpeed(), UmbioInspector.this), textActionEvent -> UmbioInspector.this.getSettings().changeMovementSpeed(textActionEvent.getValueFloat()));
            collapsePanel.addPanel(new BreezeInputField.Number("Max speed", NiceDataFormat.toString((double)UmbioInspector.this.getSettings().maxSpeed().value), "mm/s"), textActionEvent -> UmbioInspector.this.getSettings().changeMaxSpeed(textActionEvent.getValueFloat()));
            collapsePanel.addPanel(new BreezeInputField.Number("Reference location", UmbioInspector.this.getSettings().referenceLocation(), "mm"), textActionEvent -> UmbioInspector.this.getSettings().changeFocusLocation(textActionEvent.getValueFloat()));
            collapsePanel.addPanel(new BreezeInputField.Number("Sample start location", UmbioInspector.this.getSettings().scanStartLocation(), "mm"), textActionEvent -> UmbioInspector.this.getSettings().changeScanStartLocation(textActionEvent.getValueFloat()));
            collapsePanel.addPanel(new BreezeInputField.Number("Sample end location", UmbioInspector.this.getSettings().endLocation(), "mm"), textActionEvent -> UmbioInspector.this.getSettings().changeReturnLocation(textActionEvent.getValueFloat()));
            InputFieldHelper.addPanel(this, collapsePanel);
            InputFieldHelper.addBottomFillPanel(this);
            this.setOpaque(false);
        }

        private void setHeight(final BreezeFrame breezeFrame, final BreezeTextField breezeTextField, final float f) {
            BreezeActionListener breezeActionListener = new BreezeActionListener(){
                final /* synthetic */ SettingsPanel this$1;
                {
                    this.this$1 = settingsPanel;
                }

                @Override
                public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    try {
                        this.this$1.changeHeightWithProgress(breezeFrame, f, this.this$1.UmbioInspector.this.getSettings().getHeightOffset());
                    }
                    catch (Exception exception) {
                        BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.ERROR_OPTION, "Cannot change height", exception.getMessage());
                    }
                }

                @Override
                public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    breezeTextField.setFormatedNumber(this.this$1.UmbioInspector.this.getSettings().getHeight());
                }
            };
            SwingUtilities.invokeLater(() -> SettingsPanel.lambda$setHeight$0(breezeFrame, breezeActionListener));
        }

        private void changeHeightWithProgress(BreezeFrame breezeFrame, final float f, final float f2) {
            ProgressAction progressAction = new ProgressAction(this){
                final /* synthetic */ SettingsPanel this$1;
                {
                    this.this$1 = settingsPanel;
                }

                @Override
                public void runAction() throws Exception {
                    float f3 = this.ensureHeightWithinMinMax(f + f2);
                    double d = this.this$1.UmbioInspector.this.height.getCurrentposition();
                    double d2 = 262.0 - d;
                    double d3 = d2 - (double)f3;
                    this.getProgressManager().setInfoText("Changing height to " + NiceDataFormat.toString((double)f3) + " mm" + (String)(f2 > 0.0f ? " (Offset " + f2 + " mm)" : ""));
                    this.this$1.UmbioInspector.this.height.changeRelativePos(d3);
                    this.this$1.UmbioInspector.this.getSettings().setHeight(f3 - f2);
                }

                private float ensureHeightWithinMinMax(float f3) {
                    if (f3 < 27.0f) {
                        return 27.0f;
                    }
                    if (f3 > 262.0f) {
                        return 262.0f;
                    }
                    return f3;
                }
            };
            BreezeProgressDialog.startProgress(breezeFrame, progressAction, "Changing height, please wait");
        }

        public BreezeInputField.Number getHeightField() {
            return this.heightInputField;
        }

        private static /* synthetic */ void lambda$setHeight$0(BreezeFrame breezeFrame, 1 var1_1) {
            double d = BreezeProperties.getInstance().getUmbioInspectorMaximumHeight();
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Warning, the instrument will move.", "The camera is about to move vertically\n\nEnsure that there is sufficient room above the camera for it to extend to a height of approximately " + NiceDataFormat.toString((double)d) + " millimeter.\n\nKeep any hands or other objects outside of the camera cage.", null, var1_1);
        }
    }
}

