/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.umbioinspector;

import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.hardware.samplemover.RemoteMotor;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class UmbioInspectorHeight {
    private final RemoteMotor motor = new RemoteMotor("UmbioInspectorHeightMotor");
    private boolean homing = false;
    private double currentposition = 0.0;

    public void connect(BreezeProgress breezeProgress, ComPort comPort, TcpManager.OnDisconnectCallback onDisconnectCallback) {
        this.motor.connect(breezeProgress, comPort, onDisconnectCallback);
    }

    public void changeRelativePos(double d) {
        RemoteMotor.MotorDirection motorDirection;
        double d2 = Math.abs(d);
        RemoteMotor.MotorDirection motorDirection2 = motorDirection = d > 0.0 ? RemoteMotor.MotorDirection.Forward : RemoteMotor.MotorDirection.Reverse;
        if (!this.homing) {
            this.motor.move(new Speed(5.0f), 5.0, RemoteMotor.MotorDirection.Reverse, RemoteMotor.MotorDriveMode.Homing);
            this.currentposition = 0.0;
            this.homing = true;
        }
        this.motor.move(new Speed(50.0f), d2, motorDirection, RemoteMotor.MotorDriveMode.Relative);
        this.currentposition = motorDirection == RemoteMotor.MotorDirection.Forward ? (this.currentposition += d2) : (this.currentposition -= d2);
    }

    public double getCurrentposition() {
        return this.currentposition;
    }

    public boolean isBusy() {
        return this.motor.isBusy();
    }
}

