/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.samplemover.umbioinspector;

import java.util.ArrayList;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.hardware.samplemover.RemoteMotor;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class UmbioInspectorWhiteReference {
    private RemoteMotor.MotorDirection homingDirection;
    private final RemoteMotor motor = new RemoteMotor("UmbioInspectorWhiteRefMotor");
    private boolean extended = false;

    public void connect(BreezeProgress breezeProgress, ComPort comPort, TcpManager.OnDisconnectCallback onDisconnectCallback, RemoteMotor.MotorDirection motorDirection) {
        this.homingDirection = motorDirection;
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("Direction", motorDirection));
        this.motor.connect(breezeProgress, comPort, onDisconnectCallback, arrayList);
        this.homeMotor();
    }

    public void extend(double d) {
        this.homeMotor();
        this.motor.move(new Speed(5.0f), d, RemoteMotor.MotorDirection.Forward, RemoteMotor.MotorDriveMode.Relative);
        this.extended = true;
    }

    public void retract() {
        this.homeMotor();
    }

    private void homeMotor() {
        this.motor.move(new Speed(5.0f), 5.0, this.homingDirection, RemoteMotor.MotorDriveMode.Homing);
        this.extended = false;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isBusy() {
        return this.motor.isBusy();
    }
}

