/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.tcp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;
import se.prediktera.breeze.common.util.UniqueUID;

public class Command {
    private final String commandName;
    private final String id;
    private final List<Argument> arguments = new ArrayList<Argument>();

    public Command(String string, Argument ... argumentArray) {
        this(string, UniqueUID.getUniqueId(), argumentArray);
    }

    public Command(String string, String string2, Argument ... argumentArray) {
        this.commandName = string;
        this.id = string2;
        for (Argument argument : argumentArray) {
            this.addArgument(argument);
        }
    }

    public Command(String string, List<Argument> list) {
        this(string, UniqueUID.getUniqueId(), list);
    }

    public Command(String string, String string2, List<Argument> list) {
        this.commandName = string;
        this.id = string2;
        for (Argument argument : list) {
            this.addArgument(argument);
        }
    }

    public String getId() {
        return this.id;
    }

    public void addArgument(Argument argument) {
        this.arguments.add(argument);
    }

    public String toJsonString() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("Command", (Object)this.commandName);
        jSONObject.put("Id", (Object)this.id);
        for (Argument argument : this.arguments) {
            jSONObject.put(argument.argument, argument.value);
        }
        return jSONObject.toString();
    }

    public String toString() {
        return String.format("%s %s", this.commandName, this.getArguments());
    }

    public boolean equals(Object object) {
        Command command = (Command)object;
        if (command.commandName.equals(this.commandName) && command.arguments.size() == this.arguments.size()) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (this.arguments.get(i).equals(command.arguments.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getArguments() {
        return String.join((CharSequence)" ", this.arguments.stream().map(Argument::toString).collect(Collectors.toList()));
    }

    public static class Argument {
        private final String argument;
        private final Object value;

        public Argument(String string, File file) {
            this(string, (Object)(file != null ? file.getAbsolutePath() : null));
        }

        public Argument(Enum enum_, Object object) {
            this(enum_.name(), object);
        }

        public Argument(String string, Enum enum_) {
            this(string, (Object)enum_.name());
        }

        public Argument(String string, Object object) {
            this.argument = string;
            this.value = object;
        }

        public String getArgument() {
            return this.argument;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            Argument argument = (Argument)object;
            return argument.argument.equals(this.argument) && argument.value.equals(this.value);
        }

        public String toString() {
            return String.format("%s=%s", this.argument, this.value);
        }
    }

    public static class ArgumentList
    implements Iterable<Argument> {
        private final List<Argument> list = new ArrayList<Argument>();

        public ArgumentList(Argument ... argumentArray) {
            Collections.addAll(this.list, argumentArray);
        }

        @Override
        public Iterator<Argument> iterator() {
            return this.list.iterator();
        }

        public void add(Argument argument) {
            this.list.add(argument);
        }
    }
}

