/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.tcp;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.MatcherAssert;
import org.json.JSONObject;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.CommandReply;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.JSONObjectWith;

public class FakeTcpManager
extends TcpManager {
    private final HashMap<String, String> latestPropertySetValue = new HashMap();
    private final BufferedTcpStream tcpStreamManager;
    private String lastMissingPixelsFilePath;
    private boolean startCaptureSent;

    public FakeTcpManager(BufferedTcpStream bufferedTcpStream) {
        this.tcpStreamManager = bufferedTcpStream;
    }

    public FakeTcpManager() {
        this((BufferedTcpStream)null);
    }

    @Override
    public void initializeCamera(BreezeProgress breezeProgress, RemoteCamera<?> remoteCamera, CameraType cameraType, List<Command.Argument> list, TcpManager.OnDisconnectCallback onDisconnectCallback) {
        if (!list.isEmpty() && list.getLast().getValue() instanceof String) {
            this.lastMissingPixelsFilePath = (String)list.getLast().getValue();
        }
    }

    @Override
    public CommandReply startCapture(int n, FrameCount frameCount, File file, boolean bl) {
        this.startCaptureSent = true;
        return new CommandReply(new JSONObject());
    }

    @Override
    public void stopCapture(int n) {
    }

    @Override
    public String getCameraProperty(Camera camera, String string) {
        return "-9999999";
    }

    @Override
    public CommandReply setCameraProperty(Camera camera, String string, String string2) {
        this.latestPropertySetValue.put(string, string2);
        return new CommandReply(new JSONObjectWith("Message", string2));
    }

    public String lastCameraProperty(String string) {
        return this.latestPropertySetValue.get(string);
    }

    @Override
    public CameraType.CameraTypeList getCameraTypes(Camera camera, List<Command.Argument> list) {
        return new CameraType.CameraTypeList(List.of("SspFileA"));
    }

    public BufferedTcpStream connectCameraBitStream(DataSize dataSize, BandCount bandCount, PixelWidth pixelWidth, RtInterleave rtInterleave, boolean bl) {
        return this.tcpStreamManager;
    }

    public void assertStartCaptureSent() {
        MatcherAssert.assertThat((String)"start capture has been sent", (boolean)this.startCaptureSent);
    }

    public String lastInitializeRedEyeMissingPixelsFilePath() {
        return this.lastMissingPixelsFilePath;
    }
}

