/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.hardware.tcp;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.thread.BreezeThread;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.entry.analyse.model.AbstractRuntimeModel;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.application.status.StatusList;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportDataHelper;
import se.prediktera.breeze.frontend.common.swing.WaitCursor;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.hardware.ComPort;
import se.prediktera.breeze.frontend.hardware.ConnectProgressAction;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.CameraMode;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.camera.RemoteCamera;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RuntimeEvent;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeConnection;
import se.prediktera.breeze.hardware.samplemover.RemoteMotor;
import se.prediktera.breeze.hardware.tcp.BreezeRuntime;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.CommandReply;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.LogExtraExceptionInterface;
import se.prediktera.map.common.error.Logg;

public class TcpManager {
    private static TcpManager instance = null;
    private static final String MESSAGE_CAMERA_IS_NOT_CAPTURING = "Camera is not capturing";
    private final RemoteDeviceRegistry deviceRegistry = new RemoteDeviceRegistry();
    private BreezeRuntime remoteConnection;
    private ReplyListener replyListener;
    private EventListener eventListener;
    private CommandCallback commandCallback;
    private RuntimeEventListener listener;
    private BreezeProgress pManager;
    private int progressGroupIndex;
    private final HashMap<String, HashMap<String, String>> mlMethods = new HashMap();

    public static synchronized TcpManager getInstance() {
        if (instance == null) {
            instance = new TcpManager();
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            instance.disconnect();
        }
        instance = null;
    }

    public List<ComPort> getComPorts() {
        String string = this.sendCommandThrowIfFail(new Command("GetComPorts", new Command.Argument[0]), new Time.Seconds(30.0)).getMessage();
        return Arrays.stream(string.split(";")).map(ComPort::new).collect(Collectors.toList());
    }

    public DataSettings getDataSettingsForProperty(String string, int n) {
        CommandReply commandReply = this.sendCommand(new Command("GetPropertyDataSettings", new Command.Argument("Name", (Object)string), new Command.Argument("CameraId", (Object)n)));
        String[] stringArray = commandReply.getMessage().split(";");
        if (stringArray.length == 4) {
            return new DataSettings(Boolean.parseBoolean(stringArray[0]), Float.valueOf(RtDataFormat.toNumberFloat(stringArray[1])), Float.valueOf(RtDataFormat.toNumberFloat(stringArray[2])), Float.valueOf(RtDataFormat.toNumberFloat(stringArray[3])));
        }
        return new DataSettings(false, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    public TcpManager() {
    }

    public TcpManager(BreezeRuntime breezeRuntime) {
        this.remoteConnection = breezeRuntime;
    }

    public void setListener(RuntimeEventListener runtimeEventListener) {
        this.listener = runtimeEventListener;
    }

    public void sendEventToAllListeners(RuntimeEvent runtimeEvent) {
        if (runtimeEvent.isProgress()) {
            if (this.pManager != null) {
                if (runtimeEvent.getCode() == 5000) {
                    this.pManager.incStep(Integer.parseInt(runtimeEvent.getMessage()));
                } else if (runtimeEvent.getCode() == 5001) {
                    this.pManager.incStepGroup(this.progressGroupIndex);
                } else if (runtimeEvent.getCode() == 5002) {
                    this.pManager.setInfoText(runtimeEvent.getMessage());
                } else if (runtimeEvent.getCode() == 5003) {
                    this.pManager.setMaximumAndReset(Integer.parseInt(runtimeEvent.getMessage()));
                } else if (runtimeEvent.getCode() == 5004) {
                    this.pManager.setIndeterminate(true);
                } else if (runtimeEvent.getCode() == 5006) {
                    this.pManager.setComplete();
                }
            }
        } else if (this.listener != null) {
            this.listener.onEvent(runtimeEvent);
        } else {
            Logg.trace((String)"Got Event {}", (Object[])new Object[]{runtimeEvent});
        }
    }

    public void setProgressManager(BreezeProgress breezeProgress) {
        this.pManager = breezeProgress;
    }

    public void setBreezeRuntimeManager(BreezeRuntime breezeRuntime) {
        this.remoteConnection = breezeRuntime;
    }

    public BreezeRuntime getBreezeRuntimeManager() {
        return this.remoteConnection;
    }

    public boolean isRuntimeAvailable() {
        return this.getRemoteConnection() != null;
    }

    private synchronized BreezeRuntime getRemoteConnection() {
        if (this.remoteConnection != null) {
            if (this.replyListener == null) {
                this.replyListener = new ReplyListener(this.remoteConnection, this.deviceRegistry::signalDisconnect);
                this.replyListener.start();
            }
            if (this.eventListener == null) {
                this.eventListener = new EventListener(this.remoteConnection);
                this.eventListener.start();
            }
            this.eventListener.checkForTimeout();
        }
        return this.remoteConnection;
    }

    public void setCommandCallback(CommandCallback commandCallback) {
        this.commandCallback = commandCallback;
    }

    public void initializeCamera(BreezeProgress breezeProgress, RemoteCamera<?> remoteCamera, CameraType cameraType, List<Command.Argument> list, OnDisconnectCallback onDisconnectCallback) {
        this.initializeCamera(breezeProgress, remoteCamera, cameraType, list, onDisconnectCallback, new Time.Minutes(5.0));
    }

    private void initializeCamera(BreezeProgress breezeProgress, RemoteCamera<?> remoteCamera, CameraType cameraType, List<Command.Argument> list, OnDisconnectCallback onDisconnectCallback, Time time) {
        breezeProgress.setInfoText("Please wait: Connecting to " + ConnectProgressAction.getHardwareName(remoteCamera));
        Command command = new Command("InitializeCamera", new Command.Argument("DeviceName", (Object)remoteCamera.getDeviceName()), new Command.Argument("CameraId", (Object)remoteCamera.getId()), new Command.Argument("CameraType", (Object)cameraType.getName()), new Command.Argument("RequestedPort", (Object)BreezeProperties.getInstance().getDataStreamPort()));
        if (remoteCamera.getId() == 1) {
            command.addArgument(new Command.Argument("CameraMode", BreezeProperties.getInstance().getMultiCameraSetting().mode()));
        }
        for (Command.Argument argument : list) {
            command.addArgument(argument);
        }
        CommandReply commandReply = this.sendCommand(breezeProgress, command, time);
        if (!commandReply.hasSucceded()) {
            throw Camera.FailedToConnectException.create(remoteCamera, commandReply);
        }
        BreezeProperties.getInstance().setSelectedCamera(remoteCamera.getId(), remoteCamera);
        this.deviceRegistry.putCamera(remoteCamera, onDisconnectCallback);
    }

    public StatusList.CameraStatus checkStatusAndInitializeRemoteCamera(BreezeProgress breezeProgress, int n) {
        StatusList statusList = this.getStatus(n);
        RemoteCamera<?> remoteCamera = statusList.hasInitiatedCamera() ? this.registerCamera(statusList.getCameraName(), n) : this.initializeRemoteCamera(breezeProgress, n);
        return new StatusList.CameraStatus(remoteCamera, statusList);
    }

    public RemoteCamera<?> initializeRemoteCamera(BreezeProgress breezeProgress, int n) {
        breezeProgress.setInfoText("Please wait: Connecting to remote camera");
        CommandReply commandReply = this.sendCommand(breezeProgress, new Command("InitializeCamera", new Command.Argument("CameraId", (Object)n)), new Time.Minutes(5.0));
        if (!commandReply.hasSucceded()) {
            throw Camera.FailedToConnectException.create(null, commandReply);
        }
        JSONObject jSONObject = new JSONObject(commandReply.getMessage());
        return this.registerCamera(jSONObject.getString("DeviceName"), n);
    }

    public RemoteCamera<?> registerCamera(String string, int n) {
        RemoteCamera remoteCamera = (RemoteCamera)HardwareRegistry.getInstance().getCameraList(n).getByDeviceName(string);
        this.deviceRegistry.putCamera(remoteCamera, () -> remoteCamera.setConnected(false));
        HardwareRegistry.getInstance().setRemoteCamera(remoteCamera, n);
        remoteCamera.setConnected(true);
        return remoteCamera;
    }

    public CommandReply startCapture(int n, FrameCount frameCount, File file, boolean bl) {
        Command command = new Command("StartCapture", new Command.Argument("CameraId", (Object)n), new Command.Argument("NumberOfFrames", (Object)frameCount), new Command.Argument("CaptureAsRgb", (Object)bl));
        if (file != null) {
            command.addArgument(new Command.Argument("Folder", file));
        }
        return this.sendCommandThrowIfFail(command);
    }

    public void stopCapture(int n) {
        String string;
        Command command = new Command("StopCapture", new Command.Argument("CameraId", (Object)n));
        CommandReply commandReply = this.sendCommand(command);
        if (!commandReply.hasSucceded() && !(string = commandReply.getMessage()).equals(MESSAGE_CAMERA_IS_NOT_CAPTURING)) {
            throw CommandErrorException.create(command, commandReply);
        }
    }

    public void openShutter(int n) {
        this.sendCommandThrowIfFail(new Command("OpenShutter", new Command.Argument("CameraId", (Object)n)));
    }

    public void closeShutter(int n) {
        this.sendCommandThrowIfFail(new Command("CloseShutter", new Command.Argument("CameraId", (Object)n)));
    }

    public CommandReply setCameraProperty(Camera camera, String string, int n) {
        return this.setCameraProperty(camera, string, String.valueOf(n));
    }

    public CommandReply setCameraProperty(Camera camera, String string, double d) {
        return this.setCameraProperty(camera, string, String.valueOf(d));
    }

    public CommandReply setCameraProperty(Camera camera, String string, String string2) {
        if (!camera.isConnected()) {
            throw new RuntimeException(String.format("Cannot set property '%s' because camera '%s' is not connected: ", string, camera.getDisplayName()));
        }
        try (WaitCursor waitCursor = new WaitCursor();){
            CommandReply commandReply = this.sendCommandThrowIfFail(new Command("SetCameraProperty", new Command.Argument("CameraId", (Object)camera.getId()), new Command.Argument("Name", (Object)string), new Command.Argument("Value", (Object)string2)), this.getDefaultLongerTimeout());
            return commandReply;
        }
    }

    public String getCameraProperty(Camera camera, String string) {
        if (!camera.isConnected()) {
            throw new RuntimeException(String.format("Cannot get property '%s' because camera '%s' is not connected: ", string, camera.getDisplayName()));
        }
        return this.sendCommandThrowIfFail(new Command("GetCameraProperty", new Command.Argument("CameraId", (Object)camera.getId()), new Command.Argument("Property", (Object)string))).getMessage();
    }

    public CameraType.CameraTypeList getCameraTypes(Camera camera, List<Command.Argument> list) {
        String string;
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("DeviceName", (Object)camera.getDeviceName()));
        arrayList.add(new Command.Argument("CameraId", (Object)camera.getId()));
        if (list != null) {
            arrayList.addAll(list);
        }
        return new CameraType.CameraTypeList((string = this.sendCommandThrowIfFail(new Command("GetCameraTypes", arrayList), new Time.Seconds(120.0)).getMessage()).isBlank() ? new ArrayList(0) : Arrays.asList(string.split(";")));
    }

    public CameraMode.CameraModeList getCameraModes(Camera camera, CameraType cameraType, List<Command.Argument> list) {
        String string;
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("DeviceName", (Object)camera.getDeviceName()));
        arrayList.add(new Command.Argument("CameraId", (Object)camera.getId()));
        arrayList.add(new Command.Argument("CameraType", (Object)cameraType.getName()));
        if (list != null) {
            arrayList.addAll(list);
        }
        return new CameraMode.CameraModeList((string = this.sendCommandThrowIfFail(new Command("GetCameraModes", arrayList), new Time.Seconds(120.0)).getMessage()).isBlank() ? new ArrayList(0) : Arrays.asList(string.split(";")));
    }

    public void preCaptureWarmup() {
        this.sendCommandThrowIfFail(new Command("PreCaptureWarmup", new Command.Argument[0]));
    }

    public CommandReply sendEvent(String string, String string2, int n) {
        return this.sendCommandThrowIfFail(new Command("SendEvent", new Command.Argument("Name", (Object)string), new Command.Argument("Message", (Object)string2), new Command.Argument("Code", (Object)n)));
    }

    public void disconnect(BreezeProgressManager breezeProgressManager, Camera camera) {
        if (this.remoteConnection != null && this.remoteConnection.isAnyBreezeRuntimeRunning()) {
            breezeProgressManager.setInfoText("Please wait: Disconnecting " + ConnectProgressAction.getHardwareName(camera));
            CommandReply commandReply = this.sendCommand(breezeProgressManager, new Command("DisconnectCamera", new Command.Argument("CameraId", (Object)camera.getId())), this.getDefaultLongerTimeout());
            if (!commandReply.hasSucceded()) {
                ErrorHandler.logAndReportException((Throwable)new RuntimeException(String.format("Error disconnecting camera, Breeze Runtime message was: %s", commandReply.getMessage())));
            }
        }
        this.deviceRegistry.remove(camera);
    }

    public void initialize(int n, int n2) {
        this.sendCommandThrowIfFail(new Command("Initialize", new Command.Argument("Tries", (Object)n), new Command.Argument("TimeBetweenTrialSec", (Object)n2)));
    }

    public void initializeMotor(BreezeProgress breezeProgress, RemoteMotor remoteMotor, String string, ComPort comPort, OnDisconnectCallback onDisconnectCallback, List<Command.Argument> list) {
        breezeProgress.setInfoText("Please wait: Connecting to " + remoteMotor.toString());
        Command command = new Command("InitializeMotor", new Command.Argument("DeviceName", (Object)string), comPort.toCommandArgument());
        for (Command.Argument argument : list) {
            command.addArgument(argument);
        }
        CommandReply commandReply = this.sendCommand(breezeProgress, command, Time.Forever);
        if (!commandReply.hasSucceded()) {
            throw Camera.FailedToConnectException.create(remoteMotor, commandReply);
        }
        this.deviceRegistry.put(remoteMotor, commandReply.getMessage(), onDisconnectCallback);
    }

    public CommandReply setMotorProperty(RemoteMotor remoteMotor, String string, String string2) {
        return this.sendCommandThrowIfFail(new Command("SetMotorProperty", new Command.Argument("MotorId", (Object)this.deviceRegistry.getDeviceId(remoteMotor)), new Command.Argument(string, (Object)string2)));
    }

    public String getMotorProperty(RemoteMotor remoteMotor, String string, boolean bl) {
        Command command = new Command("GetMotorProperty", new Command.Argument("MotorId", (Object)this.deviceRegistry.getDeviceId(remoteMotor)), new Command.Argument("Property", (Object)string));
        if (!bl) {
            command.addArgument(new Command.Argument("Log", (Object)false));
        }
        return this.sendCommandThrowIfFail(command).getMessage();
    }

    public CommandReply move(RemoteMotor remoteMotor, Speed speed, double d, RemoteMotor.MotorDirection motorDirection, RemoteMotor.MotorDriveMode motorDriveMode, Time time) {
        return this.sendCommandThrowIfFail(new Command("Move", new Command.Argument("MotorId", (Object)this.deviceRegistry.getDeviceId(remoteMotor)), new Command.Argument("Speed", (Object)Float.valueOf(speed.value)), new Command.Argument("Destination", (Object)d), new Command.Argument("Direction", (Object)motorDirection.toString()), new Command.Argument("DriveMode", (Object)motorDriveMode.toString()), new Command.Argument("Timeout", (Object)Float.valueOf(time.toSeconds()))), time);
    }

    public CommandReply scan(BreezeProgress breezeProgress, Camera camera, RemoteMotor remoteMotor, SampleMover.ScanMode scanMode, Speed speed, Speed speed2, Speed speed3, LengthValue lengthValue, LengthValue lengthValue2, List<FrameCount> list, boolean bl, Time time) {
        Command command = new Command("Scan", new Command.Argument("MotorId", (Object)this.deviceRegistry.getDeviceId(remoteMotor)), new Command.Argument("Mode", scanMode), new Command.Argument("Speed", (Object)Float.valueOf(speed.value)), new Command.Argument("MovementSpeed", (Object)Float.valueOf(speed2.value)), new Command.Argument("MaxSpeed", (Object)Float.valueOf(speed3.value)), new Command.Argument("StartLocation", (Object)Float.valueOf(lengthValue.value)), new Command.Argument("Length", (Object)Float.valueOf(lengthValue2.value)), new Command.Argument("CameraId", (Object)camera.getId()), new Command.Argument("FrameCounts", (Object)FrameCount.toArgument(list)), new Command.Argument("IncludeObjectShape", (Object)bl), new Command.Argument("Timeout", (Object)Float.valueOf(time.toSeconds())));
        return this.sendCommandThrowIfFail(breezeProgress, command, time);
    }

    public CommandReply stop(RemoteMotor remoteMotor) {
        return this.sendCommandThrowIfFail(new Command("Stop", new Command.Argument("MotorId", (Object)this.deviceRegistry.getDeviceId(remoteMotor))));
    }

    public void disconnect(RemoteMotor remoteMotor) {
        try {
            this.sendCommandThrowIfFail(new Command("DisconnectMotor", new Command.Argument("MotorId", (Object)this.deviceRegistry.getDeviceId(remoteMotor))));
        }
        finally {
            this.deviceRegistry.remove(remoteMotor);
        }
    }

    public List<RuntimeWorkflow> getWorkflows() {
        ArrayList<RuntimeWorkflow> arrayList = new ArrayList<RuntimeWorkflow>();
        Command command = new Command("GetWorkflows", new Command.Argument[0]);
        for (Object e : new JSONArray(this.sendCommandThrowIfFail(command).getMessage())) {
            arrayList.add(RuntimeWorkflow.fromJSONworkflow((JSONObject)e));
        }
        return arrayList;
    }

    public RuntimeWorkflow loadWorkflow(RuntimeWorkflow runtimeWorkflow, Camera camera) {
        return this.loadWorkflow(runtimeWorkflow, camera.getFieldOfView(), camera.useReferencesWhenRecordingWithThisCamera(), camera.getId());
    }

    public RuntimeWorkflow loadWorkflow(RuntimeWorkflow runtimeWorkflow, FieldOfView fieldOfView, boolean bl) {
        return this.loadWorkflow(runtimeWorkflow, fieldOfView, bl, 0);
    }

    public RuntimeWorkflow loadWorkflow(RuntimeWorkflow runtimeWorkflow, FieldOfView fieldOfView, boolean bl, int n) {
        Command.Argument argument = runtimeWorkflow.getXml() != null ? new Command.Argument("FilePath", runtimeWorkflow.getXml().getAbsoluteFile()) : new Command.Argument("WorkflowId", (Object)runtimeWorkflow.getUid());
        return RuntimeWorkflow.fromJSON(this.sendCommandThrowIfFail(new Command("LoadWorkflow", argument, new Command.Argument("FieldOfView", (Object)Float.valueOf(fieldOfView.value)), new Command.Argument("UseReferences", (Object)bl), new Command.Argument("CameraId", (Object)n))).getMessage());
    }

    public RuntimeWorkflow loadWorkflow(BreezeProgressManager breezeProgressManager, File file, Camera camera, boolean bl, RtFramePredictor.ReferenceType referenceType, File file2, String string, boolean bl2, List<FrameCount> list, boolean bl3, String string2, int n, boolean bl4, Camera.MultiCameraMode multiCameraMode) {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        if (file2 != null) {
            arrayList.add(new Command.Argument("GroupFolder", file2));
            arrayList.add(new Command.Argument("SaveData", (Object)bl2));
            arrayList.add(new Command.Argument("FrameCounts", (Object)FrameCount.toArgument(list)));
            arrayList.add(new Command.Argument("Crop", (Object)bl3));
            if (string != null) {
                arrayList.add(new Command.Argument("MeasurementName", (Object)string));
            }
        }
        arrayList.add(new Command.Argument("Source", (Object)"Breeze"));
        arrayList.add(new Command.Argument("FilePath", file));
        arrayList.add(new Command.Argument("CameraId", (Object)camera.getId()));
        arrayList.add(new Command.Argument("FieldOfView", (Object)Float.valueOf(camera.getFieldOfView().value)));
        arrayList.add(new Command.Argument("UseReferences", (Object)bl));
        arrayList.add(new Command.Argument("ReferenceType", (Object)referenceType.name()));
        arrayList.add(new Command.Argument("User", (Object)string2));
        arrayList.add(new Command.Argument("Chunks", (Object)n));
        arrayList.add(new Command.Argument("ForceMeasurementEnd", (Object)bl4));
        arrayList.add(new Command.Argument("MultiCameraMode", (Object)multiCameraMode.name()));
        return RuntimeWorkflow.fromJSON(this.sendCommandThrowIfFail(breezeProgressManager, new Command("LoadWorkflow", arrayList), this.getDefaultLongerTimeout()).getMessage());
    }

    public CommandReply deleteWorkflow(String string) {
        return this.sendCommandThrowIfFail(new Command("DeleteWorkflow", new Command.Argument("WorkflowId", (Object)string)), this.getDefaultLongerTimeout());
    }

    public RuntimeWorkflow getWorkflowSetup() {
        return RuntimeWorkflow.fromJSON(this.sendCommandThrowIfFail(new Command("GetWorkflowSetup", new Command.Argument[0])).getMessage());
    }

    public ReferenceStatus takeDarkReference() {
        return this.takeDarkReference(null, 0);
    }

    public ReferenceStatus takeDarkReference(BreezeProgress breezeProgress, int n) {
        return this.takeDarkReference(breezeProgress, true, null, null, n, null, null);
    }

    public ReferenceStatus takeDarkReference(BreezeProgress breezeProgress, ReferenceAction referenceAction, int n) {
        return this.takeDarkReference(breezeProgress, true, referenceAction, null, n, null, null);
    }

    public ReferenceStatus takeDarkReference(BreezeProgress breezeProgress, boolean bl, ReferenceAction referenceAction, String string, int n) {
        return this.takeDarkReference(breezeProgress, bl, referenceAction, string, n, null, null);
    }

    public ReferenceStatus takeDarkReference(BreezeProgress breezeProgress, boolean bl, ReferenceAction referenceAction, String string, int n, IntegrationTime integrationTime, MaxSignal maxSignal) {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("AutoChangeState", (Object)bl));
        arrayList.add(new Command.Argument("CameraId", (Object)n));
        if (breezeProgress != null) {
            arrayList.add(new Command.Argument("Progress", (Object)true));
        }
        if (referenceAction != null) {
            arrayList.add(new Command.Argument("Action", referenceAction));
        }
        if (string != null) {
            arrayList.add(new Command.Argument("ReferencePath", (Object)string));
        }
        if (integrationTime != null) {
            arrayList.add(new Command.Argument("IntegrationTime", (Object)Float.valueOf(integrationTime.value)));
        }
        if (maxSignal != null) {
            arrayList.add(new Command.Argument("MaxSignal", (Object)Float.valueOf(maxSignal.value)));
        }
        return ReferenceStatus.parse(this.sendCommandThrowIfFail(breezeProgress, new Command("TakeDarkReference", arrayList), new Time.Minutes(5.0)).getMessage(), false);
    }

    public ReferenceStatus takeWhiteReference() {
        return this.takeWhiteReference(0);
    }

    public ReferenceStatus takeWhiteReference(int n) {
        return this.takeWhiteReference(null, n);
    }

    public ReferenceStatus takeWhiteReference(BreezeProgress breezeProgress, int n) {
        return this.takeWhiteReference(breezeProgress, null, null, n, null, null);
    }

    public ReferenceStatus takeWhiteReference(BreezeProgress breezeProgress, ReferenceAction referenceAction, int n) {
        return this.takeWhiteReference(breezeProgress, referenceAction, null, n, null, null);
    }

    public ReferenceStatus takeWhiteReference(BreezeProgress breezeProgress, ReferenceAction referenceAction, String string, int n) {
        return this.takeWhiteReference(breezeProgress, referenceAction, string, n, null, null);
    }

    public ReferenceStatus takeWhiteReference(BreezeProgress breezeProgress, ReferenceAction referenceAction, String string, int n, IntegrationTime integrationTime, MaxSignal maxSignal) {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("CameraId", (Object)n));
        if (breezeProgress != null) {
            arrayList.add(new Command.Argument("Progress", (Object)true));
        }
        if (referenceAction != null) {
            arrayList.add(new Command.Argument("Action", referenceAction));
        }
        if (string != null) {
            arrayList.add(new Command.Argument("ReferencePath", (Object)string));
        }
        if (integrationTime != null) {
            arrayList.add(new Command.Argument("IntegrationTime", (Object)Float.valueOf(integrationTime.value)));
        }
        if (maxSignal != null) {
            arrayList.add(new Command.Argument("MaxSignal", (Object)Float.valueOf(maxSignal.value)));
        }
        return ReferenceStatus.parse(this.sendCommandThrowIfFail(breezeProgress, new Command("TakeWhiteReference", arrayList), new Time.Minutes(5.0)).getMessage(), true);
    }

    public void startPredict(FrameCount frameCount, boolean bl) {
        this.startPredict(Arrays.asList(frameCount), bl);
    }

    public void startPredict(List<FrameCount> list, boolean bl) {
        ArrayList<Command.Argument> arrayList = new ArrayList<Command.Argument>();
        arrayList.add(new Command.Argument("FrameCounts", (Object)FrameCount.toArgument(list)));
        arrayList.add(new Command.Argument("SendPredictionLines", (Object)true));
        arrayList.add(new Command.Argument("SendPredictionObjects", (Object)true));
        arrayList.add(new Command.Argument("IncludeObjectShape", (Object)bl));
        this.sendCommandThrowIfFail(new Command("StartPredict", arrayList));
    }

    public void stopPredict(BreezeProgressManager breezeProgressManager) {
        this.sendCommandThrowIfFail(breezeProgressManager, new Command("StopPredict", new Command.Argument[0]), this.getDefaultLongerTimeout());
    }

    public StatusList getStatus() {
        return this.getStatus(0);
    }

    public StatusList getStatus(int n) {
        return new StatusList(this.sendCommandThrowIfFail(new Command("GetStatus", new Command.Argument("CameraId", (Object)n), new Command.Argument("Log", (Object)false)), this.getDefaultLongerTimeout()).getMessage());
    }

    public void measurementSettingsChanged() {
        this.setProperty("MeasurementSettingsChanged", "");
    }

    public CommandReply setProperty(String string, double d) {
        return this.setProperty(string, String.valueOf(d));
    }

    public CommandReply setProperty(String string, String string2) {
        return this.sendCommandThrowIfFail(new Command("SetProperty", new Command.Argument(string, (Object)string2)), this.getDefaultLongerTimeout());
    }

    public CommandReply setProperty(String string, String string2, int n) {
        return this.sendCommandThrowIfFail(new Command("SetProperty", new Command.Argument(string, (Object)string2), new Command.Argument("CameraId", (Object)n)), this.getDefaultLongerTimeout());
    }

    public CommandReply setProperty(String string, String string2, String string3) {
        return this.sendCommandThrowIfFail(new Command("SetProperty", new Command.Argument("NodeId", (Object)string), new Command.Argument(string2, (Object)string3)), this.getDefaultLongerTimeout());
    }

    public CommandReply setPropertyKeyValue(String string, String string2, String string3) {
        return this.sendCommandThrowIfFail(new Command("SetProperty", new Command.Argument("NodeId", (Object)string), new Command.Argument("Key", (Object)string2), new Command.Argument("Value", (Object)string3)));
    }

    public float getPropertyFloat(String string) {
        return RtDataFormat.toNumberFloat(this.getProperty(string));
    }

    public int getPropertyInt(String string) {
        return RtDataFormat.toNumberInt(this.getProperty(string));
    }

    public boolean getPropertyBool(String string) {
        return Boolean.parseBoolean(this.getProperty(string));
    }

    public String getProperty(String string) {
        return this.getProperty(string, true);
    }

    public String getProperty(String string, boolean bl) {
        Command command = new Command("GetProperty", new Command.Argument("Property", (Object)string));
        if (!bl) {
            command.addArgument(new Command.Argument("Log", (Object)false));
        }
        return this.sendCommandThrowIfFail(command).getMessage();
    }

    public String getProperty(Camera camera, String string) {
        return this.getProperty(camera, string, true);
    }

    public String getProperty(Camera camera, String string, boolean bl) {
        Command command = new Command("GetProperty", new Command.Argument("Property", (Object)string), new Command.Argument("CameraId", (Object)camera.getId()));
        if (!bl) {
            command.addArgument(new Command.Argument("Log", (Object)false));
        }
        return this.sendCommandThrowIfFail(command).getMessage();
    }

    public String getProperty(String string, String string2) {
        return this.sendCommandThrowIfFail(new Command("GetProperty", new Command.Argument("NodeId", (Object)string), new Command.Argument("Property", (Object)string2))).getMessage();
    }

    public String getProperty(RemoteMotor remoteMotor, String string, boolean bl) {
        Command command = new Command("GetProperty", new Command.Argument("Property", (Object)string), new Command.Argument("MotorId", (Object)this.deviceRegistry.getDeviceId(remoteMotor)));
        if (!bl) {
            command.addArgument(new Command.Argument("Log", (Object)false));
        }
        return this.sendCommandThrowIfFail(command).getMessage();
    }

    public BufferedImage generateThumbnailFromRaw(BreezeProgressManager breezeProgressManager, File file) {
        PPImportDataHelper.BadPixels badPixels = PPImportDataHelper.getSatMask(file);
        String string = null;
        if (badPixels != null) {
            string = badPixels.toCommaSeparated();
        }
        File file2 = this.generateThumbnailFileFromRaw(breezeProgressManager, file, string);
        try {
            BufferedImage bufferedImage = ImageIO.read(file2);
            return bufferedImage;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            FileUtils.deleteQuietly((File)file2);
        }
    }

    public File generateThumbnailFileFromRaw(BreezeProgressManager breezeProgressManager, File file, String string) {
        Command command = new Command("GenerateThumbnail", new Command.Argument("RawFilePath", file.getAbsoluteFile()));
        if (StringUtils.isNotBlank((CharSequence)string)) {
            command.addArgument(new Command.Argument("BadPixels", (Object)string));
            command.addArgument(new Command.Argument("Log", (Object)false));
        }
        return new File(this.sendCommandThrowIfFail(breezeProgressManager, command, Time.Forever).getMessage());
    }

    public void startCaptureOnPredict(String string, FrameCount frameCount, boolean bl, boolean bl2, boolean bl3) {
        this.sendCommandThrowIfFail(new Command("StartCaptureOnPredict", new Command.Argument("Name", (Object)string), new Command.Argument("MaxFrameCount", (Object)frameCount.value), new Command.Argument("Object", (Object)bl), new Command.Argument("PredictionRaw", (Object)bl2), new Command.Argument("Thumbnail", (Object)bl3)));
    }

    public void stopCaptureOnPredict() {
        this.sendCommandThrowIfFail(new Command("StopCaptureOnPredict", new Command.Argument[0]));
    }

    public void startDiagnostic(File file) {
        this.sendCommandThrowIfFail(new Command("StartDiagnostic", new Command.Argument("File", (Object)file.getAbsolutePath())));
    }

    public void stopDiagnostic() {
        this.sendCommandThrowIfFail(new Command("StopDiagnostic", new Command.Argument[0]), new Time.Minutes(2.0));
    }

    public void applyChanges(BreezeProgress breezeProgress, File file, List<Measurement> list, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.progressGroupIndex = breezeProgress.setGroupMaximumAndReset(list.size());
        this.sendCommandThrowIfFail(breezeProgress, new Command("ApplyChanges", new Command.Argument("XmlFile", (Object)file.getAbsolutePath()), new Command.Argument("FoldersList", TcpManager.getMeasurementPathsAsList(list)), new Command.Argument("UpdateMeasurementXmls", (Object)bl), new Command.Argument("UpdatePredictionFiles", (Object)bl2), new Command.Argument("UpdateThumbnails", (Object)bl3), new Command.Argument("UpdateRootSpectrum", (Object)bl4), new Command.Argument("Reuse", (Object)bl5)), Time.Forever);
    }

    public void applyChangesFiles(BreezeProgress breezeProgress, File file, List<File> list, File file2, boolean bl, boolean bl2) {
        this.progressGroupIndex = breezeProgress.setGroupMaximumAndReset(list.size());
        Command command = new Command("ApplyChanges", new Command.Argument("XmlFile", (Object)file.getAbsolutePath()), new Command.Argument("Files", list.stream().map(File::getAbsolutePath).toList()), new Command.Argument("Reuse", (Object)bl), new Command.Argument("External", (Object)bl2));
        if (file2 != null) {
            command.addArgument(new Command.Argument("OutputFolder", (Object)file2.getAbsolutePath()));
        }
        this.sendCommandThrowIfFail(breezeProgress, command, Time.Forever);
    }

    public void transformData(BreezeProgress breezeProgress, List<Measurement> list, Camera.TransformAlgorithm transformAlgorithm, boolean bl, String string, String string2, boolean bl2) {
        this.progressGroupIndex = breezeProgress.setGroupMaximumAndReset(list.size());
        this.sendCommandThrowIfFail(breezeProgress, new Command("TransformData", new Command.Argument("Folders", TcpManager.getMeasurementPathsAsList(list)), new Command.Argument("Method", (Object)transformAlgorithm.name()), new Command.Argument("Backup", (Object)bl), new Command.Argument("KeypointDetectionOptions", (Object)string), new Command.Argument("Rotate", (Object)string2), new Command.Argument("Reflectance", (Object)bl2)), Time.Forever);
    }

    public void transformData(BreezeProgress breezeProgress, List<Measurement> list, Camera.TransformAlgorithm transformAlgorithm, boolean bl, String string, String string2) {
        this.progressGroupIndex = breezeProgress.setGroupMaximumAndReset(list.size());
        this.sendCommandThrowIfFail(breezeProgress, new Command("TransformData", new Command.Argument("Folders", TcpManager.getMeasurementPathsAsList(list)), new Command.Argument("Method", (Object)transformAlgorithm.name()), new Command.Argument("Backup", (Object)bl), new Command.Argument("KeypointDetectionOptions", (Object)string), new Command.Argument("Rotate", (Object)string2)), Time.Forever);
    }

    public void transformDataMaskSpectrum(BreezeProgress breezeProgress, List<Measurement> list, boolean bl, String string) {
        this.progressGroupIndex = breezeProgress.setGroupMaximumAndReset(list.size());
        this.sendCommandThrowIfFail(breezeProgress, new Command("TransformData", new Command.Argument("Folders", TcpManager.getMeasurementPathsAsList(list)), new Command.Argument("Method", (Object)Camera.TransformAlgorithm.SpectrumMask.name()), new Command.Argument("Backup", (Object)bl), new Command.Argument("Band", (Object)string)), Time.Forever);
    }

    public void transformDataMaskPixels(BreezeProgress breezeProgress, List<Measurement> list, boolean bl, File file, List<SegmentationNode> list2) {
        this.progressGroupIndex = breezeProgress.setGroupMaximumAndReset(list.size());
        this.sendCommandThrowIfFail(breezeProgress, new Command("TransformData", new Command.Argument("Folders", TcpManager.getMeasurementPathsAsList(list)), new Command.Argument("Method", (Object)Camera.TransformAlgorithm.PixelMask.name()), new Command.Argument("Backup", (Object)bl), new Command.Argument("Reflectance", (Object)false), new Command.Argument("XmlFile", (Object)file.getAbsolutePath()), new Command.Argument("SegIds", (Object)list2.stream().map(FunctionTreeNodeWithId::getUid).collect(Collectors.joining(",")))), Time.Forever);
    }

    public void transformDataSmooth(BreezeProgress breezeProgress, List<Measurement> list, boolean bl, int n) {
        this.progressGroupIndex = breezeProgress.setGroupMaximumAndReset(list.size());
        this.sendCommandThrowIfFail(breezeProgress, new Command("TransformData", new Command.Argument("Folders", TcpManager.getMeasurementPathsAsList(list)), new Command.Argument("Method", (Object)Camera.TransformAlgorithm.Smooth.name()), new Command.Argument("Backup", (Object)bl), new Command.Argument("Reflectance", (Object)false), new Command.Argument("KernelSize", (Object)n)), Time.Forever);
    }

    public CommandReply merge(BreezeProgress breezeProgress, File file, List<Measurement> list, String string, File file2) {
        return this.sendCommandThrowIfFail(breezeProgress, new Command("Merge", new Command.Argument("XmlFile", (Object)file.getAbsolutePath()), new Command.Argument("Folders", TcpManager.getMeasurementPathsAsList(list)), new Command.Argument("Type", (Object)string), new Command.Argument("OutputFile", (Object)file2.getAbsolutePath())), Time.Forever);
    }

    private static List<String> getMeasurementPathsAsList(List<Measurement> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Measurement measurement : list) {
            arrayList.add(measurement.getFolder().getAbsolutePath());
        }
        return arrayList;
    }

    public CommandReply ReRender(BreezeProgress breezeProgress, File file, Measurement measurement, String string, boolean bl, long l, boolean bl2) {
        return this.sendCommandThrowIfFail(breezeProgress, new Command("ReRender", new Command.Argument("XmlFile", (Object)file.getAbsolutePath()), new Command.Argument("Folder", (Object)measurement.getFolder().getAbsolutePath()), new Command.Argument("VisualizationVariable", (Object)string), new Command.Argument("VisualizationBlend", (Object)bl), new Command.Argument("FrameOffset", (Object)l), new Command.Argument("UseAnalyseTree", (Object)bl2), new Command.Argument("Log", (Object)false)), Time.Forever);
    }

    public String train(BreezeProgress breezeProgress, File file, File file2, File file3, BasicAnalyse.ModelType modelType, AbstractRuntimeModel.RuntimeSettings runtimeSettings, int n) {
        Command command = new Command("Train", new Command.Argument("DataFile", (Object)file.getAbsolutePath()), new Command.Argument("ModelFilePath", file3), new Command.Argument("Time", (Object)runtimeSettings.time), new Command.Argument("Type", modelType), new Command.Argument("Method", (Object)runtimeSettings.method), new Command.Argument("Metric", (Object)runtimeSettings.metric), new Command.Argument("ValidateAllExperiments", (Object)runtimeSettings.crossValidateAll), new Command.Argument("TopK", (Object)runtimeSettings.topK), new Command.Argument("NumberOfClasses", (Object)n), new Command.Argument("NumberOfFolds", (Object)runtimeSettings.numberOfCvFolds));
        if (file2 != null && file2.length() > 0L) {
            command.addArgument(new Command.Argument("TestDataFile", (Object)file2.getAbsolutePath()));
        }
        CommandReply commandReply = this.sendCommandThrowIfFail(breezeProgress, command, Time.Forever);
        return commandReply.getMessage();
    }

    public String trainANN(BreezeProgress breezeProgress, File file, File file2, File file3, int n, int n2, int[] nArray) {
        Command command = new Command("TrainMachineLearning", new Command.Argument("TrainingDataFile", (Object)file.getAbsolutePath()), new Command.Argument("TestDataFile", (Object)file2.getAbsolutePath()), new Command.Argument("ModelOutputPath", file3), new Command.Argument("NumberOfEpochs", (Object)n), new Command.Argument("NumberOfClasses", (Object)n2), new Command.Argument("HiddenLayers", (Object)StringUtils.join((int[])nArray, (char)';')));
        CommandReply commandReply = this.sendCommandThrowIfFail(breezeProgress, command, Time.Forever);
        return commandReply.getMessage();
    }

    public String[] reshapeImportedOnnxFile(BreezeProgress breezeProgress, File file, File file2, String string) {
        Command command = new Command("OnnxImport", new Command.Argument("FilePath", (Object)file.getAbsolutePath()), new Command.Argument("EvaluationDataFilePath", (Object)file2.getAbsolutePath()), new Command.Argument("ModelType", (Object)string));
        CommandReply commandReply = this.sendCommandThrowIfFail(breezeProgress, command, Time.Forever);
        return commandReply.getMessage().split(";");
    }

    public HashMap<String, String> getMLMethods(String string) {
        if (this.mlMethods.containsKey(string)) {
            return this.mlMethods.get(string);
        }
        Command command = new Command("GetTrainMethods", new Command.Argument("Type", (Object)string));
        CommandReply commandReply = this.sendCommandThrowIfFail(command, Time.Forever);
        String[] stringArray = commandReply.getMessage().split(";");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        this.mlMethods.put(string, hashMap);
        return hashMap;
    }

    public void abortProgress() {
        this.sendCommandThrowIfFail(new Command("AbortProgress", new Command.Argument[0]));
    }

    private CommandReply sendCommandThrowIfFail(Command command) {
        return this.sendCommandThrowIfFail(BreezeProgressImpl.createEmpty(), command, this.getDefaultTimeout());
    }

    private CommandReply sendCommandThrowIfFail(Command command, Time time) {
        return this.sendCommandThrowIfFail(BreezeProgressImpl.createEmpty(), command, time);
    }

    private CommandReply sendCommandThrowIfFail(BreezeProgress breezeProgress, Command command, Time time) {
        CommandReply commandReply = this.sendCommand(breezeProgress, command, time);
        if (!commandReply.hasSucceded()) {
            String string = commandReply.getMessage();
            if (string != null && string.contains("No Breeze Runtime license")) {
                throw new ErrorHandler.InformationMessageException("No Breeze Runtime license\n\nPlease contact sales@prediktera.se");
            }
            throw CommandErrorException.create(command, commandReply);
        }
        return commandReply;
    }

    public Time getDefaultTimeout() {
        return new Time.Seconds(30.0);
    }

    public Time getDefaultLongerTimeout() {
        return new Time.Seconds(90.0);
    }

    private CommandReply sendCommand(Command command) {
        return this.sendCommand(command, this.getDefaultTimeout());
    }

    private CommandReply sendCommand(Command command, Time time) {
        return this.sendCommand(BreezeProgressImpl.createEmpty(), command, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandReply sendCommand(BreezeProgress breezeProgress, Command command, Time time) {
        try {
            BreezeRuntime breezeRuntime;
            this.pManager = breezeProgress;
            if (breezeProgress != null) {
                breezeProgress.addAbortListener(this::abortProgress);
            }
            if (this.commandCallback != null) {
                this.commandCallback.onSend(command);
            }
            if ((breezeRuntime = this.getRemoteConnection()) == null) {
                throw new RuntimeException("Breeze Runtime not available");
            }
            breezeRuntime.send(breezeProgress, command);
            ThreadUtil.awaitOrThrow(() -> {
                ReplyListener replyListener = this.replyListener;
                if (breezeProgress != null && breezeProgress.throwOnAborted() || replyListener == null) {
                    throw new BreezeProgress.ProgressActionCancelledException();
                }
                if (this.eventListener.checkForTimeout()) {
                    throw new RuntimeException("Timeout reaching Breeze Runtime, please try again");
                }
                return replyListener.containsKey(command.getId());
            }, time, "Timeout (" + time.toCompactNiceString() + ") while waiting for reply from BreezeRuntime\n\nCommand: " + String.valueOf(command));
            CommandReply commandReply = this.replyListener.getAndRemove(command.getId());
            if (this.commandCallback != null) {
                this.commandCallback.onReply(commandReply);
            }
            CommandReply commandReply2 = commandReply;
            return commandReply2;
        }
        finally {
            this.pManager = null;
        }
    }

    public boolean hasProgress() {
        return this.pManager != null;
    }

    public void disconnect() {
        if (this.replyListener != null) {
            this.replyListener.close();
            this.replyListener = null;
        }
        if (this.eventListener != null) {
            this.eventListener.close();
            this.eventListener = null;
        }
    }

    public record DataSettings(Boolean available, Float min, Float max, Float inc) {
        public boolean hasSettings() {
            return !this.min.isNaN() || !this.max.isNaN() || !this.inc.isNaN();
        }
    }

    private static class RemoteDeviceRegistry {
        private final HashMap<Object, DeviceInfo> map = new HashMap();

        private RemoteDeviceRegistry() {
        }

        public String getDeviceId(Object object) {
            return this.map.containsKey(object) ? this.map.get((Object)object).deviceId : null;
        }

        public void putCamera(RemoteCamera remoteCamera, OnDisconnectCallback onDisconnectCallback) {
            this.map.put(remoteCamera, new DeviceInfo("Camera", onDisconnectCallback));
        }

        public void put(Object object, String string, OnDisconnectCallback onDisconnectCallback) {
            this.map.put(object, new DeviceInfo(string, onDisconnectCallback));
        }

        public void remove(Object object) {
            this.map.remove(object);
        }

        public void signalDisconnect() {
            for (DeviceInfo deviceInfo : new ArrayList<DeviceInfo>(this.map.values())) {
                if (deviceInfo == null) continue;
                deviceInfo.onDisconnectCallback.onDisconnect();
            }
            this.map.clear();
        }

        private static class DeviceInfo {
            private final String deviceId;
            private final OnDisconnectCallback onDisconnectCallback;

            public DeviceInfo(String string, OnDisconnectCallback onDisconnectCallback) {
                this.deviceId = string;
                this.onDisconnectCallback = onDisconnectCallback;
            }
        }
    }

    public static interface RuntimeEventListener {
        public void onEvent(RuntimeEvent var1);
    }

    public static class ReplyListener
    extends BreezeThread {
        private final BreezeRuntime remoteConnection;
        private boolean running = true;
        private final ReplyMap replyMap = new ReplyMap();
        private final Runnable onDisconnect;

        public ReplyListener(BreezeRuntime breezeRuntime, Runnable runnable) {
            super(ReplyListener.class.getSimpleName());
            this.remoteConnection = breezeRuntime;
            this.onDisconnect = runnable;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    String string = this.remoteConnection.readCommandLine();
                    if (string != null) {
                        if (string.isEmpty()) continue;
                        if (BufferedTcpStream.PrintDebug) {
                            Logg.debug((String)"Reply: {}", (Object[])new Object[]{string});
                        }
                        CommandReply commandReply = new CommandReply(string);
                        this.replyMap.put(commandReply.getId(), commandReply);
                        continue;
                    }
                    Thread.sleep(10L);
                }
                catch (BreezeRuntimeConnection.BreezeRuntimeDisconnectedException breezeRuntimeDisconnectedException) {
                    this.onDisconnect.run();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public CommandReply getAndRemove(String string) {
            return this.replyMap.getAndRemove(string);
        }

        public boolean containsKey(String string) {
            return this.replyMap.containsKey(string);
        }

        public void close() {
            this.running = false;
            this.interrupt();
        }
    }

    public class EventListener
    extends BreezeThread {
        public final int pingTimeout;
        private boolean pingReplied;
        private boolean showToaster;
        private final BreezeRuntime remoteConnection;
        private final Timer timer;
        private boolean running;
        private long lastPing;
        private boolean closeServerOnTimeout;

        public EventListener(BreezeRuntime breezeRuntime) {
            super(EventListener.class.getSimpleName());
            this.pingReplied = true;
            this.showToaster = true;
            this.running = true;
            this.closeServerOnTimeout = false;
            this.remoteConnection = breezeRuntime;
            this.pingTimeout = BreezeProperties.getInstance().getPingTimeout();
            if (BreezeFrame.getRunningProduct().usePing() && BreezeProperties.getInstance().isBreezeRuntimeLocalHost()) {
                this.timer = new Timer("Breeze Runtime Ping Task");
                this.lastPing = System.currentTimeMillis() + (long)this.pingTimeout;
                this.timer.schedule((TimerTask)new RunTimePingChecker(), this.pingTimeout, (long)this.pingTimeout);
            } else {
                this.timer = null;
            }
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    String string = this.remoteConnection.readEventLine();
                    if (string != null) {
                        if (string.isEmpty()) continue;
                        try {
                            RuntimeEvent runtimeEvent;
                            if (BufferedTcpStream.PrintDebug) {
                                Logg.debug((String)"Event: {}", (Object[])new Object[]{string});
                            }
                            if ((runtimeEvent = new RuntimeEvent(new JSONObject(string))).handleAsError()) {
                                ErrorHandler.handleUncaughtException((Throwable)runtimeEvent.toException());
                                continue;
                            }
                            if (runtimeEvent.getCode() == 6000) {
                                Logg.trace((String)"Received ping", (Object[])new Object[0]);
                                this.lastPing = System.currentTimeMillis();
                                continue;
                            }
                            TcpManager.this.sendEventToAllListeners(runtimeEvent);
                        }
                        catch (Exception exception) {
                            Logg.warn((String)"Invalid json: {}", (Object[])new Object[]{string});
                        }
                        continue;
                    }
                    Thread.sleep(10L);
                }
                catch (BreezeRuntimeConnection.BreezeRuntimeDisconnectedException breezeRuntimeDisconnectedException) {
                    TcpManager.this.deviceRegistry.signalDisconnect();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void setCloseServerOnTimeout(boolean bl) {
            this.closeServerOnTimeout = bl;
        }

        public boolean checkForTimeout() {
            if (!this.pingReplied) {
                this.lastPing = System.currentTimeMillis();
                this.pingReplied = true;
                this.showToaster = true;
                if (this.closeServerOnTimeout) {
                    Logg.debug((String)"Timeout reaching Breeze Runtime, restarting", (Object[])new Object[0]);
                    TcpManager.this.deviceRegistry.signalDisconnect();
                    this.remoteConnection.closeServer();
                    this.remoteConnection.startRuntime(BreezeProgressImpl.createEmpty());
                    return true;
                }
            }
            return false;
        }

        public void close() {
            this.running = false;
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.interrupt();
        }

        private class RunTimePingChecker
        extends TimerTask {
            private RunTimePingChecker() {
            }

            @Override
            public void run() {
                if (System.currentTimeMillis() - EventListener.this.lastPing > (long)EventListener.this.pingTimeout) {
                    if (EventListener.this.pingReplied) {
                        Logg.warn((String)"Ping not received within timeout", (Object[])new Object[0]);
                        EventListener.this.pingReplied = false;
                    }
                    EventListener.this.lastPing = System.currentTimeMillis();
                    if (EventListener.this.showToaster) {
                        EventListener.this.showToaster = false;
                    }
                } else if (!EventListener.this.pingReplied) {
                    EventListener.this.pingReplied = true;
                    Logg.trace((String)"Ping received - resetting warning", (Object[])new Object[0]);
                }
            }
        }
    }

    public static interface CommandCallback {
        public void onSend(Command var1);

        public void onReply(CommandReply var1);
    }

    public static interface OnDisconnectCallback {
        public void onDisconnect();
    }

    public static class CommandErrorException
    extends RuntimeException
    implements LogExtraExceptionInterface {
        private final CommandReply reply;
        public String arguments;
        private final AbstractBreezeFunctionInfo functionInfo;
        private final String functionId;

        private CommandErrorException(Command command, CommandReply commandReply, String string, AbstractBreezeFunctionInfo abstractBreezeFunctionInfo, String string2) {
            super(string);
            this.reply = commandReply;
            this.functionInfo = abstractBreezeFunctionInfo;
            this.functionId = string2;
            this.arguments = command.getArguments();
        }

        public static CommandErrorException create(Command command, CommandReply commandReply) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(command.getCommandName());
            stringBuilder.append("\n");
            stringBuilder.append(commandReply.getError());
            stringBuilder.append(" (Code: ");
            stringBuilder.append(commandReply.getCode());
            stringBuilder.append(")\n\n");
            AbstractBreezeFunctionInfo abstractBreezeFunctionInfo = null;
            String string = null;
            String string2 = commandReply.getMessage();
            if (string2 != null && commandReply.getCode() == 3004 && (stringArray = string2.split(":", 2)).length == 2) {
                String[] stringArray2 = stringArray[0].split("_#", 2);
                abstractBreezeFunctionInfo = FunctionHelper.getFunctionInfo(stringArray2[0]);
                if (abstractBreezeFunctionInfo != null) {
                    stringBuilder.append("Method: ");
                    stringBuilder.append(abstractBreezeFunctionInfo.getDescription());
                    string2 = stringArray[1].trim();
                    stringBuilder.append("\n");
                }
                if (stringArray2.length == 2) {
                    string = stringArray2[1];
                }
            }
            stringBuilder.append("Message: ");
            stringBuilder.append(string2);
            return new CommandErrorException(command, commandReply, stringBuilder.toString(), abstractBreezeFunctionInfo, string);
        }

        public CommandReply getReply() {
            return this.reply;
        }

        public AbstractBreezeFunctionInfo getFunctionInfo() {
            return this.functionInfo;
        }

        public String getFunctionId() {
            return this.functionId;
        }

        public String getExtraInformation() {
            return this.arguments;
        }
    }

    public static enum ReferenceAction {
        Take,
        Load,
        LoadIntensity,
        Memory,
        Reference,
        Clear,
        ClearAll,
        Internal,
        InitialExternal,
        InitialInternal,
        QualityCheck;

    }

    public static class ReplyMap {
        private final ConcurrentHashMap<String, CommandReply> map = new ConcurrentHashMap();

        public boolean containsKey(String string) {
            return this.map.containsKey(string);
        }

        public void put(String string, CommandReply commandReply) {
            this.map.put(string, commandReply);
        }

        public CommandReply getAndRemove(String string) {
            return this.map.remove(string);
        }
    }
}

